/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import java.security.MessageDigest;

public class PdfEncryption {
    static final byte[] pad = new byte[]{40, -65, 78, 94, 78, 117, -118, 65, 100, 0, 78, 86, -1, -6, 1, 8, 46, 46, 0, -74, -48, 104, 62, -128, 47, 12, -87, -2, 100, 83, 105, 122};
    byte[] state = new byte[256];
    int x;
    int y;
    byte[] key;
    int keySize;
    byte[] mkey;
    byte[] extra = new byte[5];
    MessageDigest md5;
    byte[] ownerKey = new byte[32];
    byte[] userKey = new byte[32];
    int permissions;
    byte[] documentID;
    static long seq = System.currentTimeMillis();

    public PdfEncryption() {
        try {
            this.md5 = MessageDigest.getInstance("MD5");
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public PdfEncryption(PdfEncryption pdfEncryption) {
        this();
        this.mkey = (byte[])pdfEncryption.mkey.clone();
        this.ownerKey = (byte[])pdfEncryption.ownerKey.clone();
        this.userKey = (byte[])pdfEncryption.userKey.clone();
        this.permissions = pdfEncryption.permissions;
        if (pdfEncryption.documentID != null) {
            this.documentID = (byte[])pdfEncryption.documentID.clone();
        }
    }

    private byte[] padPassword(byte[] byArray) {
        byte[] byArray2 = new byte[32];
        if (byArray == null) {
            System.arraycopy(pad, 0, byArray2, 0, 32);
        } else {
            System.arraycopy(byArray, 0, byArray2, 0, Math.min(byArray.length, 32));
            if (byArray.length < 32) {
                System.arraycopy(pad, 0, byArray2, byArray.length, 32 - byArray.length);
            }
        }
        return byArray2;
    }

    private byte[] computeOwnerKey(byte[] byArray, byte[] byArray2, int n, int n2) {
        byte[] byArray3 = new byte[32];
        byte[] byArray4 = this.md5.digest(byArray2);
        if (n2 == 3) {
            int n3;
            byte[] byArray5 = new byte[n / 8];
            for (n3 = 0; n3 < 50; ++n3) {
                System.arraycopy(this.md5.digest(), 0, byArray4, 0, byArray5.length);
            }
            System.arraycopy(byArray, 0, byArray3, 0, 32);
            for (n3 = 0; n3 < 20; ++n3) {
                for (int i = 0; i < byArray5.length; ++i) {
                    byArray5[i] = (byte)(byArray4[i] ^ n3);
                }
                this.prepareRC4Key(byArray5);
                this.encryptRC4(byArray3);
            }
        } else {
            this.prepareRC4Key(byArray4, 0, 5);
            this.encryptRC4(byArray, byArray3);
        }
        return byArray3;
    }

    private void setupGlobalEncryptionKey(byte[] byArray, byte[] byArray2, byte[] byArray3, int n, int n2, int n3) {
        this.documentID = byArray;
        this.ownerKey = byArray3;
        this.permissions = n;
        this.mkey = new byte[n2 / 8];
        this.md5.reset();
        this.md5.update(byArray2);
        this.md5.update(byArray3);
        byte[] byArray4 = new byte[]{(byte)n, (byte)(n >> 8), (byte)(n >> 16), (byte)(n >> 24)};
        this.md5.update(byArray4, 0, 4);
        if (byArray != null) {
            this.md5.update(byArray);
        }
        byte[] byArray5 = new byte[this.mkey.length];
        System.arraycopy(this.md5.digest(), 0, byArray5, 0, this.mkey.length);
        if (n3 == 3) {
            for (int i = 0; i < 50; ++i) {
                System.arraycopy(this.md5.digest(byArray5), 0, byArray5, 0, this.mkey.length);
            }
        }
        System.arraycopy(byArray5, 0, this.mkey, 0, this.mkey.length);
    }

    private void setupUserKey(int n) {
        if (n == 3) {
            int n2;
            this.md5.update(pad);
            byte[] byArray = this.md5.digest(this.documentID);
            System.arraycopy(byArray, 0, this.userKey, 0, 16);
            for (n2 = 16; n2 < 32; ++n2) {
                this.userKey[n2] = 0;
            }
            for (n2 = 0; n2 < 20; ++n2) {
                for (int i = 0; i < this.mkey.length; ++i) {
                    byArray[i] = (byte)(this.mkey[i] ^ n2);
                }
                this.prepareRC4Key(byArray, 0, this.mkey.length);
                this.encryptRC4(this.userKey, 0, 16);
            }
        } else {
            this.prepareRC4Key(this.mkey);
            this.encryptRC4(pad, this.userKey);
        }
    }

    public void setupAllKeys(byte[] byArray, byte[] byArray2, int n, int n2, int n3) {
        if (byArray2 == null || byArray2.length == 0) {
            byArray2 = this.md5.digest(PdfEncryption.createDocumentId());
        }
        n |= n3 == 3 ? -3904 : -64;
        byte[] byArray3 = this.padPassword(byArray);
        byte[] byArray4 = this.padPassword(byArray2);
        this.ownerKey = this.computeOwnerKey(byArray3, byArray4, n2, n3);
        this.documentID = PdfEncryption.createDocumentId();
        this.setupByUserPad(this.documentID, byArray3, this.ownerKey, n &= 0xFFFFFFFC, n2, n3);
    }

    public void setupAllKeys(byte[] byArray, byte[] byArray2, int n, boolean bl) {
        this.setupAllKeys(byArray, byArray2, n, bl ? 128 : 40, bl ? 3 : 2);
    }

    public static byte[] createDocumentId() {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        long l = System.currentTimeMillis();
        long l2 = Runtime.getRuntime().freeMemory();
        String string = l + "+" + l2 + "+" + seq++;
        return messageDigest.digest(string.getBytes());
    }

    public void setupByUserPassword(byte[] byArray, byte[] byArray2, byte[] byArray3, int n, boolean bl) {
        this.setupByUserPassword(byArray, byArray2, byArray3, n, bl ? 128 : 40, bl ? 3 : 2);
    }

    public void setupByUserPassword(byte[] byArray, byte[] byArray2, byte[] byArray3, int n, int n2, int n3) {
        this.setupByUserPad(byArray, this.padPassword(byArray2), byArray3, n, n2, n3);
    }

    private void setupByUserPad(byte[] byArray, byte[] byArray2, byte[] byArray3, int n, int n2, int n3) {
        this.setupGlobalEncryptionKey(byArray, byArray2, byArray3, n, n2, n3);
        this.setupUserKey(n3);
    }

    public void setupByOwnerPassword(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n, boolean bl) {
        this.setupByOwnerPassword(byArray, byArray2, byArray3, byArray4, n, bl ? 128 : 40, bl ? 3 : 2);
    }

    public void setupByOwnerPassword(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n, int n2, int n3) {
        this.setupByOwnerPad(byArray, this.padPassword(byArray2), byArray3, byArray4, n, n2, n3);
    }

    private void setupByOwnerPad(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n, int n2, int n3) {
        byte[] byArray5 = this.computeOwnerKey(byArray4, byArray2, n2, n3);
        this.setupGlobalEncryptionKey(byArray, byArray5, byArray4, n, n2, n3);
        this.setupUserKey(n3);
    }

    public void prepareKey() {
        this.prepareRC4Key(this.key, 0, this.keySize);
    }

    public void setHashKey(int n, int n2) {
        this.md5.reset();
        this.extra[0] = (byte)n;
        this.extra[1] = (byte)(n >> 8);
        this.extra[2] = (byte)(n >> 16);
        this.extra[3] = (byte)n2;
        this.extra[4] = (byte)(n2 >> 8);
        this.md5.update(this.mkey);
        this.key = this.md5.digest(this.extra);
        this.keySize = this.mkey.length + 5;
        if (this.keySize > 16) {
            this.keySize = 16;
        }
    }

    public static PdfObject createInfoId(byte[] byArray) {
        int n;
        ByteBuffer byteBuffer = new ByteBuffer(90);
        byteBuffer.append('[').append('<');
        for (n = 0; n < 16; ++n) {
            byteBuffer.appendHex(byArray[n]);
        }
        byteBuffer.append('>').append('<');
        byArray = PdfEncryption.createDocumentId();
        for (n = 0; n < 16; ++n) {
            byteBuffer.appendHex(byArray[n]);
        }
        byteBuffer.append('>').append(']');
        return new PdfLiteral(byteBuffer.toByteArray());
    }

    public PdfDictionary getEncryptionDictionary() {
        PdfDictionary pdfDictionary = new PdfDictionary();
        pdfDictionary.put(PdfName.FILTER, PdfName.STANDARD);
        pdfDictionary.put(PdfName.O, new PdfLiteral(PdfContentByte.escapeString(this.ownerKey)));
        pdfDictionary.put(PdfName.U, new PdfLiteral(PdfContentByte.escapeString(this.userKey)));
        pdfDictionary.put(PdfName.P, new PdfNumber(this.permissions));
        if (this.mkey.length > 5) {
            pdfDictionary.put(PdfName.V, new PdfNumber(2));
            pdfDictionary.put(PdfName.R, new PdfNumber(3));
            pdfDictionary.put(PdfName.LENGTH, new PdfNumber(128));
        } else {
            pdfDictionary.put(PdfName.V, new PdfNumber(1));
            pdfDictionary.put(PdfName.R, new PdfNumber(2));
        }
        return pdfDictionary;
    }

    public void prepareRC4Key(byte[] byArray) {
        this.prepareRC4Key(byArray, 0, byArray.length);
    }

    public void prepareRC4Key(byte[] byArray, int n, int n2) {
        int n3;
        int n4 = 0;
        int n5 = 0;
        for (n3 = 0; n3 < 256; ++n3) {
            this.state[n3] = (byte)n3;
        }
        this.x = 0;
        this.y = 0;
        for (int i = 0; i < 256; ++i) {
            n5 = byArray[n4 + n] + this.state[i] + n5 & 0xFF;
            n3 = this.state[i];
            this.state[i] = this.state[n5];
            this.state[n5] = n3;
            n4 = (n4 + 1) % n2;
        }
    }

    public void encryptRC4(byte[] byArray, int n, int n2, byte[] byArray2) {
        int n3 = n2 + n;
        for (int i = n; i < n3; ++i) {
            this.x = this.x + 1 & 0xFF;
            this.y = this.state[this.x] + this.y & 0xFF;
            byte by = this.state[this.x];
            this.state[this.x] = this.state[this.y];
            this.state[this.y] = by;
            byArray2[i] = (byte)(byArray[i] ^ this.state[this.state[this.x] + this.state[this.y] & 0xFF]);
        }
    }

    public void encryptRC4(byte[] byArray, int n, int n2) {
        this.encryptRC4(byArray, n, n2, byArray);
    }

    public void encryptRC4(byte[] byArray, byte[] byArray2) {
        this.encryptRC4(byArray, 0, byArray.length, byArray2);
    }

    public void encryptRC4(byte[] byArray) {
        this.encryptRC4(byArray, 0, byArray.length, byArray);
    }

    public PdfObject getFileID() {
        return PdfEncryption.createInfoId(this.documentID);
    }
}

