/*
 * Decompiled with CFR 0.152.
 */
package org.freeloader;

import java.applet.Applet;
import java.applet.AppletStub;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;

public class FreeLoader
extends Applet
implements Runnable,
AppletStub {
    static Hashtable classes;
    Applet applet;
    int classesLoaded = -1;
    int FRAMERATE = 60;
    Image img;
    Thread loading;
    int numOfClasses;
    Graphics2D og;
    Color bgC = new Color(255, 255, 255);
    Color fgC = new Color(0, 0, 0);
    int NUM_CIRCLES = 10;
    double RING_RADIUS = 0.0;
    double CIRCLE_SPACING = 0.75;
    Ellipse2D[] circles;
    RoundRectangle2D.Float progress;
    RoundRectangle2D.Float innerProgress;
    Color progC;
    Font f;
    double stringWidth;
    String preloadMessage = "";
    long start = System.currentTimeMillis();
    static final int FRAMES_PER_REVOLUTION = 120;
    static final double BLEND_DIST = 0.75;
    static final double BLEND_FORWARD = 0.15;
    int frameCount = 0;
    int effectType = 0;
    double effectAmount = 0.0;
    int rotationAmount = 0;
    boolean goingUp = true;
    public final String PARAM_SPLIT = "!!###!!";

    public void calcFontSize() {
        String string = this.getParameter("FreeLoader_loadingMessage");
        if (string == null) {
            string = "Loading Java applet...";
        }
        this.preloadMessage = string;
        this.f = new Font("SansSerif", 0, 24);
        Font font = this.f.deriveFont(100.0f);
        double d = this.og.getFontMetrics(font).getStringBounds(string, this.og).getWidth() / 100.0;
        double d2 = (double)this.getWidth() * 0.75 / d;
        d2 = Math.min(32.0, d2);
        d2 = Math.min((double)(this.getHeight() / 4), d2);
        if (d2 <= 5.0) {
            this.preloadMessage = "";
        }
        this.stringWidth = d2 * d;
        this.f = this.f.deriveFont((float)d2);
        this.setFont(this.f);
    }

    public Color parseColor(String string) {
        if (string.startsWith("#")) {
            return Color.decode(string);
        }
        string = string.replaceAll("[()]", "");
        String[] stringArray = string.split(",");
        return new Color(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]));
    }

    public void initGraphics() {
        if (this.og != null) {
            return;
        }
        this.img = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        if (this.img == null) {
            return;
        }
        this.og = (Graphics2D)this.img.getGraphics();
        if (this.og == null) {
            return;
        }
        this.og.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.og.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.calcFontSize();
        String string = this.getParameter("bgcolor");
        this.bgC = string != null ? this.parseColor(string) : new Color(255, 255, 255);
        String string2 = this.getParameter("fgcolor");
        this.fgC = string2 != null ? this.parseColor(string2) : this.parseColor("#3399CC");
        this.progC = this.tintColor(this.fgC, this.bgC, 0.25);
        float f = 0.0f;
        float f2 = 0.0f;
        double d = Math.min(this.getHeight(), this.getWidth());
        this.RING_RADIUS = Math.max(d / 15.0, 10.0);
        this.NUM_CIRCLES = 10;
        double d2 = Math.PI * 2 / (double)this.NUM_CIRCLES;
        double d3 = 0.0;
        double d4 = this.RING_RADIUS * Math.PI / (double)this.NUM_CIRCLES;
        d4 *= this.CIRCLE_SPACING;
        this.circles = new Ellipse2D[this.NUM_CIRCLES];
        for (int i = 0; i < this.circles.length; ++i) {
            Ellipse2D.Double double_ = new Ellipse2D.Double();
            double d5 = (double)f + this.RING_RADIUS * Math.cos(d3);
            double d6 = (double)f2 + this.RING_RADIUS * Math.sin(d3);
            double_.setFrameFromCenter(d5, d6, d5 + d4, d6 + d4);
            this.circles[i] = double_;
            d3 += d2;
        }
        this.progress = new RoundRectangle2D.Float();
        this.innerProgress = new RoundRectangle2D.Float();
        this.progress.setRoundRect((double)(-this.getWidth() / 4), -this.RING_RADIUS, (double)(this.getWidth() / 2), this.RING_RADIUS, this.RING_RADIUS / 10.0, this.RING_RADIUS / 10.0);
        this.repaint();
    }

    public void destroy() {
        if (this.applet != null) {
            this.applet.destroy();
            return;
        }
    }

    public void init() {
        this.initGraphics();
        this.setLayout(null);
        this.setBackground(this.bgC);
        if (classes == null) {
            classes = new Hashtable();
        }
    }

    public void loadImage(String string) {
        Image image = null;
        int n = 0;
        int n2 = 0;
        image = this.getImage(this.getDocumentBase(), string);
        n = -1;
        n2 = -1;
        while (n < 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            n = image.getWidth(this);
        }
        while (n2 < 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                System.out.println(interruptedException);
            }
            n2 = image.getHeight(this);
        }
    }

    public Color tintColor(Color color, Color color2, double d) {
        int n = color.getRed() + (int)((double)(color2.getRed() - color.getRed()) * d);
        int n2 = color.getGreen() + (int)((double)(color2.getGreen() - color.getGreen()) * d);
        int n3 = color.getBlue() + (int)((double)(color2.getBlue() - color.getBlue()) * d);
        return new Color(n, n2, n3);
    }

    public void paint(Graphics graphics) {
        double d;
        ++this.frameCount;
        ++this.rotationAmount;
        if (this.frameCount >= this.FRAMERATE * 10) {
            if (this.effectAmount == 0.0 && this.effectType != 2) {
                this.effectType = 2;
                this.rotationAmount = 0;
            }
        } else if (this.frameCount == this.FRAMERATE * 5) {
            this.effectType = 1;
            this.effectAmount = 0.0;
        }
        if (this.goingUp) {
            this.effectAmount += (double)0.01f;
            if (this.effectAmount >= 1.0) {
                this.goingUp = false;
                this.effectAmount = 1.0;
            }
        } else {
            this.effectAmount -= (double)0.01f;
            if (this.effectAmount <= 0.0) {
                this.goingUp = true;
                this.effectAmount = 0.0;
            }
        }
        this.og.setColor(this.bgC);
        this.og.fillRect(0, 0, this.getWidth(), this.getHeight());
        float f = this.getWidth() / 2;
        float f2 = this.getHeight() / 2;
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(0.0, 0.0);
        if (this.classesLoaded < 1) {
            d = this.frameCount % 120;
            double d2 = d / 120.0;
            for (int i = 0; i < this.circles.length; ++i) {
                double d3 = 1.0f - (float)i / (float)this.circles.length;
                double d4 = d3 + d2;
                double d5 = Math.min((d4 %= 1.0) / 0.75, 1.0);
                if (d4 >= 0.0 && d4 <= 0.15) {
                    d5 = 1.0 - d4 / 0.15;
                }
                Color color = this.tintColor(this.fgC, this.bgC, d5);
                this.og.setPaint(color);
                affineTransform.setToIdentity();
                affineTransform.translate(f, f2);
                double d6 = 1.0;
                switch (this.effectType) {
                    case 0: {
                        affineTransform.scale(1.0, 1.0);
                        break;
                    }
                    case 1: {
                        d6 = Math.min(1.0, d4 + (1.0 - this.effectAmount));
                        affineTransform.scale(d6, d6);
                        break;
                    }
                    case 2: {
                        d6 = Math.min(1.0, d4 + (1.0 - this.effectAmount));
                        affineTransform.scale(d6, d6);
                        double d7 = (double)this.rotationAmount / (double)this.FRAMERATE / 2.0;
                        affineTransform.rotate(-d7 * Math.PI * 2.0 / (double)this.circles.length);
                        break;
                    }
                    case 3: {
                        d6 = Math.min(1.0, d4 + (1.0 - this.effectAmount));
                        affineTransform.scale(d6, d6);
                        double d7 = (double)this.rotationAmount / (double)this.FRAMERATE / 2.0;
                        affineTransform.rotate(-d7 * Math.PI * 2.0 / (double)this.circles.length);
                        affineTransform.translate(Math.random() * 10.0 * this.effectAmount, Math.random() * 10.0 * this.effectAmount);
                    }
                }
                this.og.fill(affineTransform.createTransformedShape(this.circles[i]));
            }
        } else {
            d = (double)this.classesLoaded / (double)this.numOfClasses;
            Shape shape = affineTransform.createTransformedShape(this.progress);
            this.innerProgress.setRoundRect(this.progress.getMinX(), this.progress.getMinY(), this.progress.getWidth() * d, this.progress.getHeight(), this.progress.getArcWidth(), this.progress.getArcHeight());
            Shape shape2 = affineTransform.createTransformedShape(this.innerProgress);
            this.og.setPaint(this.progC);
            this.og.fill(shape2);
            this.og.setPaint(this.fgC);
            this.og.setStroke(new BasicStroke((float)this.progress.getHeight() / 10.0f));
            this.og.draw(shape);
        }
        if (!(this.RING_RADIUS * 2.0 > (double)(this.getHeight() / 4))) {
            this.og.setFont(this.f);
            this.og.setColor(this.fgC);
            int n = (int)((double)f - this.stringWidth / 2.0);
            int n2 = (int)((double)f2 - (double)this.f.getSize2D() * 0.75 - this.RING_RADIUS);
            this.og.drawString(this.preloadMessage, n, n2);
        }
        graphics.drawImage(this.img, 0, 0, null);
    }

    public void run() {
        long l = System.currentTimeMillis();
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            public void run() {
                FreeLoader.this.repaint();
            }
        }, 0L, (long)(1000 / this.FRAMERATE));
        this.repaint();
        if (this.applet != null) {
            return;
        }
        try {
            String string;
            String string2 = this.getParameter("FreeLoader_minimumLoadingTime");
            long l2 = l;
            if (string2 != null) {
                l2 = l + (long)Integer.parseInt(string2);
            }
            if ((string = this.getParameter("FreeLoader_mainClass")) != null && classes.get(string) == null) {
                String string3 = this.getParameter("FreeLoader_classList");
                if (string3 == null) {
                    string3 = "";
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
                this.numOfClasses = stringTokenizer.countTokens();
                this.repaint();
                Thread.sleep(50L);
                this.repaint();
                this.classesLoaded = 0;
                while (this.classesLoaded < this.numOfClasses) {
                    String string4 = stringTokenizer.nextToken().trim();
                    Class<?> clazz = Class.forName(string4);
                    classes.put(clazz, new Integer(1));
                    ++this.classesLoaded;
                    Thread.sleep(50L);
                }
            }
            while (System.currentTimeMillis() < l2) {
                Thread.sleep(100L);
            }
            if (string == null) {
                string = "java.applet.Applet";
                return;
            }
            if (this.applet == null) {
                this.applet = (Applet)Class.forName(string).newInstance();
            }
            this.applet.setStub(this);
            this.add(this.applet);
            this.applet.setBounds(0, 0, this.getWidth(), this.getHeight());
            this.applet.init();
            this.applet.validate();
            this.applet.setVisible(true);
            this.applet.start();
            timer.cancel();
            timer.purge();
            timer = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void start() {
        this.loading = new Thread(this);
        this.loading.start();
    }

    public void stop() {
        if (this.applet != null) {
            this.applet.stop();
            return;
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void callMethod(String string, String string2) throws Exception {
        Object[] objectArray = string2.split("!!###!!");
        this.callMethod(string, objectArray);
    }

    public void callMethod(String string) throws Exception {
        this.callMethod(string, new Object[0]);
    }

    private Object callMethod(String string, Object[] objectArray) throws Exception {
        Applet applet = this;
        if (this.applet != null) {
            applet = this.applet;
        }
        Class[] classArray = new Class[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            classArray[i] = objectArray[i].getClass();
        }
        try {
            Method method = applet.getClass().getMethod(string, classArray);
            Object object = method.invoke((Object)applet, objectArray);
            return object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void setMessage(String string) {
        this.preloadMessage = string;
    }

    public void appletResize(int n, int n2) {
        this.resize(n, n2);
    }
}

