/*
 * Decompiled with CFR 0.152.
 */
package processing.xml;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import processing.core.PApplet;
import processing.xml.XMLParseException;

public class XMLElement {
    static final boolean DEBUG = false;
    private Hashtable attributes;
    private Vector children;
    private String name;
    private String content;
    private Hashtable entities;
    private boolean ignoreUnknownEntities = true;
    private boolean ignoreMissingAttributes = true;
    private int lineNumber;
    private boolean ignoreCase;
    private boolean ignoreWhitespace;
    private char charReadTooMuch;
    private Reader reader;
    private int parserLineNumber;

    public XMLElement() {
        this(new Hashtable(), false, true, false);
    }

    public XMLElement(Hashtable hashtable) {
        this(hashtable, false, true, true);
    }

    public XMLElement(boolean bl) {
        this(new Hashtable(), bl, true, true);
    }

    public XMLElement(Hashtable hashtable, boolean bl) {
        this(hashtable, bl, true, true);
    }

    public XMLElement(Hashtable hashtable, boolean bl, boolean bl2) {
        this(hashtable, bl, true, bl2);
    }

    protected XMLElement(Hashtable hashtable, boolean bl, boolean bl2, boolean bl3) {
        this.ignoreWhitespace = bl;
        this.ignoreCase = bl3;
        this.name = null;
        this.content = "";
        this.attributes = new Hashtable();
        this.children = new Vector();
        this.entities = hashtable;
        this.lineNumber = 0;
        Enumeration enumeration = this.entities.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object object = this.entities.get(k);
            if (!(object instanceof String)) continue;
            object = ((String)object).toCharArray();
            this.entities.put(k, object);
        }
        if (bl2) {
            this.entities.put("amp", new char[]{'&'});
            this.entities.put("quot", new char[]{'\"'});
            this.entities.put("apos", new char[]{'\''});
            this.entities.put("lt", new char[]{'<'});
            this.entities.put("gt", new char[]{'>'});
        }
    }

    public XMLElement(PApplet pApplet, String string) {
        this();
        try {
            BufferedReader bufferedReader = pApplet.createReader(string);
            if (bufferedReader == null) {
                System.err.println("The file " + string + " could not be found.");
                return;
            }
            this.parseFromReader(bufferedReader);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public XMLElement(Reader reader) throws IOException {
        this();
        this.parseFromReader(reader);
    }

    public XMLElement(InputStream inputStream) throws IOException {
        this();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        this.parseFromReader(inputStreamReader);
    }

    public void addChild(XMLElement xMLElement) {
        this.children.addElement(xMLElement);
    }

    public void setAttribute(String string, Object object) {
        if (this.ignoreCase) {
            string = string.toUpperCase();
        }
        this.attributes.put(string, object.toString());
    }

    public void setIntAttribute(String string, int n) {
        if (this.ignoreCase) {
            string = string.toUpperCase();
        }
        this.attributes.put(string, Integer.toString(n));
    }

    public void setDoubleAttribute(String string, double d) {
        if (this.ignoreCase) {
            string = string.toUpperCase();
        }
        this.attributes.put(string, Double.toString(d));
    }

    public int getChildCount() {
        return this.children.size();
    }

    public Enumeration enumerateAttributeNames() {
        return this.attributes.keys();
    }

    public Enumeration enumerateChildren() {
        return this.children.elements();
    }

    public XMLElement[] getChildren() {
        int n = this.getChildCount();
        Object[] objectArray = new XMLElement[n];
        this.children.copyInto(objectArray);
        return objectArray;
    }

    public XMLElement getChild(int n) {
        return (XMLElement)this.children.elementAt(n);
    }

    public String getContent() {
        return this.content;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public boolean hasAttribute(String string) {
        return this.getAttribute(string) != null;
    }

    public Object getAttribute(String string) {
        return this.getAttribute(string, null);
    }

    public Object getAttribute(String string, Object object) {
        Object object2;
        if (this.ignoreCase) {
            string = string.toUpperCase();
        }
        if ((object2 = this.attributes.get(string)) == null) {
            object2 = object;
        }
        return object2;
    }

    public Object getAttribute(String string, Hashtable hashtable, String string2, boolean bl) {
        Object v;
        Object object;
        if (this.ignoreCase) {
            string = string.toUpperCase();
        }
        if ((object = this.attributes.get(string)) == null) {
            object = string2;
        }
        if ((v = hashtable.get(object)) == null) {
            if (bl) {
                v = object;
            } else {
                throw this.invalidValue(string, (String)object);
            }
        }
        return v;
    }

    public String getStringAttribute(String string) {
        return this.getStringAttribute(string, null);
    }

    public String getStringAttribute(String string, String string2) {
        return (String)this.getAttribute(string, string2);
    }

    public String getStringAttribute(String string, Hashtable hashtable, String string2, boolean bl) {
        return (String)this.getAttribute(string, hashtable, string2, bl);
    }

    public int getIntAttribute(String string) {
        return this.getIntAttribute(string, 0);
    }

    public int getIntAttribute(String string, int n) {
        String string2;
        if (this.ignoreCase) {
            string = string.toUpperCase();
        }
        if ((string2 = (String)this.attributes.get(string)) == null) {
            return n;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.invalidValue(string, string2);
        }
    }

    public int getIntAttribute(String string, Hashtable hashtable, String string2, boolean bl) {
        Integer n;
        Object object;
        if (this.ignoreCase) {
            string = string.toUpperCase();
        }
        if ((object = this.attributes.get(string)) == null) {
            object = string2;
        }
        try {
            n = (Integer)hashtable.get(object);
        }
        catch (ClassCastException classCastException) {
            throw this.invalidValueSet(string);
        }
        if (n == null) {
            if (!bl) {
                throw this.invalidValue(string, (String)object);
            }
            try {
                n = Integer.valueOf((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw this.invalidValue(string, (String)object);
            }
        }
        return n;
    }

    public float getFloatAttribute(String string) {
        return this.getFloatAttribute(string, 0.0f);
    }

    public float getFloatAttribute(String string, float f) {
        String string2;
        if (this.ignoreCase) {
            string = string.toUpperCase();
        }
        if ((string2 = (String)this.attributes.get(string)) == null) {
            return f;
        }
        try {
            return Float.valueOf(string2).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            throw this.invalidValue(string, string2);
        }
    }

    public float getFloatAttribute(String string, Hashtable hashtable, String string2, boolean bl) {
        Float f;
        Object object;
        if (this.ignoreCase) {
            string = string.toUpperCase();
        }
        if ((object = this.attributes.get(string)) == null) {
            object = string2;
        }
        try {
            f = (Float)hashtable.get(object);
        }
        catch (ClassCastException classCastException) {
            throw this.invalidValueSet(string);
        }
        if (f == null) {
            if (!bl) {
                throw this.invalidValue(string, (String)object);
            }
            try {
                f = Float.valueOf((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw this.invalidValue(string, (String)object);
            }
        }
        return f.floatValue();
    }

    public double getDoubleAttribute(String string) {
        return this.getDoubleAttribute(string, 0.0);
    }

    public double getDoubleAttribute(String string, double d) {
        String string2;
        if (this.ignoreCase) {
            string = string.toUpperCase();
        }
        if ((string2 = (String)this.attributes.get(string)) == null) {
            return d;
        }
        try {
            return Double.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.invalidValue(string, string2);
        }
    }

    public double getDoubleAttribute(String string, Hashtable hashtable, String string2, boolean bl) {
        Double d;
        Object object;
        if (this.ignoreCase) {
            string = string.toUpperCase();
        }
        if ((object = this.attributes.get(string)) == null) {
            object = string2;
        }
        try {
            d = (Double)hashtable.get(object);
        }
        catch (ClassCastException classCastException) {
            throw this.invalidValueSet(string);
        }
        if (d == null) {
            if (!bl) {
                throw this.invalidValue(string, (String)object);
            }
            try {
                d = Double.valueOf((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw this.invalidValue(string, (String)object);
            }
        }
        return d;
    }

    public boolean getBooleanAttribute(String string, String string2, String string3, boolean bl) {
        Object v;
        if (this.ignoreCase) {
            string = string.toUpperCase();
        }
        if ((v = this.attributes.get(string)) == null) {
            return bl;
        }
        if (v.equals(string2)) {
            return true;
        }
        if (v.equals(string3)) {
            return false;
        }
        throw this.invalidValue(string, (String)v);
    }

    public String getName() {
        return this.name;
    }

    public void parseFromReader(Reader reader) throws IOException, XMLParseException {
        this.parseFromReader(reader, 1);
    }

    public void parseFromReader(Reader reader, int n) throws IOException, XMLParseException {
        char c;
        this.name = null;
        this.content = "";
        this.attributes = new Hashtable();
        this.children = new Vector();
        this.charReadTooMuch = '\u0000';
        this.reader = reader;
        this.parserLineNumber = n;
        while (true) {
            if ((c = this.scanWhitespace()) != '<') {
                throw this.expectedInput("<");
            }
            c = this.readChar();
            if (c != '!' && c != '?') break;
            this.skipSpecialTag(0);
        }
        this.unreadChar(c);
        this.scanElement(this);
    }

    public void parseString(String string) throws XMLParseException {
        try {
            this.parseFromReader(new StringReader(string), 1);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void parseString(String string, int n) throws XMLParseException {
        this.parseString(string.substring(n));
    }

    public void parseString(String string, int n, int n2) throws XMLParseException {
        this.parseString(string.substring(n, n2));
    }

    public void parseString(String string, int n, int n2, int n3) throws XMLParseException {
        string = string.substring(n, n2);
        try {
            this.parseFromReader(new StringReader(string), n3);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void parseCharArray(char[] cArray, int n, int n2) throws XMLParseException {
        this.parseCharArray(cArray, n, n2, 1);
    }

    public void parseCharArray(char[] cArray, int n, int n2, int n3) throws XMLParseException {
        try {
            CharArrayReader charArrayReader = new CharArrayReader(cArray, n, n2);
            this.parseFromReader(charArrayReader, n3);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void removeChild(XMLElement xMLElement) {
        this.children.removeElement(xMLElement);
    }

    public void removeAttribute(String string) {
        if (this.ignoreCase) {
            string = string.toUpperCase();
        }
        this.attributes.remove(string);
    }

    protected XMLElement createAnotherElement() {
        return new XMLElement(this.entities, this.ignoreWhitespace, false, this.ignoreCase);
    }

    public void setContent(String string) {
        this.content = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String toString() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
            this.write(outputStreamWriter);
            outputStreamWriter.flush();
            return new String(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            return super.toString();
        }
    }

    public void write(Writer writer) throws IOException {
        Object object;
        Enumeration enumeration;
        if (this.name == null) {
            this.writeEncoded(writer, this.content);
            return;
        }
        writer.write(60);
        writer.write(this.name);
        if (!this.attributes.isEmpty()) {
            enumeration = this.attributes.keys();
            while (enumeration.hasMoreElements()) {
                writer.write(32);
                object = (String)enumeration.nextElement();
                String string = (String)this.attributes.get(object);
                writer.write((String)object);
                writer.write(61);
                writer.write(34);
                this.writeEncoded(writer, string);
                writer.write(34);
            }
        }
        if (this.content != null && this.content.length() > 0) {
            writer.write(62);
            this.writeEncoded(writer, this.content);
            writer.write(60);
            writer.write(47);
            writer.write(this.name);
            writer.write(62);
        } else if (this.children.isEmpty()) {
            writer.write(47);
            writer.write(62);
        } else {
            writer.write(62);
            enumeration = this.enumerateChildren();
            while (enumeration.hasMoreElements()) {
                object = (XMLElement)enumeration.nextElement();
                ((XMLElement)object).write(writer);
            }
            writer.write(60);
            writer.write(47);
            writer.write(this.name);
            writer.write(62);
        }
    }

    protected void writeEncoded(Writer writer, String string) throws IOException {
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    writer.write(38);
                    writer.write(108);
                    writer.write(116);
                    writer.write(59);
                    continue block7;
                }
                case '>': {
                    writer.write(38);
                    writer.write(103);
                    writer.write(116);
                    writer.write(59);
                    continue block7;
                }
                case '&': {
                    writer.write(38);
                    writer.write(97);
                    writer.write(109);
                    writer.write(112);
                    writer.write(59);
                    continue block7;
                }
                case '\"': {
                    writer.write(38);
                    writer.write(113);
                    writer.write(117);
                    writer.write(111);
                    writer.write(116);
                    writer.write(59);
                    continue block7;
                }
                case '\'': {
                    writer.write(38);
                    writer.write(97);
                    writer.write(112);
                    writer.write(111);
                    writer.write(115);
                    writer.write(59);
                    continue block7;
                }
                default: {
                    char c2 = c;
                    if (c2 < ' ' || c2 > '~') {
                        writer.write(38);
                        writer.write(35);
                        writer.write(120);
                        writer.write(Integer.toString(c2, 16));
                        writer.write(59);
                        continue block7;
                    }
                    writer.write(c);
                }
            }
        }
    }

    protected void scanIdentifier(StringBuffer stringBuffer) throws IOException {
        while (true) {
            char c;
            if (!((c = this.readChar()) >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_' || c == '.' || c == ':' || c == '-' || c > '~')) {
                this.unreadChar(c);
                return;
            }
            stringBuffer.append(c);
        }
    }

    protected char scanWhitespace() throws IOException {
        char c;
        block3: while (true) {
            c = this.readChar();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
            }
            break;
        }
        return c;
    }

    protected char scanWhitespace(StringBuffer stringBuffer) throws IOException {
        char c;
        block4: while (true) {
            c = this.readChar();
            switch (c) {
                case '\t': 
                case '\n': 
                case ' ': {
                    stringBuffer.append(c);
                    continue block4;
                }
                case '\r': {
                    continue block4;
                }
            }
            break;
        }
        return c;
    }

    protected void scanString(StringBuffer stringBuffer) throws IOException {
        char c = this.readChar();
        if (c != '\'' && c != '\"') {
            stringBuffer.append(c);
            while (true) {
                char c2;
                if ((c2 = this.readChar()) == ' ' || c2 == '\t' || c2 == '\n' || c2 == '\r' || c2 == '/' || c2 == '>') {
                    this.unreadChar(c2);
                    return;
                }
                stringBuffer.append(c2);
            }
        }
        char c3;
        while ((c3 = this.readChar()) != c) {
            if (c3 == '&') {
                this.resolveEntity(stringBuffer, c);
                continue;
            }
            stringBuffer.append(c3);
        }
        return;
    }

    protected void scanPCData(StringBuffer stringBuffer) throws IOException {
        while (true) {
            char c;
            if ((c = this.readChar()) == '<') {
                c = this.readChar();
                if (c == '!') {
                    this.checkCDATA(stringBuffer);
                    continue;
                }
                this.unreadChar(c);
                return;
            }
            if (c == '&') {
                this.resolveEntity(stringBuffer);
                continue;
            }
            stringBuffer.append(c);
        }
    }

    protected boolean checkCDATA(StringBuffer stringBuffer) throws IOException {
        char c = this.readChar();
        if (c != '[') {
            this.unreadChar(c);
            this.skipSpecialTag(0);
            return false;
        }
        if (!this.checkLiteral("CDATA[")) {
            this.skipSpecialTag(1);
            return false;
        }
        int n = 0;
        block4: while (n < 3) {
            int n2;
            c = this.readChar();
            switch (c) {
                case ']': {
                    if (n < 2) {
                        ++n;
                        continue block4;
                    }
                    stringBuffer.append(']');
                    stringBuffer.append(']');
                    n = 0;
                    continue block4;
                }
                case '>': {
                    if (n < 2) {
                        for (n2 = 0; n2 < n; ++n2) {
                            stringBuffer.append(']');
                        }
                        n = 0;
                        stringBuffer.append('>');
                        continue block4;
                    }
                    n = 3;
                    continue block4;
                }
            }
            for (n2 = 0; n2 < n; ++n2) {
                stringBuffer.append(']');
            }
            stringBuffer.append(c);
            n = 0;
        }
        return true;
    }

    protected void skipComment() throws IOException {
        int n = 2;
        while (n > 0) {
            char c = this.readChar();
            if (c == '-') {
                --n;
                continue;
            }
            n = 2;
        }
        if (this.readChar() != '>') {
            throw this.expectedInput(">");
        }
    }

    protected void skipSpecialTag(int n) throws IOException {
        char c;
        int n2 = 1;
        char c2 = '\u0000';
        if (n == 0) {
            c = this.readChar();
            if (c == '[') {
                ++n;
            } else if (c == '-') {
                c = this.readChar();
                if (c == '[') {
                    ++n;
                } else if (c == ']') {
                    --n;
                } else if (c == '-') {
                    this.skipComment();
                    return;
                }
            }
        }
        while (n2 > 0) {
            c = this.readChar();
            if (c2 == '\u0000') {
                if (c == '\"' || c == '\'') {
                    c2 = c;
                } else if (n <= 0) {
                    if (c == '<') {
                        ++n2;
                    } else if (c == '>') {
                        --n2;
                    }
                }
                if (c == '[') {
                    ++n;
                    continue;
                }
                if (c != ']') continue;
                --n;
                continue;
            }
            if (c != c2) continue;
            c2 = '\u0000';
        }
    }

    protected boolean checkLiteral(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (this.readChar() == string.charAt(i)) continue;
            return false;
        }
        return true;
    }

    protected char readChar() throws IOException {
        if (this.charReadTooMuch != '\u0000') {
            char c = this.charReadTooMuch;
            this.charReadTooMuch = '\u0000';
            return c;
        }
        int n = this.reader.read();
        if (n < 0) {
            throw this.unexpectedEndOfData();
        }
        if (n == 10) {
            ++this.parserLineNumber;
            return '\n';
        }
        return (char)n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void scanElement(XMLElement xMLElement) throws IOException {
        Object object;
        char c;
        String string;
        StringBuffer stringBuffer;
        block23: {
            stringBuffer = new StringBuffer();
            this.scanIdentifier(stringBuffer);
            string = stringBuffer.toString();
            xMLElement.setName(string);
            c = this.scanWhitespace();
            while (c != '>' && c != '/') {
                stringBuffer.setLength(0);
                this.unreadChar(c);
                this.scanIdentifier(stringBuffer);
                object = stringBuffer.toString();
                c = this.scanWhitespace();
                if (c != '=') {
                    if (!this.ignoreMissingAttributes) throw this.expectedInput("=");
                    this.unreadChar(c);
                    xMLElement.setAttribute((String)object, "");
                } else {
                    this.unreadChar(this.scanWhitespace());
                    stringBuffer.setLength(0);
                    this.scanString(stringBuffer);
                    xMLElement.setAttribute((String)object, stringBuffer);
                }
                c = this.scanWhitespace();
            }
            if (c == '/') {
                c = this.readChar();
                if (c == '>') return;
                throw this.expectedInput(">");
            }
            stringBuffer.setLength(0);
            c = this.scanWhitespace(stringBuffer);
            if (c != '<') {
                this.unreadChar(c);
                this.scanPCData(stringBuffer);
            } else {
                while ((c = this.readChar()) == '!') {
                    if (this.checkCDATA(stringBuffer)) {
                        this.scanPCData(stringBuffer);
                    } else {
                        c = this.scanWhitespace(stringBuffer);
                        if (c == '<') continue;
                        this.unreadChar(c);
                        this.scanPCData(stringBuffer);
                    }
                    break block23;
                }
                if (c != '/' || this.ignoreWhitespace) {
                    stringBuffer.setLength(0);
                }
                if (c == '/') {
                    this.unreadChar(c);
                }
            }
        }
        if (stringBuffer.length() == 0) {
            while (c != '/') {
                if (c == '!') {
                    c = this.readChar();
                    if (c != '-') {
                        throw this.expectedInput("Comment or Element");
                    }
                    c = this.readChar();
                    if (c != '-') {
                        throw this.expectedInput("Comment or Element");
                    }
                    this.skipComment();
                } else {
                    this.unreadChar(c);
                    object = this.createAnotherElement();
                    this.scanElement((XMLElement)object);
                    xMLElement.addChild((XMLElement)object);
                }
                c = this.scanWhitespace();
                if (c != '<') {
                    throw this.expectedInput("<");
                }
                c = this.readChar();
            }
            this.unreadChar(c);
        } else if (this.ignoreWhitespace) {
            xMLElement.setContent(stringBuffer.toString().trim());
        } else {
            xMLElement.setContent(stringBuffer.toString());
        }
        c = this.readChar();
        if (c != '/') {
            throw this.expectedInput("/");
        }
        this.unreadChar(this.scanWhitespace());
        if (!this.checkLiteral(string)) {
            throw this.expectedInput(string);
        }
        if (this.scanWhitespace() == '>') return;
        throw this.expectedInput(">");
    }

    protected void resolveEntity(StringBuffer stringBuffer) throws IOException {
        char c = '\u0000';
        StringBuffer stringBuffer2 = new StringBuffer();
        while ((c = this.readChar()) != ';') {
            stringBuffer2.append(c);
        }
        String string = stringBuffer2.toString();
        if (string.charAt(0) == '#') {
            try {
                c = string.charAt(1) == 'x' ? (char)Integer.parseInt(string.substring(2), 16) : (char)Integer.parseInt(string.substring(1), 10);
            }
            catch (NumberFormatException numberFormatException) {
                throw this.unknownEntity(string);
            }
            stringBuffer.append(c);
        } else {
            char[] cArray = (char[])this.entities.get(string);
            if (cArray == null) {
                if (!this.ignoreUnknownEntities) {
                    throw this.unknownEntity(string);
                }
                stringBuffer.append("&" + string + ";");
            } else {
                stringBuffer.append(cArray);
            }
        }
    }

    protected void resolveEntity(StringBuffer stringBuffer, char c) throws IOException {
        char c2 = '\u0000';
        StringBuffer stringBuffer2 = new StringBuffer();
        while ((c2 = this.readChar()) != ';') {
            if (c2 == c) {
                stringBuffer.append(stringBuffer2);
                this.unreadChar(c2);
                return;
            }
            stringBuffer2.append(c2);
        }
        String string = stringBuffer2.toString();
        if (string.charAt(0) == '#') {
            try {
                c2 = string.charAt(1) == 'x' ? (char)Integer.parseInt(string.substring(2), 16) : (char)Integer.parseInt(string.substring(1), 10);
            }
            catch (NumberFormatException numberFormatException) {
                throw this.unknownEntity(string);
            }
            stringBuffer.append(c2);
        } else {
            char[] cArray = (char[])this.entities.get(string);
            if (cArray == null) {
                if (!this.ignoreUnknownEntities) {
                    throw this.unknownEntity(string);
                }
            } else {
                stringBuffer.append(cArray);
            }
        }
    }

    protected void unreadChar(char c) {
        this.charReadTooMuch = c;
    }

    protected XMLParseException invalidValueSet(String string) {
        String string2 = "Invalid value set (entity name = \"" + string + "\")";
        return new XMLParseException(this.getName(), this.parserLineNumber, string2);
    }

    protected XMLParseException invalidValue(String string, String string2) {
        String string3 = "Attribute \"" + string + "\" does not contain a valid " + "value (\"" + string2 + "\")";
        return new XMLParseException(this.getName(), this.parserLineNumber, string3);
    }

    protected XMLParseException unexpectedEndOfData() {
        String string = "Unexpected end of data reached";
        return new XMLParseException(this.getName(), this.parserLineNumber, string);
    }

    protected XMLParseException syntaxError(String string) {
        String string2 = "Syntax error while parsing " + string;
        return new XMLParseException(this.getName(), this.parserLineNumber, string2);
    }

    protected XMLParseException expectedInput(String string) {
        String string2 = "Expected: " + string;
        return new XMLParseException(this.getName(), this.parserLineNumber, string2);
    }

    protected XMLParseException unknownEntity(String string) {
        String string2 = "Unknown or invalid entity: &" + string + ";";
        return new XMLParseException(this.getName(), this.parserLineNumber, string2);
    }
}

