/*
 * Decompiled with CFR 0.152.
 */
package org.phylowidget.ui;

import org.andrewberman.ui.StringClipboard;
import org.jgrapht.Graphs;
import org.jgrapht.traverse.BreadthFirstIterator;
import org.phylowidget.PhyloTree;
import org.phylowidget.net.JSClipUpdater;
import org.phylowidget.tree.CachedRootedTree;
import org.phylowidget.tree.PhyloNode;
import org.phylowidget.tree.RootedTree;
import org.phylowidget.tree.TreeIO;
import processing.core.PApplet;

public class TreeClipboard {
    String newickString;
    RootedTree origTree;
    PhyloNode origVertex;
    JSClipUpdater updater;

    public TreeClipboard(PApplet pApplet) {
        this.updater = new JSClipUpdater(pApplet);
    }

    public boolean isEmpty() {
        if (this.newickString == null) {
            return true;
        }
        return this.newickString.length() == 0;
    }

    public void clearClipboard() {
        this.clearTree();
        this.newickString = "";
        this.updater.triggerUpdate(this.newickString);
    }

    void clearTree() {
        if (this.origTree != null) {
            this.setStateRecursive(this.origTree, (PhyloNode)this.origTree.getRoot(), 0);
            this.origTree = null;
        }
    }

    public synchronized void cut(RootedTree rootedTree, PhyloNode phyloNode) {
        this.clearClipboard();
        this.setClip(rootedTree, phyloNode);
        this.setStateRecursive(rootedTree, phyloNode, 1);
    }

    public synchronized void copy(RootedTree rootedTree, PhyloNode phyloNode) {
        this.clearClipboard();
        this.setClip(rootedTree, phyloNode);
        this.setStateRecursive(rootedTree, phyloNode, 2);
    }

    public void setClip(RootedTree rootedTree, PhyloNode phyloNode) {
        this.setStateRecursive(rootedTree, (PhyloNode)rootedTree.getRoot(), 0);
        RootedTree rootedTree2 = rootedTree.cloneSubtree(phyloNode);
        this.newickString = TreeIO.createNewickString(rootedTree2, false);
        this.origTree = rootedTree;
        this.origVertex = phyloNode;
        this.updater.triggerUpdate(this.newickString);
    }

    public void setClipFromJS(String string) {
        this.clearTree();
        this.newickString = string;
        this.origTree = null;
        this.origVertex = null;
    }

    PhyloTree loadClip() {
        if (this.newickString == null || this.newickString.length() == 0) {
            this.newickString = StringClipboard.instance.fromClipboard();
        }
        if (this.newickString == null || this.newickString.length() == 0) {
            throw new Error("Called TreeClipboard.paste() with empty clipboard");
        }
        PhyloTree phyloTree = new PhyloTree();
        TreeIO.parseNewickString(phyloTree, this.newickString);
        if (this.origTree != null && this.origVertex != null) {
            this.setPositionRecursive(phyloTree, (PhyloNode)phyloTree.getRoot(), this.origVertex);
        }
        return phyloTree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void swap(RootedTree rootedTree, PhyloNode phyloNode) {
        RootedTree rootedTree2 = rootedTree;
        synchronized (rootedTree2) {
            if (this.origTree == rootedTree && this.origVertex != null) {
                PhyloNode phyloNode2 = this.origTree.getParentOf(this.origVertex);
                PhyloNode phyloNode3 = this.origTree.getParentOf(phyloNode);
                if (phyloNode2 != null && phyloNode3 != null) {
                    this.origTree.removeEdge(phyloNode2, this.origVertex);
                    this.origTree.removeEdge(phyloNode3, phyloNode);
                    this.origTree.addEdge(phyloNode2, phyloNode);
                    this.origTree.addEdge(phyloNode3, this.origVertex);
                }
            } else {
                PhyloTree phyloTree = this.loadClip();
                this.setClip(rootedTree, phyloNode);
                this.setClipFromJS(this.newickString);
                PhyloNode phyloNode4 = rootedTree.getParentOf(phyloNode);
                rootedTree.deleteSubtree(phyloNode);
                Graphs.addGraph(rootedTree, phyloTree);
                if (phyloNode4 == null) {
                    rootedTree.setRoot(phyloTree.getRoot());
                } else {
                    rootedTree.addEdge(phyloNode4, phyloTree.getRoot());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void paste(CachedRootedTree cachedRootedTree, PhyloNode phyloNode) {
        PhyloTree phyloTree = this.loadClip();
        CachedRootedTree cachedRootedTree2 = cachedRootedTree;
        synchronized (cachedRootedTree2) {
            cachedRootedTree.setHoldCalculations(true);
            Graphs.addGraph(cachedRootedTree, phyloTree);
            if (cachedRootedTree.getParentOf(phyloNode) == null) {
                cachedRootedTree.addEdge(phyloNode, phyloTree.getRoot());
            } else {
                Object v = cachedRootedTree.createAndAddVertex();
                ((PhyloNode)v).setPosition(this.origVertex);
                cachedRootedTree.insertNodeBetween(cachedRootedTree.getParentOf(phyloNode), phyloNode, v);
                cachedRootedTree.addEdge(v, phyloTree.getRoot());
            }
            cachedRootedTree.setHoldCalculations(false);
            cachedRootedTree.modPlus();
            this.clearCutNodes();
        }
    }

    void clearCutNodes() {
        if (this.origTree != null && this.origVertex != null && this.origVertex.getState() == 1) {
            this.origTree.deleteSubtree(this.origVertex);
            this.origTree.removeElbowsBelow(this.origTree.getRoot());
            this.setStateRecursive(this.origTree, (PhyloNode)this.origTree.getRoot(), 0);
            this.origVertex.found = false;
            this.origVertex = null;
            this.origTree.modPlus();
        }
    }

    void setPositionRecursive(RootedTree rootedTree, PhyloNode phyloNode, PhyloNode phyloNode2) {
        BreadthFirstIterator breadthFirstIterator = new BreadthFirstIterator(rootedTree, phyloNode);
        while (breadthFirstIterator.hasNext()) {
            PhyloNode phyloNode3 = (PhyloNode)breadthFirstIterator.next();
            phyloNode3.setPosition(phyloNode2);
        }
    }

    void setStateRecursive(RootedTree rootedTree, PhyloNode phyloNode, int n) {
        BreadthFirstIterator breadthFirstIterator = new BreadthFirstIterator(rootedTree, phyloNode);
        while (breadthFirstIterator.hasNext()) {
            PhyloNode phyloNode2 = (PhyloNode)breadthFirstIterator.next();
            phyloNode2.setState(n);
        }
    }
}

