/*
 * Decompiled with CFR 0.152.
 */
package org.phylowidget.ui;

import java.awt.geom.Rectangle2D;
import org.andrewberman.ui.Label;
import org.andrewberman.ui.LayoutUtils;
import org.andrewberman.ui.UIEvent;
import org.andrewberman.ui.ifaces.UIListener;
import org.andrewberman.ui.menu.TextBox;
import org.phylowidget.PhyloTree;
import org.phylowidget.PhyloWidget;
import processing.core.PApplet;

public class SearchBox
extends TextBox
implements UIListener {
    Label label;
    float myWidth;

    public SearchBox(PApplet pApplet) {
        super(pApplet);
        this.label = new Label(pApplet);
        this.tf.addListener(this);
    }

    public void setLabel(String string) {
        this.label.setLabel(string);
        this.layout();
    }

    public void setName(String string) {
        super.setName(string);
        this.setLabel(string);
    }

    public synchronized void dispose() {
        super.dispose();
        this.label.dispose();
    }

    public void layout() {
        LayoutUtils.centerVertical(this.tf, this.y, this.y + this.height);
        LayoutUtils.centerHorizontal(this.tf, this.x, this.x + this.width);
        this.tf.setTextSize(this.getFontSize());
        this.label.setFontSize(this.getFontSize() * 0.9f);
        LayoutUtils.centerVertical(this.label, this.y, this.y + this.height);
        this.label.setX(this.x + this.getPadX());
        this.tf.setX(this.label.getX() + this.label.getWidth() + this.getPadX());
    }

    protected void calcPreferredSize() {
        super.calcPreferredSize();
        this.width = this.label.getWidth() + this.tf.getWidth() + this.getPadX() * 3.0f;
        this.height = this.tf.getHeight();
    }

    public void setWidth(float f) {
        super.setWidth(f);
        this.tf.setWidth(f - this.label.getWidth());
        this.menu.layout();
    }

    protected void getRect(Rectangle2D.Float float_, Rectangle2D.Float float_2) {
        super.getRect(float_, float_2);
    }

    public String getText() {
        return this.tf.getText();
    }

    public void setText(String string) {
        this.tf.replaceText(string);
    }

    public void uiEvent(UIEvent uIEvent) {
        if (uIEvent.getID() == 0) {
            PhyloWidget.cfg.search = this.getText();
            PhyloTree phyloTree = (PhyloTree)PhyloWidget.trees.getTree();
            if (phyloTree != null) {
                phyloTree.searchAndMarkFound(this.getText());
            }
        }
    }
}

