/*
 * Decompiled with CFR 0.152.
 */
package org.phylowidget.ui;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Label;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.swing.SwingUtilities;
import org.andrewberman.ui.EventManager;
import org.andrewberman.ui.FocusManager;
import org.andrewberman.ui.ShortcutManager;
import org.andrewberman.ui.UIGlobals;
import org.andrewberman.ui.menu.MenuItem;
import org.andrewberman.ui.menu.ToolDock;
import org.andrewberman.ui.menu.Toolbar;
import org.phylowidget.PhyloTree;
import org.phylowidget.PhyloWidget;
import org.phylowidget.net.NodeInfoUpdater;
import org.phylowidget.net.SecurityChecker;
import org.phylowidget.render.BasicTreeRenderer;
import org.phylowidget.render.NodeRange;
import org.phylowidget.tree.CachedRootedTree;
import org.phylowidget.tree.PhyloNode;
import org.phylowidget.tree.RootedTree;
import org.phylowidget.tree.TreeIO;
import org.phylowidget.ui.AnnotationEditorDialog;
import org.phylowidget.ui.ImageExportDialog;
import org.phylowidget.ui.InputDialog;
import org.phylowidget.ui.PhyloConfig;
import org.phylowidget.ui.PhyloContextMenu;
import org.phylowidget.ui.PhyloMenuIO;
import org.phylowidget.ui.PhyloTextField;
import org.phylowidget.ui.SearchBox;
import org.phylowidget.ui.TreeClipboard;
import processing.core.PApplet;

public class PhyloUI
implements Runnable {
    PhyloWidget p;
    public FocusManager focus;
    public EventManager event;
    public ShortcutManager keys;
    public TreeClipboard clipboard;
    public PhyloTextField text;
    public PhyloContextMenu context;
    public Toolbar toolbar;
    public SearchBox search;
    NodeInfoUpdater nodeUpdater;
    public Thread thread;
    public ArrayList<MenuItem> menus;
    boolean canWriteFiles;
    boolean canReadFiles;
    boolean canAccessInternet;
    AnnotationEditorDialog annotation;

    public PhyloUI(PhyloWidget phyloWidget) {
        this.p = phyloWidget;
    }

    public void setup() {
        this.focus = UIGlobals.g.focus();
        this.event = UIGlobals.g.event();
        this.keys = UIGlobals.g.shortcuts();
        this.text = new PhyloTextField(this.p);
        this.nodeUpdater = new NodeInfoUpdater();
        this.clipboard = new TreeClipboard(this.p);
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void run() {
        try {
            this.p.callMethod("setMenusIfNull");
            this.loadFromApplet(this.p);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.checkPermissions();
    }

    public void setMenusIfNull() {
        if (this.menus == null) {
            this.setMenus();
        }
    }

    boolean runningInBrowser() {
        String string = this.p.getAppletContext().getClass().getCanonicalName();
        System.out.println(string);
        return !string.toLowerCase().contains("appletviewer");
    }

    void disposeMenus() {
        if (this.menus != null) {
            for (MenuItem menuItem : this.menus) {
                menuItem.dispose();
            }
        }
    }

    public synchronized void setMenus() {
        this.disposeMenus();
        if (PhyloWidget.cfg.debug) {
            System.out.println("Disposed!");
        }
        String[] stringArray = PhyloWidget.cfg.menus.split(";");
        ArrayList<MenuItem> arrayList = new ArrayList<MenuItem>();
        for (String string : stringArray) {
            Object object;
            if (string.trim().length() == 0) continue;
            if (PhyloWidget.cfg.debug) {
                System.out.println(string);
            }
            string.replaceAll("'", "");
            string.replaceAll("\"", "");
            PhyloMenuIO phyloMenuIO = new PhyloMenuIO();
            Reader reader = null;
            InputStream inputStream = null;
            if (string.toLowerCase().startsWith("http")) {
                try {
                    object = new URL(string);
                    inputStream = ((URL)object).openStream();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                inputStream = this.p.createInput("menus/" + string);
                if (inputStream == null) {
                    inputStream = this.p.createInput(string);
                }
                if (inputStream == null) {
                    object = this.p.getDocumentBase().toString();
                    int n = ((String)object).lastIndexOf("/");
                    if (n != -1) {
                        object = ((String)object).substring(0, n);
                    }
                    inputStream = this.p.createInput(object + "/" + string);
                }
            }
            reader = inputStream == null ? new StringReader(string) : new InputStreamReader(inputStream);
            object = phyloMenuIO.loadFromXML(reader, this.p, new Object[]{PhyloWidget.ui, this.p, PhyloWidget.cfg});
            System.out.println(string);
            this.configureMenus((ArrayList)object);
            arrayList.addAll((Collection<MenuItem>)object);
        }
        this.menus = arrayList;
        if (PhyloWidget.cfg.debug) {
            System.out.println("Finished!");
        }
    }

    String streamToString(InputStream inputStream) {
        int n = 0;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        StringBuffer stringBuffer = new StringBuffer();
        try {
            while ((n = inputStreamReader.read()) != -1) {
                stringBuffer.append((char)n);
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public void loadFromApplet(PApplet pApplet) throws Exception {
        Field[] fieldArray;
        HashMap hashMap = new HashMap();
        for (Field field : fieldArray = PhyloConfig.class.getDeclaredFields()) {
            try {
                String string = pApplet.getParameter(field.getName());
                if (string == null) continue;
                this.p.changeSetting(field.getName(), string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected synchronized void configureMenus(ArrayList arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            MenuItem menuItem;
            MenuItem menuItem2 = (MenuItem)arrayList.get(i);
            if (menuItem2 instanceof PhyloContextMenu) {
                this.context = (PhyloContextMenu)menuItem2;
                continue;
            }
            if (menuItem2.getClass() == Toolbar.class) {
                this.toolbar = (Toolbar)menuItem2;
                menuItem = this.toolbar.get("Search:");
                if (menuItem != null) {
                    this.search = (SearchBox)menuItem;
                    this.search.setText(PhyloWidget.cfg.search);
                }
            }
            if (menuItem2.getClass() != ToolDock.class) continue;
            menuItem = (ToolDock)menuItem2;
        }
    }

    void checkPermissions() {
        SecurityChecker securityChecker = new SecurityChecker((Applet)UIGlobals.g.getP());
        this.canWriteFiles = securityChecker.canWriteFiles();
        this.canReadFiles = securityChecker.canReadFiles();
        this.canAccessInternet = securityChecker.canAccessInternet();
    }

    public boolean canWriteFiles() {
        return this.canWriteFiles;
    }

    public boolean canReadFiles() {
        return this.canReadFiles;
    }

    public boolean canAccessInternet() {
        return this.canAccessInternet;
    }

    public void updateNodeInfo(RootedTree rootedTree, PhyloNode phyloNode) {
        this.nodeUpdater.triggerUpdate(rootedTree, phyloNode);
    }

    public void updateJS() {
        PhyloTree phyloTree = (PhyloTree)PhyloWidget.trees.getTree();
        if (phyloTree != null) {
            phyloTree.updateNewick();
        }
    }

    public RootedTree getCurTree() {
        return PhyloWidget.trees.getTree();
    }

    public void layout() {
        if (PhyloWidget.trees.getRenderer() != null) {
            PhyloWidget.trees.getRenderer().layoutTrigger();
        }
        this.updateJS();
    }

    public void forceLayout() {
        if (PhyloWidget.trees.getRenderer() != null) {
            BasicTreeRenderer basicTreeRenderer = (BasicTreeRenderer)PhyloWidget.trees.getRenderer();
            basicTreeRenderer.forceLayout();
        }
        this.updateJS();
    }

    public PhyloNode getCurNode() {
        if (this.curRange() == null) {
            return null;
        }
        return this.curRange().node;
    }

    public void search() {
        if (this.search != null) {
            this.search.setText(PhyloWidget.cfg.search);
        } else {
            PhyloTree phyloTree = (PhyloTree)this.getCurTree();
            if (phyloTree != null) {
                phyloTree.searchAndMarkFound(PhyloWidget.cfg.search);
            }
        }
    }

    public NodeRange curRange() {
        if (this.context == null) {
            return null;
        }
        return this.context.curNodeRange;
    }

    public void nodeEditBranchLength() {
        this.text.startEditing(this.curRange(), 1);
    }

    public void nodeEditName() {
        this.text.startEditing(this.curRange(), 0);
    }

    public void nodeEditAnnotation() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (PhyloUI.this.annotation == null) {
                    PhyloUI.this.annotation = new AnnotationEditorDialog(PhyloUI.this.getFrame(), PhyloUI.this.p);
                }
                PhyloUI.this.annotation.setNode(PhyloUI.this.getCurNode());
                PhyloUI.this.annotation.setVisible(true);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeReroot() {
        NodeRange nodeRange = this.curRange();
        RootedTree rootedTree = nodeRange.render.getTree();
        synchronized (rootedTree) {
            nodeRange.render.getTree().reroot(this.getCurNode());
        }
    }

    public void reroot() {
        this.nodeReroot();
    }

    public void nodeSwitchChildren() {
        NodeRange nodeRange = this.curRange();
        nodeRange.render.getTree().flipChildren(this.getCurNode());
        nodeRange.render.layoutTrigger();
    }

    public void nodeFlipSubtree() {
        NodeRange nodeRange = this.curRange();
        nodeRange.render.getTree().reverseSubtree(this.getCurNode());
        this.getCurTree().modPlus();
        nodeRange.render.layoutTrigger();
    }

    public void nodeAddSister() {
        NodeRange nodeRange = this.curRange();
        RootedTree rootedTree = nodeRange.render.getTree();
        PhyloNode phyloNode = (PhyloNode)rootedTree.createAndAddVertex();
        rootedTree.addSisterNode(this.getCurNode(), phyloNode);
    }

    public void nodeAddChild() {
        NodeRange nodeRange = this.curRange();
        RootedTree rootedTree = nodeRange.render.getTree();
        rootedTree.addChildNode(this.getCurNode());
    }

    public void nodeCut() {
        NodeRange nodeRange = this.curRange();
        this.clipboard.cut(nodeRange.render.getTree(), nodeRange.node);
    }

    public void nodeCopy() {
        NodeRange nodeRange = this.curRange();
        this.clipboard.copy(nodeRange.render.getTree(), nodeRange.node);
    }

    public void selectNode(String string) {
        PhyloTree phyloTree = (PhyloTree)this.getCurTree();
        List<PhyloNode> list = phyloTree.search(string);
        if (list.size() == 0) {
            System.err.println("Node " + string + " not found!");
        }
        this.context.curNodeRange = list.get((int)0).range;
    }

    void setMessage(String string) {
        PhyloWidget.setMessage(string);
    }

    public void nodeSwap() {
        final NodeRange nodeRange = this.curRange();
        this.setMessage("Swapping clipboard...");
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    RootedTree rootedTree = nodeRange.render.getTree();
                    synchronized (rootedTree) {
                        PhyloUI.this.clipboard.swap(nodeRange.render.getTree(), nodeRange.node);
                    }
                    PhyloUI.this.setMessage("");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    PhyloUI.this.setMessage("Swap failed! Make sure the clipboard is not empty.");
                }
            }
        }.start();
    }

    public void nodePaste() {
        final NodeRange nodeRange = this.curRange();
        this.setMessage("Pasting clipboard...");
        new Thread(){

            public void run() {
                try {
                    PhyloUI.this.clipboard.paste((CachedRootedTree)nodeRange.render.getTree(), nodeRange.node);
                    PhyloUI.this.setMessage("");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    PhyloUI.this.setMessage("Paste failed! Make sure the clipboard is not empty.");
                }
            }
        }.start();
    }

    public void nodeClearClipboard() {
        this.clipboard.clearClipboard();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeDelete() {
        RootedTree rootedTree;
        NodeRange nodeRange = this.curRange();
        RootedTree rootedTree2 = rootedTree = nodeRange.render.getTree();
        synchronized (rootedTree2) {
            rootedTree.deleteNode(this.getCurNode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeDeleteSubtree() {
        RootedTree rootedTree;
        NodeRange nodeRange = this.curRange();
        RootedTree rootedTree2 = rootedTree = nodeRange.render.getTree();
        synchronized (rootedTree2) {
            rootedTree.deleteSubtree(this.getCurNode());
        }
    }

    public void nodeCollapse() {
        NodeRange nodeRange = this.curRange();
        RootedTree rootedTree = nodeRange.render.getTree();
        rootedTree.collapseNode(this.getCurNode());
        rootedTree.modPlus();
        this.layout();
    }

    public void viewUnrooted() {
        PhyloWidget.trees.unrootedRender();
    }

    public void viewRectangular() {
        PhyloWidget.trees.rectangleRender();
    }

    public void viewDiagonal() {
        PhyloWidget.trees.diagonalRender();
    }

    public void viewCircular() {
        PhyloWidget.trees.circleRender();
    }

    public void zoomToFull() {
        PhyloWidget.trees.fillScreen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void treeNew() {
        RootedTree rootedTree = PhyloWidget.trees.getTree();
        synchronized (rootedTree) {
            PhyloWidget.trees.setTree("PhyloWidget");
        }
        this.layout();
    }

    public void treeFlip() {
        PhyloTree phyloTree = (PhyloTree)this.getCurTree();
        phyloTree.reverseSubtree((PhyloNode)phyloTree.getRoot());
        phyloTree.modPlus();
        this.layout();
    }

    public void treeAutoSort() {
        RootedTree rootedTree = this.getCurTree();
        rootedTree.ladderizeSubtree(rootedTree.getRoot());
        this.layout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void treeRemoveElbows() {
        RootedTree rootedTree;
        RootedTree rootedTree2 = rootedTree = this.getCurTree();
        synchronized (rootedTree2) {
            rootedTree.removeElbowsBelow(rootedTree.getRoot());
        }
        this.layout();
    }

    public void treeUncollapseAll() {
        this.getCurTree().uncollapseAllNodes();
        this.layout();
    }

    public void treeAlignLeaves() {
        new Thread(){

            public void run() {
                PhyloUI.this.setMessage("Aligning leaves...");
                RootedTree rootedTree = PhyloUI.this.getCurTree();
                rootedTree.makeSubtreeUltrametric(rootedTree.getRoot());
                PhyloUI.this.layout();
                PhyloUI.this.setMessage("");
            }
        }.start();
    }

    public void treeMutateOnce() {
        PhyloWidget.trees.mutateTree();
    }

    public void treeMutateSlow() {
        PhyloWidget.trees.startMutatingTree(1000);
    }

    public void treeMutateFast() {
        PhyloWidget.trees.startMutatingTree(50);
    }

    public void treeStopMutating() {
        PhyloWidget.trees.stopMutatingTree();
    }

    public void nodeLoadImage() {
        new Thread(){

            public void run() {
                PhyloUI.this.getCurNode().loadThumbImage();
            }
        }.start();
    }

    public void treeLoadImages() {
        new Thread(){

            public void run() {
                RootedTree rootedTree = PhyloUI.this.getCurTree();
                ArrayList arrayList = new ArrayList();
                rootedTree.getAll(rootedTree.getRoot(), arrayList, null);
                for (PhyloNode phyloNode : arrayList) {
                    phyloNode.loadThumbImage();
                }
            }
        }.start();
    }

    public void treeSave() {
        FileDialog fileDialog = new FileDialog(PhyloWidget.ui.getFrame(), "Choose your desination file. Tree will be in Newick / NHX format.", 1);
        fileDialog.pack();
        fileDialog.setVisible(true);
        String string = fileDialog.getDirectory();
        String string2 = fileDialog.getFile();
        if (string2 == null) {
            PhyloWidget.setMessage("Tree save cancelled.");
            return;
        }
        final File file = new File(string, string2);
        this.setMessage("Saving tree...");
        new Thread(){

            public void run() {
                PhyloUI.this.p.noLoop();
                File file2 = file.getParentFile();
                TreeIO.outputTreeImages(PhyloWidget.trees.getTree(), file2);
                String string = TreeIO.createNewickString(PhyloWidget.trees.getTree(), false);
                try {
                    file.createNewFile();
                    BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
                    bufferedWriter.append(string);
                    bufferedWriter.close();
                    PhyloUI.this.p.loop();
                    PhyloUI.this.setMessage("");
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    PhyloUI.this.p.loop();
                    PhyloUI.this.setMessage("Error writing file. Whoops!");
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    PhyloUI.this.setMessage("");
                    PhyloUI.this.layout();
                    return;
                }
            }
        }.start();
    }

    public void treeLoad() {
        FileDialog fileDialog = new FileDialog(PhyloWidget.ui.getFrame(), "Locate a Newick/NHX/Nexus format file.", 0);
        fileDialog.pack();
        fileDialog.setVisible(true);
        String string = fileDialog.getDirectory();
        String string2 = fileDialog.getFile();
        if (string2 == null) {
            PhyloWidget.setMessage("Tree load cancelled.");
            return;
        }
        final File file = new File(string, string2);
        this.setMessage("Loading tree...");
        new Thread(){

            public void run() {
                PhyloTree phyloTree = (PhyloTree)TreeIO.parseFile(new PhyloTree(), file);
                PhyloUI.this.p.noLoop();
                if (phyloTree != null) {
                    PhyloWidget.trees.setTree(phyloTree);
                    PhyloUI.this.setMessage("");
                } else {
                    PhyloUI.this.setMessage("Error loading tree!");
                }
                PhyloUI.this.p.loop();
                PhyloUI.this.layout();
            }
        }.start();
    }

    public Frame getFrame() {
        Frame frame = null;
        for (Container container = this.p.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof Frame)) continue;
            frame = (Frame)container;
            break;
        }
        if (frame == null) {
            frame = new Frame();
        }
        return frame;
    }

    public PhyloNode getHoveredNode() {
        boolean bl;
        PhyloNode phyloNode = this.context.getNearestNode();
        if (phyloNode != null && (bl = this.context.traverser.containsPoint(phyloNode.range, this.context.traverser.pt))) {
            return phyloNode;
        }
        return null;
    }

    public void treeInput() {
        Frame frame = this.getFrame();
        final InputDialog inputDialog = new InputDialog(frame, "Enter your Newick-formatted tree here.");
        SecurityChecker securityChecker = new SecurityChecker((Applet)((Object)this.p));
        if (securityChecker.canAccessInternet()) {
            Label label = new Label("A URL pointing to a Newick/NHX/Nexus file is also valid input.");
            inputDialog.add((Component)label, "North");
        }
        inputDialog.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                super.windowClosed(windowEvent);
                final String string = inputDialog.text.getText();
                if (string == null || string.length() == 0) {
                    return;
                }
                new Thread(){

                    public void run() {
                        PhyloUI.this.setMessage("Loading tree...");
                        PhyloTree phyloTree = null;
                        try {
                            phyloTree = (PhyloTree)TreeIO.parseNewickString(new PhyloTree(), string);
                            PhyloUI.this.p.noLoop();
                        }
                        catch (Exception exception) {
                            phyloTree = null;
                        }
                        if (phyloTree != null) {
                            PhyloWidget.trees.setTree(phyloTree);
                            PhyloUI.this.setMessage("");
                        } else {
                            PhyloUI.this.setMessage("Error loading tree!");
                        }
                        PhyloUI.this.p.loop();
                        PhyloUI.this.layout();
                    }
                }.start();
            }
        });
        inputDialog.setVisible(true);
    }

    public void fileOutput() {
        ImageExportDialog imageExportDialog = new ImageExportDialog(this.getFrame());
    }

    public boolean hasClipboard() {
        return !this.clipboard.isEmpty();
    }

    public boolean isNotRoot() {
        if (this.getCurTree() == null || this.getCurNode() == null) {
            return true;
        }
        return this.getCurTree().getRoot() != this.getCurNode();
    }

    public boolean isLeafNode() {
        return this.getCurTree().isLeaf(this.getCurNode());
    }

    public boolean isInternalNode() {
        if (this.getCurTree() == null || this.getCurNode() == null) {
            return true;
        }
        return !this.getCurTree().isLeaf(this.getCurNode());
    }

    public void destroy() {
        if (this.annotation != null) {
            this.annotation.dispose();
        }
        this.annotation = null;
        this.disposeMenus();
        this.p = null;
        this.focus = null;
        this.event = null;
        this.keys = null;
        this.clipboard = null;
        this.text = null;
        this.context = null;
        this.toolbar = null;
        this.search = null;
        this.nodeUpdater = null;
        this.thread = null;
        this.menus = null;
    }
}

