/*
 * Decompiled with CFR 0.152.
 */
package org.phylowidget.ui;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import org.andrewberman.ui.Point;
import org.andrewberman.ui.TextField;
import org.andrewberman.ui.UIGlobals;
import org.phylowidget.PhyloTree;
import org.phylowidget.PhyloWidget;
import org.phylowidget.render.BasicTreeRenderer;
import org.phylowidget.render.NodeRange;
import org.phylowidget.tree.RootedTree;
import processing.core.PApplet;

public class PhyloTextField
extends TextField {
    NodeRange curRange;
    String oldValue;
    int editMode;
    static final int LABEL = 0;
    static final int BRANCH_LENGTH = 1;

    public PhyloTextField(PApplet pApplet) {
        super(pApplet);
        this.hidden = true;
        this.alwaysAnchorLeft = true;
    }

    public void draw() {
        if (!this.hidden) {
            this.curRange.render.positionText(this.curRange.node, this);
            super.draw();
        }
    }

    protected void startEditing(NodeRange nodeRange, int n) {
        PhyloWidget.setMessage("Enter to commit, Esc to revert.");
        this.editMode = n;
        this.curRange = nodeRange;
        RootedTree rootedTree = nodeRange.render.getTree();
        this.reset();
        this.oldValue = null;
        switch (n) {
            case 0: {
                this.oldValue = rootedTree.getLabel(nodeRange.node);
                break;
            }
            case 1: {
                this.oldValue = String.valueOf(rootedTree.getBranchLength(nodeRange.node));
            }
        }
        this.text.replace(0, this.text.length(), this.oldValue);
        this.show();
        this.selectAll();
        UIGlobals.g.focus().setModalFocus(this);
    }

    public void hide() {
        super.hide();
        UIGlobals.g.focus().removeFromFocus(this);
        PhyloWidget.setMessage("");
    }

    void hideAndCommit() {
        this.hide();
        RootedTree rootedTree = this.curRange.render.getTree();
        if (rootedTree instanceof PhyloTree) {
            PhyloTree phyloTree = (PhyloTree)rootedTree;
            phyloTree.updateNewick();
        }
    }

    void hideAndReject() {
        this.hide();
        this.updateValue(this.oldValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateValue(String string) {
        PhyloTextField phyloTextField = this;
        synchronized (phyloTextField) {
            BasicTreeRenderer basicTreeRenderer = this.curRange.render;
            switch (this.editMode) {
                case 0: {
                    basicTreeRenderer.getTree().setLabel(this.curRange.node, string);
                    break;
                }
                case 1: {
                    try {
                        double d = Double.parseDouble(string);
                        basicTreeRenderer.getTree().setBranchLength(this.curRange.node, d);
                        break;
                    }
                    catch (Exception exception) {
                        PhyloWidget.ui.layout();
                        return;
                    }
                }
            }
            basicTreeRenderer.layoutTrigger();
            PhyloWidget.ui.updateNodeInfo(basicTreeRenderer.getTree(), this.curRange.node);
        }
    }

    public void fireEvent(int n) {
        super.fireEvent(n);
        if (n == 0) {
            this.updateValue(this.getText());
            this.layout();
        }
    }

    public void keyEvent(KeyEvent keyEvent) {
        super.keyEvent(keyEvent);
        if (this.hidden) {
            return;
        }
        switch (keyEvent.getKeyCode()) {
            case 27: {
                this.hideAndReject();
                keyEvent.consume();
                break;
            }
            case 10: {
                this.hideAndCommit();
                keyEvent.consume();
            }
        }
    }

    public void mouseEvent(MouseEvent mouseEvent, Point point, Point point2) {
        super.mouseEvent(mouseEvent, point, point2);
        if (this.hidden) {
            return;
        }
        if (mouseEvent.getID() != 501) {
            return;
        }
        Point point3 = this.useCameraCoordinates ? point2 : point;
        if (!this.withinOuterRect(point3)) {
            this.hideAndCommit();
        }
    }
}

