/*
 * Decompiled with CFR 0.152.
 */
package org.phylowidget.ui;

import java.awt.geom.Point2D;
import org.andrewberman.ui.menu.Menu;
import org.andrewberman.ui.menu.MenuItem;
import org.phylowidget.PhyloTree;
import org.phylowidget.PhyloWidget;
import org.phylowidget.TreeManager;
import org.phylowidget.render.BasicTreeRenderer;
import org.phylowidget.render.LayoutBase;
import org.phylowidget.render.LayoutCircular;
import org.phylowidget.render.LayoutCladogram;
import org.phylowidget.render.LayoutDiagonal;
import org.phylowidget.render.LayoutUnrooted;
import org.phylowidget.tree.CachedVertex;
import org.phylowidget.tree.PhyloNode;
import processing.core.PApplet;

public class PhyloScaleBar
extends Menu {
    int mode = 0;
    public static final int MODE_SCALE = 0;
    public static final int MODE_TIME = 1;
    float minSize = 0.1f;
    float maxSize = 10000.0f;
    String units = "";
    float percentWidth = 0.5f;
    float percentPosition = 0.5f;
    float barHeight = 10.0f;
    double[] sizes = new double[]{0.01, 0.1, 0.2, 0.5, 1.0, 2.0, 5.0, 10.0, 20.0, 50.0, 100.0, 200.0, 500.0, 1000.0, 2000.0, 5000.0};

    public PhyloScaleBar(PApplet pApplet) {
        super(pApplet);
        this.setY(pApplet.height - 10);
    }

    public synchronized void layout() {
        super.layout();
    }

    protected synchronized void drawMyself() {
        super.drawMyself();
        if (TreeManager.camera == null) {
            return;
        }
        if (PhyloWidget.trees.getTree() == null) {
            return;
        }
        if (!PhyloWidget.cfg.useBranchLengths) {
            return;
        }
        BasicTreeRenderer basicTreeRenderer = (BasicTreeRenderer)PhyloWidget.trees.getRenderer();
        if (basicTreeRenderer.getTreeLayout() instanceof LayoutDiagonal) {
            return;
        }
        if (basicTreeRenderer.getTreeLayout() instanceof LayoutCircular) {
            return;
        }
        if (this.mode == 0) {
            double d;
            Point2D.Double double_;
            Point2D.Double double_2;
            PhyloNode phyloNode;
            double d2;
            PhyloNode phyloNode2;
            PhyloTree phyloTree;
            float f = this.canvas.width;
            float f2 = f * this.percentPosition;
            float f3 = f * this.percentWidth;
            if (f2 - f3 < 0.0f) {
                f2 = f3 / 2.0f;
            }
            if ((phyloTree = (PhyloTree)PhyloWidget.trees.getTree()).getNumEnclosedLeaves((CachedVertex)phyloTree.getRoot()) == 1) {
                return;
            }
            double d3 = 1.0;
            LayoutBase layoutBase = basicTreeRenderer.getTreeLayout();
            if (layoutBase instanceof LayoutUnrooted) {
                phyloNode2 = (PhyloNode)phyloTree.getFurthestLeafFromVertex(phyloTree.getRoot());
                while (phyloNode2 != null && !(phyloTree.getBranchLength(phyloNode2) > 0.0)) {
                    phyloNode2 = phyloTree.getParentOf(phyloNode2);
                }
                d2 = phyloTree.getBranchLength(phyloNode2);
                phyloNode = phyloTree.getParentOf(phyloNode2);
                double_2 = new Point2D.Double(phyloNode.getX(), phyloNode.getY());
                double_ = new Point2D.Double(phyloNode2.getX(), phyloNode2.getY());
                d = double_2.distance(double_);
                d3 = d2 / d;
            } else if (layoutBase instanceof LayoutCladogram) {
                phyloNode2 = (PhyloNode)phyloTree.getFurthestLeafFromVertex(phyloTree.getRoot());
                while (phyloNode2 != null && !(phyloTree.getBranchLength(phyloNode2) > 0.0)) {
                    phyloNode2 = phyloTree.getParentOf(phyloNode2);
                }
                d2 = phyloTree.getBranchLength(phyloNode2);
                phyloNode = phyloTree.getParentOf(phyloNode2);
                double_2 = new Point2D.Double(phyloNode.getX(), phyloNode.getY());
                double_ = new Point2D.Double(phyloNode2.getX(), phyloNode2.getY());
                d = Math.abs(double_2.x - double_.x);
                d3 = d2 / d;
            }
            double d4 = 0.0;
            for (int i = this.sizes.length - 1; i >= 0; --i) {
                double d5 = this.sizes[i];
                double d6 = d5 / d3;
                if (!(d6 < (double)f3) && i != 0) continue;
                d4 = d5;
                break;
            }
            double d7 = d4 / d3;
            this.canvas.strokeWeight(2.0f);
            this.canvas.stroke(0);
            this.canvas.fill(0);
            this.canvas.textSize(10.0f);
            this.canvas.line((float)((double)f2 - d7 / 2.0), this.y, (float)((double)f2 + d7 / 2.0), this.y);
            this.canvas.textAlign(3, 102);
            this.canvas.text(d4 + "", f2, this.y);
        } else if (this.mode == 1) {
            // empty if block
        }
    }

    public MenuItem create(String string) {
        return null;
    }
}

