/*
 * Decompiled with CFR 0.152.
 */
package org.phylowidget.ui;

import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import org.andrewberman.ui.Point;
import org.andrewberman.ui.UIRectangle;
import org.andrewberman.ui.menu.RadialMenu;
import org.phylowidget.render.NodeRange;
import org.phylowidget.tree.PhyloNode;
import org.phylowidget.ui.NodeTraverser;
import processing.core.PApplet;

public final class PhyloContextMenu
extends RadialMenu {
    public NodeTraverser traverser;
    NodeRange curNodeRange;
    Point nodePt = new Point(0.0f, 0.0f);
    private boolean shouldGlow = true;
    Rectangle2D.Float nodeRect = new Rectangle2D.Float();

    public PhyloContextMenu(PApplet pApplet) {
        super(pApplet);
        this.traverser = new NodeTraverser(pApplet);
    }

    public void setOptions() {
        super.setOptions();
        this.modalFocus = true;
        this.setRadii(10.0f, 28.0f);
    }

    public void draw() {
        if (this.curNodeRange != null) {
            this.setPosition(this.curNodeRange.node.getX(), this.curNodeRange.node.getY());
        }
        super.draw();
    }

    public void open(NodeRange nodeRange) {
        super.open();
        this.setNodeRange(nodeRange);
        this.aTween.continueTo(1.0f);
        this.aTween.fforward();
    }

    public void close() {
        super.close();
        if (this.traverser != null) {
            this.traverser.getCurRange();
        }
    }

    public void setGlow(boolean bl) {
        this.traverser.setGlow(bl);
    }

    public PhyloNode getNearestNode() {
        PhyloNode phyloNode = this.traverser.getCurrentNode();
        if (phyloNode != null) {
            return phyloNode;
        }
        return null;
    }

    private void setNodeRange(NodeRange nodeRange) {
        this.curNodeRange = nodeRange;
    }

    public void itemMouseEvent(MouseEvent mouseEvent, Point point) {
        super.itemMouseEvent(mouseEvent, point);
        NodeRange nodeRange = this.curNodeRange;
        if (nodeRange == null) {
            return;
        }
        if (this.mouseInside) {
            return;
        }
        this.nodeRect.setFrameFromDiagonal(nodeRange.loX, nodeRange.loY, nodeRange.hiX, nodeRange.hiY);
        float f = UIRectangle.distToPoint(this.nodeRect, point);
        float f2 = Math.max(this.myRect.width, this.myRect.height) * 0.5f;
        f2 = Math.max(f2, this.radius);
        if (f < f2) {
            if (this.autoDim) {
                float f3 = 1.0f - f / f2;
                this.aTween.continueTo(f3);
                this.aTween.fforward();
            }
        } else {
            this.close();
        }
    }
}

