/*
 * Decompiled with CFR 0.152.
 */
package org.phylowidget.ui;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import org.andrewberman.ui.Color;
import org.andrewberman.ui.unsorted.MethodAndFieldSetter;
import org.phylowidget.PhyloWidget;
import org.phylowidget.TreeManager;
import org.phylowidget.tree.RootedTree;

public class PhyloConfig {
    public boolean debug = false;
    public String remoteConfig = "";
    public String tree = "PhyloWidget";
    public String search = "";
    public String layout = "Rectangular";
    public String menus = "dock.xml;toolbar.xml;context.xml";
    public String backgroundColor = "(255,255,255)";
    public String textColor = "(0,0,0)";
    public String nodeColor = "(0,0,0)";
    public String branchColor = "(0,0,0)";
    public String alignmentColor = "(140,190,50)";
    public String nodeShape = "circle";
    public String angleHandling = "level";
    public float textRotation = 0.0f;
    public float textScaling = 0.8f;
    public float imageSize = 0.95f;
    public float lineWidth = 1.0f;
    public float nodeSize = 2.0f;
    public float innerNodeRatio = 1.0f;
    public float renderThreshold = 200.0f;
    public float minTextSize = 10.0f;
    public float branchScaling = 1.0f;
    public float cigarScaling = 10.0f;
    public float layoutAngle = 0.0f;
    public float animationFrames = 30.0f;
    public float viewportX = 0.0f;
    public float viewportY = 0.0f;
    public float viewportZoom = 0.8f;
    public boolean showScaleBar = false;
    public boolean showCladeLabels = false;
    public boolean useBranchLengths = false;
    public boolean showAllLabels = false;
    public boolean hideAllLabels = false;
    public boolean showAllLeafNodes = false;
    public boolean treatNodesAsLabels = false;
    public boolean prioritizeDistantLabels = false;
    public boolean alignLabels = false;
    public boolean useDoubleBuffering = true;
    public boolean antialias = false;
    public boolean outputAllInnerNodes = false;
    public boolean enforceUniqueLabels = false;
    public boolean outputFullSizeImages = false;
    public boolean useAnimations = true;
    public boolean animateNewTree = false;
    public boolean suppressMessages = false;
    public boolean colorHoveredBranch = true;
    public boolean respondToMouseWheel = true;
    public boolean ignoreAnnotations = false;
    public boolean showBootstrapValues = false;
    public boolean colorSpecies = true;
    public boolean colorDuplications = true;
    public boolean colorBootstrap = true;
    private Color backgroundC = Color.parseColor(this.backgroundColor);
    private Color textC = Color.parseColor(this.textColor);
    private Color nodeC = Color.parseColor(this.nodeColor);
    private Color branchC = Color.parseColor(this.branchColor);
    private Color alignmentC = Color.parseColor(this.alignmentColor);
    public static final String DEFAULT_TREE = "PhyloWidget";

    public void setBackgroundColor(String string) {
        this.backgroundC = Color.parseColor(string);
        this.backgroundColor = string;
    }

    public Color getBackgroundColor() {
        return Color.parseColor(this.backgroundColor);
    }

    public void setTextColor(String string) {
        this.textC = Color.parseColor(string);
        this.textColor = string;
    }

    public Color getTextColor() {
        if (this.textC != null) {
            return this.textC;
        }
        return Color.parseColor(this.textColor);
    }

    public void setNodeColor(String string) {
        this.nodeC = Color.parseColor(string);
        this.nodeColor = string;
    }

    public Color getNodeColor() {
        if (this.nodeC != null) {
            return this.nodeC;
        }
        return Color.parseColor(this.nodeColor);
    }

    public void setBranchColor(String string) {
        this.branchC = Color.parseColor(string);
        this.branchColor = string;
    }

    public Color getBranchColor() {
        if (this.branchC != null) {
            return this.branchC;
        }
        return Color.parseColor(this.branchColor);
    }

    public void setAlignmentColor(String string) {
        this.alignmentC = Color.parseColor(string);
        this.alignmentColor = string;
    }

    public Color getAlignmentColor() {
        if (this.alignmentC != null) {
            return this.alignmentC;
        }
        return Color.parseColor(this.alignmentColor);
    }

    public void setRespondToMouseWheel(boolean bl) {
        if (!bl) {
            TreeManager.camera.makeUnresponsive();
        } else {
            TreeManager.camera.makeResponsive();
        }
    }

    public void setTree(final String string) {
        new Thread(){

            public void run() {
                PhyloWidget.trees.setTree(string);
                PhyloConfig.this.tree = string;
            }
        }.start();
    }

    public void setUseBranchLengths(boolean bl) {
        this.useBranchLengths = bl;
        PhyloWidget.ui.layout();
    }

    public void setSearch(String string) {
        this.search = string;
        PhyloWidget.ui.search();
    }

    public void setEnforceUniqueLabels(boolean bl) {
        this.enforceUniqueLabels = bl;
        RootedTree rootedTree = PhyloWidget.trees.getTree();
        if (rootedTree != null) {
            rootedTree.setEnforceUniqueLabels(bl);
        }
    }

    public void setLayout(String string) {
        if ((string = string.toLowerCase()).equals("diagonal")) {
            PhyloWidget.trees.diagonalRender();
        } else if (string.equals("circular")) {
            PhyloWidget.trees.circleRender();
        } else if (string.equals("unrooted")) {
            PhyloWidget.trees.unrootedRender();
        } else {
            PhyloWidget.trees.rectangleRender();
        }
    }

    public void setRemoteConfig(String string) {
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            URL uRL = new URL(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                String[] stringArray;
                if (string2.startsWith("#") || (stringArray = string2.split("=")).length < 2) continue;
                hashMap.put(stringArray[0], stringArray[1]);
            }
            MethodAndFieldSetter.setMethodsAndFields(this, hashMap);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setMenus(String string) {
        this.menus = string;
        new Thread("Menu Loader"){

            public void run() {
                PhyloWidget.ui.setMenus();
            }
        }.start();
    }

    public void setShowAllLabels(boolean bl) {
        this.showAllLabels = bl;
    }

    public void setPrioritizeDistantLabels(boolean bl) {
        this.prioritizeDistantLabels = bl;
        PhyloWidget.ui.layout();
    }

    public void destroy() {
        this.tree = null;
    }

    public void setTextSize(float f) {
        this.textScaling = f;
    }

    public void setLayoutAngle(float f) {
        this.layoutAngle = f;
        PhyloWidget.ui.forceLayout();
    }

    public void setViewportX(float f) {
        TreeManager.camera.nudgeTo(-f, TreeManager.camera.getY());
    }

    public void setViewportY(float f) {
        TreeManager.camera.nudgeTo(TreeManager.camera.getX(), -f);
    }

    public void setViewportZoom(float f) {
        TreeManager.camera.zoomTo(f);
    }

    public void setBranchScaling(float f) {
        this.branchScaling = f;
        PhyloWidget.ui.forceLayout();
    }

    public void setShowScaleBar(boolean bl) {
        if (bl) {
            PhyloWidget.trees.showScaleBar();
        } else {
            PhyloWidget.trees.hideScaleBar();
        }
    }
}

