/*
 * Decompiled with CFR 0.152.
 */
package org.phylowidget.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import java.util.List;
import org.andrewberman.ui.Point;
import org.andrewberman.ui.menu.Menu;
import org.andrewberman.ui.menu.MenuItem;
import org.phylowidget.PhyloTree;
import org.phylowidget.PhyloWidget;
import org.phylowidget.render.RenderConstants;
import org.phylowidget.tree.PhyloNode;
import processing.core.PApplet;

public class NodeUncollapser
extends Menu {
    PhyloNode node;
    Shape s;
    private Shape origShape;
    public static HashMap<PhyloNode, NodeUncollapser> map = new HashMap();
    boolean mouseJustLeft = false;

    public NodeUncollapser(PApplet pApplet, PhyloNode phyloNode) {
        super(pApplet);
        this.node = phyloNode;
        Polygon polygon = new Polygon();
        polygon.addPoint(0, 10);
        polygon.addPoint(13, 0);
        polygon.addPoint(0, -10);
        this.s = this.origShape = polygon;
        map.put(phyloNode, this);
    }

    public boolean isOpen() {
        return true;
    }

    public static boolean containsNode(PhyloNode phyloNode) {
        return map.containsKey(phyloNode);
    }

    public void draw() {
        super.draw();
        if (!this.node.getTree().isCollapsed(this.node)) {
            System.out.println("No longer collapsed!");
            this.dispose();
        }
        if (!this.node.getTree().containsVertex(this.node)) {
            System.out.println("Doesn't contain!");
            this.dispose();
        }
        float f = this.node.range.render.getNodeRadius();
        float f2 = this.node.range.render.getTextSize();
        float f3 = this.node.range.render.getNodeOffset(this.node) + f2 * RenderConstants.labelSpacing * 2.0f;
        float f4 = (float)((double)f3 * Math.cos(this.node.getAngle()));
        float f5 = (float)((double)f3 * Math.sin(this.node.getAngle()));
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(this.node.getX() + f4, this.node.getY() + f5);
        affineTransform.rotate(this.node.getAngle());
        float f6 = f2 * 0.3f;
        f6 = Math.max(f6, 5.0f);
        affineTransform.scale(f6 /= 10.0f, f6);
        this.s = affineTransform.createTransformedShape(this.origShape);
        this.setPosition(this.node.getX() + f4, this.node.getY() + f5);
        this.setHidden(false);
        for (PhyloNode phyloNode = (PhyloNode)this.node.getParent(); phyloNode != null; phyloNode = (PhyloNode)phyloNode.getParent()) {
            PhyloTree phyloTree = phyloNode.getTree();
            if (phyloTree == null || !phyloTree.isCollapsed(phyloNode)) continue;
            this.setHidden(true);
        }
    }

    public void performAction() {
        super.performAction();
        PhyloWidget.setMessage("");
        this.node.getTree().uncollapseNode(this.node);
        PhyloWidget.ui.layout();
        this.dispose();
    }

    protected void drawMyself() {
        super.drawMyself();
        this.canvas.stroke(100);
        this.canvas.noFill();
        this.canvas.strokeWeight(2.0f);
        this.buff.g2.setColor(new Color(255, 255, 0));
        this.buff.g2.fill(this.s);
        if (this.mouseInside) {
            this.buff.g2.setStroke(new BasicStroke(1.0f));
            this.buff.g2.setColor(new Color(0, 0, 0));
        } else {
            this.buff.g2.setStroke(new BasicStroke(0.5f));
            this.buff.g2.setColor(new Color(0, 140, 200));
        }
        this.buff.g2.draw(this.s);
    }

    protected void itemMouseEvent(MouseEvent mouseEvent, Point point) {
        super.itemMouseEvent(mouseEvent, point);
        if (this.mouseInside) {
            List<PhyloNode> list = this.node.getTree().getChildrenOf(this.node);
            int n = 0;
            for (PhyloNode phyloNode : list) {
                n += phyloNode.getNumLeaves();
            }
            PhyloWidget.setMessage("Click to uncollapse " + n + " leaf nodes.");
        }
        if (!this.mouseInside && !this.mouseJustLeft) {
            this.mouseJustLeft = true;
        }
        if (this.mouseJustLeft) {
            this.mouseJustLeft = false;
            PhyloWidget.setMessage("");
        }
    }

    public void dispose() {
        map.remove(this.node);
        super.dispose();
    }

    protected boolean containsPoint(Point point) {
        return this.s.contains(point.x, point.y);
    }

    public MenuItem create(String string) {
        return null;
    }
}

