/*
 * Decompiled with CFR 0.152.
 */
package org.phylowidget.ui;

import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.andrewberman.ui.AbstractUIObject;
import org.andrewberman.ui.Point;
import org.andrewberman.ui.UIGlobals;
import org.andrewberman.ui.UIRectangle;
import org.andrewberman.ui.UIUtils;
import org.andrewberman.ui.tools.Tool;
import org.andrewberman.ui.tween.Tween;
import org.andrewberman.ui.tween.TweenListener;
import org.andrewberman.ui.tween.TweenQuad;
import org.phylowidget.PhyloTree;
import org.phylowidget.PhyloWidget;
import org.phylowidget.render.NodeRange;
import org.phylowidget.render.RenderConstants;
import org.phylowidget.render.TreeRenderer;
import org.phylowidget.tree.PhyloNode;
import org.phylowidget.tree.RootedTree;
import processing.core.PApplet;

public class NodeTraverser
extends AbstractUIObject
implements TweenListener,
KeyListener {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int UP = 2;
    public static final int DOWN = 3;
    private NodeRange curNodeRange;
    public Tween glowTween;
    boolean isGlowing;
    Point mousePt = new Point();
    ArrayList nearNodes = new ArrayList(10);
    private PApplet p;
    Point pt = new Point();
    UIRectangle rect = new UIRectangle();
    Point tempPt = new Point();
    private boolean glow = true;
    Rectangle2D.Float tempRect = new Rectangle2D.Float();
    boolean pressedWithinNode;

    public NodeTraverser(PApplet pApplet) {
        this.p = pApplet;
        this.glowTween = new Tween(this, TweenQuad.tween, 2, 1.0f, 0.75f, 30.0f);
        UIGlobals.g.event().add(this);
        pApplet.addKeyListener((KeyListener)this);
    }

    public boolean containsPoint(NodeRange nodeRange, Point point) {
        this.tempPt.setLocation(this.getX(nodeRange), this.getY(nodeRange));
        if (nodeRange == null || nodeRange.render == null) {
            return false;
        }
        float f = nodeRange.render.getNodeRadius();
        f = Math.max(f, 2.0f);
        float f2 = (float)point.distance(this.tempPt);
        if (f2 < f) {
            return true;
        }
        Rectangle rectangle = new Rectangle();
        rectangle.setFrameFromDiagonal(nodeRange.loX, nodeRange.loY, nodeRange.hiX, nodeRange.hiY);
        return rectangle.contains(point);
    }

    public void setGlow(boolean bl) {
        this.glow = bl;
    }

    public synchronized void draw() {
        if (this.isGlowing && this.glow) {
            this.glowTween.update();
            float f = PhyloWidget.trees.getRenderer().getTextSize() / 2.0f;
            this.p.noFill();
            this.p.strokeWeight((f *= this.glowTween.getPosition()) / 10.0f);
            int n = RenderConstants.hoverColor.getRGB();
            this.p.stroke(n);
            NodeRange nodeRange = this.getCurRange();
            float f2 = this.getX(nodeRange);
            float f3 = this.getY(nodeRange);
            this.p.ellipse(f2, f3, f, f);
        }
    }

    public void focusEvent(FocusEvent focusEvent) {
    }

    public NodeRange getCurRange() {
        if (this.curNodeRange == null) {
            TreeRenderer treeRenderer = PhyloWidget.trees.getRenderer();
            if (treeRenderer == null) {
                return null;
            }
            RootedTree rootedTree = treeRenderer.getTree();
            PhyloNode phyloNode = (PhyloNode)rootedTree.getRoot();
            this.curNodeRange = this.rangeForNode(treeRenderer, phyloNode);
        }
        return this.curNodeRange;
    }

    public PhyloNode getCurrentNode() {
        NodeRange nodeRange = this.getCurRange();
        return nodeRange.node;
    }

    private NodeRange getNearestNode(float f, float f2) {
        this.getWithinRange(f, f2, 100.0f);
        this.pt.setLocation(f, f2);
        float f3 = Float.MAX_VALUE;
        NodeRange nodeRange = null;
        block3: for (int i = 0; i < this.nearNodes.size(); ++i) {
            NodeRange nodeRange2 = (NodeRange)this.nearNodes.get(i);
            PhyloNode phyloNode = nodeRange2.node;
            switch (nodeRange2.type) {
                case 0: {
                    float f4 = (float)this.pt.distance(this.getX(nodeRange2), this.getY(nodeRange2));
                    if (this.containsPoint(nodeRange2, this.pt)) {
                        f3 = f4;
                        return nodeRange2;
                    }
                    if (!(f4 < f3)) continue block3;
                    nodeRange = nodeRange2;
                    f3 = f4;
                }
            }
        }
        return nodeRange;
    }

    private void getWithinRange(float f, float f2, float f3) {
        float f4 = 1.0f;
        float f5 = f3 * f4;
        this.pt.setLocation(f, f2);
        this.rect.x = (float)(this.pt.getX() - (double)f5);
        this.rect.y = (float)(this.pt.getY() - (double)f5);
        this.rect.width = f5 * 2.0f;
        this.rect.height = f5 * 2.0f;
        UIUtils.screenToModel(this.pt);
        UIUtils.screenToModel(this.rect);
        this.nearNodes.clear();
        PhyloWidget.trees.nodesInRange(this.nearNodes, this.rect);
    }

    float getX(NodeRange nodeRange) {
        return nodeRange.node.getX();
    }

    float getY(NodeRange nodeRange) {
        return nodeRange.node.getY();
    }

    public void keyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() != 401) {
            return;
        }
        if (PhyloWidget.ui.context.isOpen()) {
            return;
        }
        if (UIGlobals.g.focus().getFocusedObject() != null) {
            return;
        }
        int n = keyEvent.getKeyCode();
        Tool tool = UIGlobals.g.event().getToolManager().getCurrentTool();
        switch (n) {
            case 37: {
                this.navigate(0);
                break;
            }
            case 39: {
                this.navigate(1);
                break;
            }
            case 38: {
                this.navigate(2);
                break;
            }
            case 40: {
                this.navigate(3);
                break;
            }
            case 10: {
                if (!tool.respondToOtherEvents() || !this.isGlowing) break;
                this.openContextMenu();
                this.isGlowing = false;
            }
        }
    }

    public void mouseEvent(MouseEvent mouseEvent, Point point, Point point2) {
        PhyloTree phyloTree;
        this.mousePt.setLocation(point);
        this.pt.setLocation(point);
        if (UIGlobals.g.event().getToolManager() == null) {
            return;
        }
        Tool tool = UIGlobals.g.event().getToolManager().getCurrentTool();
        if (tool == null) {
            return;
        }
        if (PhyloWidget.ui.context == null || PhyloWidget.ui.context.isOpen()) {
            return;
        }
        if (this.getCurRange() == null) {
            return;
        }
        if (UIGlobals.g.focus().getFocusedObject() != null) {
            return;
        }
        PhyloWidget.trees.getRenderer().setMouseLocation(this.pt);
        this.setCurRange(this.getNearestNode((float)this.pt.getX(), (float)this.pt.getY()));
        boolean bl = this.containsPoint(this.getCurRange(), this.pt);
        switch (mouseEvent.getID()) {
            case 501: 
            case 506: {
                if (bl && tool.respondToOtherEvents()) {
                    this.pressedWithinNode = true;
                    this.glowTween.stop();
                }
            }
            case 503: {
                phyloTree = (PhyloTree)PhyloWidget.trees.getTree();
                if (bl && tool.respondToOtherEvents()) {
                    UIUtils.setCursor(this, this.p, 12);
                    phyloTree.setHoveredNode(this.getCurRange().node);
                    break;
                }
                UIUtils.releaseCursor(this, this.p);
                phyloTree.setHoveredNode(null);
                break;
            }
            case 500: {
                if (!bl || !tool.respondToOtherEvents() || !this.pressedWithinNode) break;
                this.openContextMenu();
                this.isGlowing = false;
            }
        }
        if (!bl) {
            this.pressedWithinNode = false;
        }
        if (!tool.respondToOtherEvents()) {
            phyloTree = (PhyloTree)PhyloWidget.trees.getTree();
            phyloTree.setHoveredNode(null);
            this.setCurRange(null);
        }
    }

    private void navigate(int n) {
        Cloneable cloneable;
        Point point = new Point();
        NodeRange nodeRange = this.getCurRange();
        if (n == 0 || n == 1) {
            cloneable = nodeRange.render.getTree();
            PhyloNode phyloNode = null;
            if (n == 0) {
                if (((RootedTree)cloneable).getParentOf(nodeRange.node) != null) {
                    phyloNode = ((RootedTree)cloneable).getParentOf(nodeRange.node);
                    this.setCurRange(this.rangeForNode(nodeRange.render, phyloNode));
                    return;
                }
            } else if (n == 1 && !((RootedTree)cloneable).isLeaf(nodeRange.node)) {
                List<PhyloNode> list = ((RootedTree)cloneable).getChildrenOf(nodeRange.node);
                phyloNode = list.get(list.size() - 1);
                this.setCurRange(this.rangeForNode(nodeRange.render, phyloNode));
                return;
            }
        }
        switch (n) {
            case 0: {
                point.setLocation(-1.0, 0.1);
                break;
            }
            case 1: {
                point.setLocation(1.0, -0.1);
                break;
            }
            case 2: {
                point.setLocation(0.0f, -1.0f);
                break;
            }
            case 3: {
                point.setLocation(0.0f, 1.0f);
            }
        }
        this.pt.setLocation(nodeRange.node.getLayoutX(), nodeRange.node.getLayoutY());
        this.getWithinRange(nodeRange.node.getLayoutX(), nodeRange.node.getLayoutY(), 200.0f);
        cloneable = new Point();
        float f = -3.4028235E38f;
        NodeRange nodeRange2 = null;
        for (int i = 0; i < this.nearNodes.size(); ++i) {
            NodeRange nodeRange3 = (NodeRange)this.nearNodes.get(i);
            if (nodeRange3.type == 1 || nodeRange3.node == nodeRange.node) continue;
            ((Point2D.Float)cloneable).setLocation(nodeRange3.node.getLayoutX(), nodeRange3.node.getLayoutY());
            float f2 = this.score(this.pt, (Point)cloneable, point);
            if (!(f2 > f)) continue;
            f = f2;
            nodeRange2 = nodeRange3;
        }
        if (nodeRange2 == null) {
            System.out.println("Nothing near found");
        } else {
            this.setCurRange(nodeRange2);
        }
    }

    void openContextMenu() {
        PhyloWidget.ui.context.open(this.getCurRange());
    }

    private NodeRange rangeForNode(TreeRenderer treeRenderer, PhyloNode phyloNode) {
        return phyloNode.range;
    }

    private void resetGlow() {
        this.glowTween.rewind();
        this.glowTween.start();
    }

    float score(Point point, Point point2, Point point3) {
        point2.translate((float)(-point.getX()), (float)(-point.getY()));
        float f = point2.length();
        float f2 = point3.dotProd(point2);
        if ((double)(f2 / f) < 0.1) {
            return -3.4028235E38f;
        }
        return f2 / f - f / 30.0f;
    }

    public void setCurRange(NodeRange nodeRange) {
        Tool tool;
        if (nodeRange != null && nodeRange != this.curNodeRange && (tool = UIGlobals.g.event().getToolManager().getCurrentTool()).respondToOtherEvents()) {
            RootedTree rootedTree = nodeRange.render.getTree();
            PhyloWidget.ui.updateNodeInfo(rootedTree, nodeRange.node);
        }
        if (nodeRange == null) {
            this.isGlowing = false;
        } else {
            if (!this.isGlowing) {
                this.resetGlow();
            }
            if (nodeRange != this.curNodeRange) {
                this.curNodeRange = nodeRange;
                this.resetGlow();
            }
            this.isGlowing = true;
        }
    }

    public void tweenEvent(Tween tween, int n) {
        if (n == 3) {
            tween.yoyo();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.keyEvent(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.keyEvent(keyEvent);
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.keyEvent(keyEvent);
    }
}

