/*
 * Decompiled with CFR 0.152.
 */
package org.phylowidget.ui;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.andrewberman.ui.UIGlobals;
import org.phylowidget.PhyloWidget;
import org.phylowidget.render.RenderOutput;
import org.phylowidget.render.TreeRenderer;
import processing.core.PApplet;

public class ImageExportDialog
extends Dialog
implements ActionListener {
    public Checkbox zoomToFull;
    Font f;
    private CheckboxGroup nodeLabelOptions;
    private Choice fileFormat;
    private JComboBox imageSize;
    private CheckboxGroup viewportOptions;
    private Button ok;
    private Button cancel;
    private Checkbox vo_entireTree;
    private Checkbox vo_currentView;
    private Checkbox node_showAll;
    private Checkbox node_useMinText;

    public ImageExportDialog(Frame frame) {
        super(frame, "Image Export Options", true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ImageExportDialog.this.dispose();
            }
        });
        this.f = frame.getFont();
        Panel panel = new Panel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        panel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        this.fileFormat = new Choice();
        this.fileFormat.add("PDF");
        this.fileFormat.add("PNG");
        this.fileFormat.add("JPG");
        this.fileFormat.add("TIF");
        int n = UIGlobals.g.getP().width;
        int n2 = UIGlobals.g.getP().height;
        String string = n + "x" + n2;
        String string2 = n * 2 + "x" + n2 * 2;
        String string3 = 4 * n + "x" + 4 * n2;
        String[] stringArray = new String[]{string, string2, string3};
        long l = Runtime.getRuntime().freeMemory();
        System.out.println(l);
        this.imageSize = new JComboBox<String>(stringArray);
        this.imageSize.setEditable(true);
        Component component = this.sectionLabel("<html><b>1) Output Format");
        Component component2 = this.infoLabel("<html><b>Note:</b> the size parameter is ignored for PDF output, which is resolution independent.<br><b>Hint:</b>You can specify arbitrary output dimensions by entering a width and height in the same format as the defaults. But be warned: large sizes may cause memory errors and program crashes!");
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        panel.add(component, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 11;
        panel.add(component2, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        panel.add((Component)this.fileFormat, gridBagConstraints);
        ++gridBagConstraints.gridy;
        panel.add((Component)this.imageSize, gridBagConstraints);
        this.viewportOptions = new CheckboxGroup();
        this.vo_entireTree = new Checkbox("Render the entire tree", true, this.viewportOptions);
        this.vo_currentView = new Checkbox("Use the current viewport", false, this.viewportOptions);
        Component component3 = this.sectionLabel("<html><b>2) Rendering Boundaries");
        Component component4 = this.infoLabel("<html><b>Note:</b> if you choose the \"entire tree\" option, PhyloWidget may cut off parts of the tree, especially with a large minimum text size or branch scaling. If that is the case, just manually zoom to the entire tree and choose the \"current viewport\" option.");
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        panel.add(component3, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 11;
        panel.add(component4, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 10;
        panel.add((Component)this.vo_entireTree, gridBagConstraints);
        ++gridBagConstraints.gridy;
        panel.add((Component)this.vo_currentView, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.nodeLabelOptions = new CheckboxGroup();
        this.node_showAll = new Checkbox("Show ALL node labels", true, this.nodeLabelOptions);
        this.node_useMinText = new Checkbox("Use the minimum text size setting", false, this.nodeLabelOptions);
        Component component5 = this.sectionLabel("<html><b>3) Node Label Display");
        Component component6 = this.infoLabel("<html>Please choose whether PhyloWidget should display <i>all</i> node labels or respect the minimum text size setting.");
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        panel.add(component5, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 11;
        panel.add(component6, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 10;
        panel.add((Component)this.node_showAll, gridBagConstraints);
        ++gridBagConstraints.gridy;
        panel.add((Component)this.node_useMinText, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        Panel panel2 = new Panel();
        this.ok = new Button("Ok");
        this.ok.addActionListener(this);
        this.cancel = new Button("Cancel");
        this.cancel.addActionListener(this);
        panel2.add(this.ok);
        panel2.add(this.cancel);
        panel.add((Component)panel2, gridBagConstraints);
        this.add(panel);
        this.setSize(780, 425);
        this.pack();
        this.validate();
        this.setVisible(true);
    }

    Component infoLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setAlignmentY(0.0f);
        jLabel.setFont(this.f.deriveFont(0, 11.0f));
        jLabel.setPreferredSize(new Dimension(200, 150));
        return jLabel;
    }

    Component sectionLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(this.f.deriveFont(16));
        return jLabel;
    }

    void ok() {
        boolean bl = this.viewportOptions.getSelectedCheckbox() == this.vo_entireTree;
        boolean bl2 = this.nodeLabelOptions.getSelectedCheckbox() == this.node_showAll;
        String string = this.fileFormat.getSelectedItem();
        String string2 = this.imageSize.getSelectedItem().toString();
        String[] stringArray = string2.split("x");
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        TreeRenderer treeRenderer = PhyloWidget.trees.getRenderer();
        PApplet pApplet = UIGlobals.g.getP();
        this.ok.setEnabled(false);
        this.cancel.setEnabled(false);
        if (string.toLowerCase().equals("pdf")) {
            RenderOutput.savePDF(pApplet, treeRenderer, bl, bl2);
        } else {
            RenderOutput.save(pApplet, treeRenderer, bl, bl2, string, n, n2);
        }
        this.dispose();
    }

    void cancel() {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.ok) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ImageExportDialog.this.ok();
                }
            });
        } else if (actionEvent.getSource() == this.cancel) {
            this.dispose();
        }
    }
}

