/*
 * Decompiled with CFR 0.152.
 */
package org.phylowidget.ui;

import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import org.andrewberman.ui.AbstractUIObject;
import org.andrewberman.ui.Point;
import org.andrewberman.ui.UIGlobals;
import org.andrewberman.ui.UIUtils;
import org.andrewberman.ui.tween.Tween;
import org.andrewberman.ui.tween.TweenListener;
import org.andrewberman.ui.tween.TweenQuad;
import org.phylowidget.render.NodeRange;
import org.phylowidget.render.RenderConstants;
import processing.core.PApplet;

public final class HoverHalo
extends AbstractUIObject
implements TweenListener {
    private PApplet p;
    final int type = 1;
    static final int FRAMES = 30;
    Rectangle2D.Float rect;
    Point tempPt;
    NodeRange prevNearest;
    NodeRange curNode;
    Tween aTween;
    Tween wTween;
    Tween hTween;
    public static final int RECTANGLE = 0;
    public static final int ELLIPSE = 1;
    public boolean hidden = true;
    public boolean solid = false;
    public static float hoverMult;

    public HoverHalo(PApplet pApplet) {
        this.p = pApplet;
        UIGlobals.g.event().add(this);
        this.rect = new Rectangle2D.Float(0.0f, 0.0f, 0.0f, 0.0f);
        this.tempPt = new Point(0.0f, 0.0f);
        this.aTween = new Tween(this, TweenQuad.tween, 2, 1.0f, 0.25f, 30.0f);
        this.wTween = new Tween(this, TweenQuad.tween, 2, 1.5f, 1.1f, 30.0f);
        this.hTween = new Tween(this, TweenQuad.tween, 2, 1.5f, 1.1f, 30.0f);
    }

    public void draw() {
        if (this.hidden) {
            return;
        }
        if (UIGlobals.g.focus().getFocusedObject() != null) {
            return;
        }
        NodeRange nodeRange = this.curNode;
        if (nodeRange != this.prevNearest) {
            this.prevNearest = nodeRange;
            this.restart();
        }
        if (nodeRange == null) {
            return;
        }
        float f = 100.0f;
        this.tempPt.setLocation(nodeRange.node.getLayoutX(), nodeRange.node.getLayoutY());
        UIUtils.modelToScreen(this.tempPt);
        float f2 = (float)this.tempPt.distance(this.p.mouseX, this.p.mouseY);
        f2 = f2 > f ? f : f2;
        float f3 = (f - f2) / f * 255.0f;
        float f4 = 50.0f;
        this.rect.setFrameFromCenter(nodeRange.node.getLayoutX(), nodeRange.node.getLayoutY(), nodeRange.node.getLayoutX() - f4, nodeRange.node.getLayoutY() - f4);
        this.aTween.update();
        this.wTween.update();
        this.hTween.update();
        hoverMult = this.wTween.getPosition();
        int n = RenderConstants.hoverColor.getRGB();
        this.p.stroke((float)n * this.aTween.getPosition());
        if (this.solid) {
            this.p.stroke(40.0f, 120.0f, 240.0f, 255.0f);
            this.p.strokeWeight(Math.max(this.rect.width / 20.0f, 3.0f));
        } else {
            this.p.noFill();
            this.p.stroke(40.0f, 120.0f, 240.0f, 255.0f);
            this.p.strokeWeight(Math.max(this.rect.width / 20.0f, 3.0f));
        }
        float f5 = this.wTween.getPosition() * this.rect.width;
        float f6 = this.hTween.getPosition() * this.rect.height;
        float f7 = (float)this.rect.getCenterX();
        float f8 = (float)this.rect.getCenterY();
        switch (1) {
            case 0: {
                this.p.rect(f7 - f5 / 2.0f, f8 - f6 / 2.0f, f5, f6);
                break;
            }
            case 1: {
                this.p.ellipse(f7, f8, f5, f6);
            }
        }
    }

    public void hide() {
        this.hidden = true;
        UIUtils.releaseCursor(this, this.p);
    }

    public void show() {
        this.hidden = false;
        this.restart();
    }

    public void restart() {
        this.solid = false;
        this.aTween.restart(0.75f, 0.25f, 30.0f);
        this.hTween.restart(1.5f, 1.1f, 30.0f);
        this.wTween.restart(1.5f, 1.1f, 30.0f);
    }

    public void becomeSolid() {
        this.hTween.continueTo(1.1f);
        this.hTween.fforward();
        this.hTween.stop();
        this.wTween.continueTo(1.1f);
        this.wTween.fforward();
        this.wTween.stop();
        this.solid = true;
    }

    public void tweenEvent(Tween tween, int n) {
        if (n == 3) {
            tween.yoyo();
        }
    }

    public void keyEvent(KeyEvent keyEvent) {
    }

    public void mouseEvent(MouseEvent mouseEvent, Point point, Point point2) {
        if (this.hidden) {
            return;
        }
        if (UIGlobals.g.focus().getFocusedObject() != null) {
            return;
        }
        Point point3 = point2;
    }

    public void focusEvent(FocusEvent focusEvent) {
    }

    public boolean containsPoint(NodeRange nodeRange, Point point) {
        if (nodeRange == null) {
            return false;
        }
        this.tempPt.setLocation(nodeRange.node.getLayoutX(), nodeRange.node.getLayoutY());
        float f = nodeRange.render.getTextSize() / 2.0f * this.wTween.getPosition();
        f = Math.max(f, 5.0f);
        float f2 = point.x - this.tempPt.x;
        float f3 = point.y - this.tempPt.y;
        return f2 * f2 + f3 * f3 < f * f;
    }
}

