/*
 * Decompiled with CFR 0.152.
 */
package org.phylowidget.ui;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Set;
import org.phylowidget.PhyloWidget;
import org.phylowidget.tree.PhyloNode;
import org.phylowidget.ui.HyperlinkLabel;
import processing.core.PApplet;

public class AnnotationEditorDialog
extends Dialog
implements ActionListener,
KeyListener {
    PApplet p;
    PhyloNode node;
    private Button apply;
    private Button ok;
    private Button cancel;
    private TextArea text;
    String origText;

    public AnnotationEditorDialog(Frame frame, PApplet pApplet) {
        super(frame, "Please enter your annotations. One per line, \"key=value\" format");
        this.setLayout(new BorderLayout());
        this.p = pApplet;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                super.windowClosing(windowEvent);
                AnnotationEditorDialog.this.cancelAnnotations();
            }
        });
        this.addKeyListener(this);
        Container container = new Container();
        container.setLayout(new FlowLayout());
        Label label = new Label("Example annotations: D=Y, B=100, or S=Homo sapiens");
        container.add(label);
        HyperlinkLabel hyperlinkLabel = new HyperlinkLabel("(More Info)", "http://www.phylowidget.org");
        container.add(hyperlinkLabel);
        this.add((Component)container, "North");
        this.text = new TextArea();
        this.text.addKeyListener(this);
        this.add((Component)this.text, "Center");
        this.addButtons();
        this.setSize(new Dimension(400, 250));
        this.pack();
    }

    public void setNode(PhyloNode phyloNode) {
        this.node = phyloNode;
        this.initText();
    }

    void addButtons() {
        Panel panel = new Panel(new FlowLayout(2));
        Dimension dimension = new Dimension(50, 30);
        this.apply = new Button("Apply");
        this.apply.setPreferredSize(dimension);
        this.apply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AnnotationEditorDialog.this.commitAnnotations();
            }
        });
        this.ok = new Button("Ok");
        this.ok.setPreferredSize(dimension);
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AnnotationEditorDialog.this.commitAnnotations();
                AnnotationEditorDialog.this.setVisible(false);
            }
        });
        this.cancel = new Button("Cancel");
        this.cancel.setPreferredSize(dimension);
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AnnotationEditorDialog.this.cancelAnnotations();
            }
        });
        panel.add(new Label("Esc to cancel, Ctrl-Enter to commit.     "));
        panel.add(this.apply);
        panel.add(this.ok);
        panel.add(this.cancel);
        this.add((Component)panel, "South");
    }

    void cancelAnnotations() {
        this.setVisible(false);
    }

    void commitAnnotations() {
        String[] stringArray;
        this.node.clearAnnotations();
        String string = this.text.getText();
        for (String string2 : stringArray = string.split("\n")) {
            if (string2.length() < 2) continue;
            try {
                int n = string2.indexOf(61);
                if (n == -1) continue;
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n + 1, string2.length());
                this.node.setAnnotation(string3, string4);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        PhyloWidget.ui.layout();
        this.node.getTree().modPlus();
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.text.requestFocus();
    }

    void initText() {
        String string = new String();
        HashMap<String, String> hashMap = this.node.getAnnotations();
        if (hashMap == null) {
            this.text.setText(new String());
            return;
        }
        Set<String> set = hashMap.keySet();
        for (String string2 : set) {
            string = string + string2 + "=" + hashMap.get(string2) + "\n";
        }
        this.origText = string;
        this.text.setText(string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (c == '\n') {
            if (keyEvent.isControlDown()) {
                this.commitAnnotations();
                this.setVisible(false);
            }
        } else if (c == '\u001b') {
            this.cancelAnnotations();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

