/*
 * Decompiled with CFR 0.152.
 */
package org.phylowidget.tree;

import java.util.ArrayList;
import java.util.HashMap;
import org.phylowidget.tree.Labelable;
import org.phylowidget.tree.RootedTree;

public class UniqueLabeler {
    public static final char sep = '#';
    private HashMap<String, Object> vertexLabels = new HashMap();

    protected void makeLabelUnique(Object object) {
        if (!(object instanceof Labelable)) {
            return;
        }
        Labelable labelable = (Labelable)object;
        if (labelable.getLabel().length() == 0) {
            labelable.setLabel("#1");
        }
        while (this.vertexLabels.containsKey(labelable.getLabel())) {
            String string = labelable.getLabel();
            int n = string.lastIndexOf(35);
            if (n != -1) {
                String string2 = string.substring(n + 1);
                int n2 = Integer.parseInt(string2) + 1;
                labelable.setLabel(string.substring(0, n + 1) + n2);
                continue;
            }
            labelable.setLabel(string + '#' + 1);
        }
    }

    protected void changeLabel(Object object, String string) {
        if (!(object instanceof Labelable)) {
            return;
        }
        Labelable labelable = (Labelable)object;
        String string2 = labelable.getLabel();
        this.vertexLabels.remove(string2);
        labelable.setLabel(string);
        this.makeLabelUnique(labelable);
        this.vertexLabels.put(labelable.getLabel(), labelable);
    }

    protected void addLabel(Object object) {
        if (!(object instanceof Labelable)) {
            return;
        }
        Labelable labelable = (Labelable)object;
        this.makeLabelUnique(labelable);
        this.vertexLabels.put(labelable.getLabel(), labelable);
    }

    protected void removeLabel(Object object) {
        if (!(object instanceof Labelable)) {
            return;
        }
        Labelable labelable = (Labelable)object;
        this.vertexLabels.remove(labelable.getLabel());
    }

    protected void resetVertexLabels(RootedTree rootedTree) {
        this.vertexLabels.clear();
        ArrayList arrayList = new ArrayList();
        rootedTree.getAll(rootedTree.getRoot(), null, arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            Object e = arrayList.get(i);
            this.makeLabelUnique(e);
            if (!(e instanceof Labelable)) continue;
            this.vertexLabels.put(((Labelable)e).getLabel(), e);
        }
    }

    protected void removeDuplicateTags(RootedTree rootedTree) {
        this.vertexLabels.clear();
        ArrayList arrayList = new ArrayList();
        rootedTree.getAll(rootedTree.getRoot(), null, arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            Labelable labelable;
            String string;
            int n;
            Object e = arrayList.get(i);
            if (!(e instanceof Labelable) || (n = (string = (labelable = (Labelable)e).getLabel()).lastIndexOf(35)) == -1) continue;
            labelable.setLabel(string.substring(0, n));
        }
    }

    public Object getNodeForLabel(String string) {
        return this.vertexLabels.get(string);
    }

    public boolean isLabelSignificant(String string) {
        int n = string.lastIndexOf(35);
        if (n != 0) {
            return true;
        }
        if (n == 0) {
            return false;
        }
        if (string.length() == 0) {
            return false;
        }
        return !string.startsWith("inode");
    }
}

