/*
 * Decompiled with CFR 0.152.
 */
package org.phylowidget.tree;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.jgrapht.traverse.BreadthFirstIterator;
import org.phylowidget.PhyloTree;
import org.phylowidget.PhyloWidget;
import org.phylowidget.TreeManager;
import org.phylowidget.render.images.ImageLoader;
import org.phylowidget.tree.CachedRootedTree;
import org.phylowidget.tree.CachedVertex;
import org.phylowidget.tree.DefaultVertex;
import org.phylowidget.tree.PhyloNode;
import org.phylowidget.tree.RootedTree;

public class TreeIO {
    public static final boolean DEBUG = false;
    static RootedTree oldTree;
    public static final String POOR_MANS_NHX = "**";
    public static final String POOR_MANS_DELIM = "*";
    static final String COLON_REPLACE = "&colon;";
    static Pattern escaper;
    static String naughtyChars;
    static String naughtyRegex;
    static Pattern naughtyPattern;
    static Pattern quotePattern;
    static Pattern singleQuotePattern;
    private static HashMap<String, String> translationMap;

    public static RootedTree parseFile(RootedTree rootedTree, File file) {
        try {
            URI uRI = file.toURI();
            URL uRL = uRI.toURL();
            InputStream inputStream = uRL.openStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            return TreeIO.parseReader(rootedTree, bufferedReader);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static RootedTree parseReader(RootedTree rootedTree, BufferedReader bufferedReader) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        translationMap.clear();
        boolean bl = false;
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.indexOf("#NEXUS") != -1) {
                    bl = true;
                }
                stringBuffer.append(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        if (bl) {
            String string = TreeIO.getNewickFromNexus(stringBuffer.toString());
            return TreeIO.parseNewickString(rootedTree, string);
        }
        return TreeIO.parseNewickString(rootedTree, stringBuffer.toString());
    }

    public static RootedTree parseNewickString(RootedTree rootedTree, String string) {
        boolean bl;
        Object object;
        if (rootedTree instanceof PhyloTree) {
            object = (PhyloTree)rootedTree;
        }
        object = null;
        int n = Math.min(10, string.length() - 1);
        String string2 = string.substring(0, n).toLowerCase();
        if (string2.startsWith("http://") || string2.startsWith("ftp://") || string2.startsWith("file://")) {
            try {
                URL uRL = new URL(string);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
                return TreeIO.parseReader(rootedTree, bufferedReader);
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
                PhyloWidget.setMessage("Error: to load a tree from a URL, please use PhyloWidget Full!");
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        boolean bl2 = string.indexOf("NHX") != -1;
        boolean bl3 = bl = string.indexOf(POOR_MANS_NHX) != -1;
        if (string.startsWith("'(")) {
            string = string.substring(1);
        }
        if (string.endsWith("'")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string.indexOf(59) == -1) {
            string = string + ';';
        }
        NHXHandler nHXHandler = new NHXHandler();
        string = nHXHandler.stripAnnotations(string);
        int[] nArray = new int[50];
        HashMap<Object, DefaultVertex> hashMap = new HashMap<Object, DefaultVertex>(1000);
        int n2 = 0;
        Stack<Object> stack = new Stack<Object>();
        Stack<Double> stack2 = new Stack<Double>();
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        String string3 = "();,";
        StringBuffer stringBuffer = new StringBuffer(10000);
        String string4 = new String();
        long l = string.length();
        int n3 = 0;
        while ((long)n3 < l) {
            boolean bl7;
            char c = string.charAt(n3);
            boolean bl8 = bl7 = c == '(' || c == ')' || c == ';' || c == ',';
            if (bl6) {
                stringBuffer.append(c);
                if (c == '\'') {
                    bl6 = false;
                }
            } else if (c == '\'' && stringBuffer.length() == 0) {
                stringBuffer.append(c);
                bl6 = true;
            } else if (bl7) {
                Object object2;
                if (c == '(' && ++n2 >= nArray.length) {
                    object2 = new int[nArray.length << 2];
                    System.arraycopy(nArray, 0, object2, 0, nArray.length);
                    nArray = object2;
                }
                if (c == ')' || c == ',' || c == ';') {
                    string4 = stringBuffer.toString();
                    string4 = string4.trim();
                    string4 = nHXHandler.replaceAnnotation(string4);
                    object2 = TreeIO.newNode(rootedTree, string4, bl2, bl);
                    if (c == ';') {
                        object = object2;
                    }
                    if (bl5) {
                        DefaultVertex defaultVertex = null;
                        for (int i = 0; i < nArray[n2]; ++i) {
                            defaultVertex = (DefaultVertex)stack.pop();
                            double d = (Double)stack2.pop();
                            Object e = null;
                            if (!rootedTree.containsEdge(object2, defaultVertex)) {
                                e = rootedTree.addEdge(object2, defaultVertex);
                            }
                            e = rootedTree.getEdge(object2, defaultVertex);
                            rootedTree.setEdgeWeight(e, d);
                        }
                        nArray[n2] = 0;
                        hashMap.put(object2, defaultVertex);
                    }
                    stack.push(object2);
                    stack2.push(((CachedVertex)object2).getBranchLengthCache());
                    int n4 = --n2;
                    nArray[n4] = nArray[n4] + 1;
                    stringBuffer.replace(0, stringBuffer.length(), "");
                    bl4 = false;
                    bl5 = false;
                }
                if (c == ')') {
                    bl5 = true;
                }
            } else {
                stringBuffer.append(c);
            }
            ++n3;
        }
        rootedTree.setRoot(object);
        BreadthFirstIterator breadthFirstIterator = new BreadthFirstIterator(rootedTree, rootedTree.getRoot());
        while (breadthFirstIterator.hasNext()) {
            List<DefaultVertex> list;
            DefaultVertex defaultVertex = (DefaultVertex)breadthFirstIterator.next();
            if (rootedTree.isLeaf(defaultVertex) || (list = rootedTree.getChildrenOf(defaultVertex)).get(0) == hashMap.get(defaultVertex)) continue;
            rootedTree.sorting.put((Integer)((Object)defaultVertex), RootedTree.REVERSE);
        }
        oldTree = null;
        if (rootedTree instanceof CachedRootedTree) {
            ((CachedRootedTree)rootedTree).modPlus();
        }
        return rootedTree;
    }

    public static void setOldTree(RootedTree rootedTree) {
        oldTree = rootedTree;
    }

    static PhyloNode newNode(RootedTree rootedTree, String stringArray, boolean bl, boolean bl2) {
        String[] stringArray2;
        int n;
        int n2;
        Object object;
        PhyloNode phyloNode = new PhyloNode();
        String[] stringArray3 = stringArray;
        int n3 = -1;
        if (bl && (n3 = stringArray.indexOf("[&&NHX")) != -1) {
            stringArray3 = stringArray.substring(0, n3);
            String string = stringArray.substring(n3, stringArray.length());
            string = string.replaceAll("(\\[&&NHX:|\\])", "");
            String[] stringArray4 = object = string.split(":");
            int n4 = stringArray4.length;
            for (n2 = 0; n2 < n4; ++n2) {
                String string2 = stringArray4[n2];
                n = (string2 = string2.replaceAll(COLON_REPLACE, ":")).indexOf(61);
                if (n == -1) continue;
                phyloNode.setAnnotation(string2.substring(0, n), string2.substring(n + 1, string2.length()));
            }
        }
        int n5 = stringArray3.indexOf(":");
        object = stringArray3;
        double d = 1.0;
        if (n5 != -1) {
            String string = stringArray3.substring(n5 + 1);
            object = stringArray3.substring(0, n5);
            if (string.contains("[")) {
                int n6 = string.indexOf("[");
                n = string.indexOf("]");
                stringArray2 = string.substring(n6 + 1, n);
                string = string.substring(0, n6);
                if (phyloNode instanceof PhyloNode) {
                    PhyloNode phyloNode2 = phyloNode;
                    phyloNode2.setAnnotation("b", (String)stringArray2);
                }
            }
            try {
                d = Double.parseDouble(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                d = 1.0;
            }
        }
        phyloNode.setBranchLengthCache(d);
        if (bl2 && n3 == -1 && (n2 = object.indexOf(POOR_MANS_NHX)) != -1) {
            String string = object.substring(0, n2);
            String string3 = object.substring(n2 + POOR_MANS_NHX.length(), object.length());
            stringArray2 = string3.split("\\*");
            for (int i = 0; i < stringArray2.length; ++i) {
                String string4 = stringArray2[i];
                if (++i > stringArray2.length - 1) break;
                String string5 = stringArray2[i];
                phyloNode.setAnnotation(string4, string5);
            }
            object = string;
        }
        stringArray = object;
        stringArray = TreeIO.translateName((String)stringArray);
        stringArray = TreeIO.parseNexusLabel((String)stringArray);
        if (oldTree != null) {
            // empty if block
        }
        rootedTree.addVertex(phyloNode);
        rootedTree.setLabel(phyloNode, (String)stringArray);
        return phyloNode;
    }

    static String translateName(String string) {
        String string2 = translationMap.get(string);
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createNewickString(RootedTree rootedTree, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        RootedTree rootedTree2 = rootedTree;
        synchronized (rootedTree2) {
            TreeIO.outputVertex(rootedTree, stringBuffer, rootedTree.getRoot(), bl);
        }
        return stringBuffer.toString() + ";";
    }

    private static void outputVertex(RootedTree rootedTree, StringBuffer stringBuffer, DefaultVertex defaultVertex, boolean bl) {
        PhyloNode phyloNode;
        HashMap<String, String> hashMap;
        double d;
        DefaultVertex defaultVertex2;
        Object object;
        if (!rootedTree.isLeaf(defaultVertex) || rootedTree.isCollapsed(defaultVertex)) {
            stringBuffer.append('(');
            object = rootedTree.getChildrenOf(defaultVertex);
            for (int i = 0; i < object.size(); ++i) {
                TreeIO.outputVertex(rootedTree, stringBuffer, (DefaultVertex)object.get(i), bl);
                if (i == object.size() - 1) continue;
                stringBuffer.append(',');
            }
            stringBuffer.append(')');
        }
        if (((String)(object = TreeIO.getNexusCompliantLabel(rootedTree, defaultVertex, bl))).length() != 0) {
            stringBuffer.append((String)object);
        }
        if ((defaultVertex2 = rootedTree.getParentOf(defaultVertex)) != null && (d = rootedTree.getEdgeWeight(rootedTree.getEdge(defaultVertex2, defaultVertex))) != 1.0) {
            stringBuffer.append(":" + Double.toString(d));
        }
        if (defaultVertex instanceof PhyloNode && (hashMap = (phyloNode = (PhyloNode)defaultVertex).getAnnotations()) != null) {
            stringBuffer.append("[&&NHX");
            Set<String> set = hashMap.keySet();
            for (String string : set) {
                if (string.length() == 0) continue;
                String string2 = hashMap.get(string);
                string2 = string2.replaceAll(":", COLON_REPLACE);
                stringBuffer.append(":" + string + "=" + string2);
            }
            stringBuffer.append("]");
        }
    }

    public static String escapeRE(String string) {
        return escaper.matcher(string).replaceAll("\\\\$1");
    }

    private static String getNexusCompliantLabel(RootedTree rootedTree, DefaultVertex defaultVertex, boolean bl) {
        boolean bl2;
        String string = defaultVertex.toString();
        Matcher matcher = naughtyPattern.matcher(string);
        if (matcher.find()) {
            Matcher matcher2 = quotePattern.matcher(string);
            string = matcher2.replaceAll("''");
            string = "'" + string + "'";
        } else {
            string = string.replaceAll(" ", "_");
        }
        if (!(bl || rootedTree.isLabelSignificant(string) || rootedTree.isLeaf(defaultVertex) || (bl2 = PhyloWidget.cfg.outputAllInnerNodes))) {
            string = "";
        }
        return string;
    }

    private static String parseNexusLabel(String string) {
        if (string.indexOf("'") == 0) {
            string = string.substring(1, string.length() - 1);
            Matcher matcher = singleQuotePattern.matcher(string);
            string = matcher.replaceAll("'");
        }
        if (string.indexOf("_") != -1) {
            string = string.replace('_', ' ');
        }
        return string;
    }

    static Pattern createPattern(String string) {
        return Pattern.compile(string, 34);
    }

    static String removeComments(String string) {
        Pattern pattern = TreeIO.createPattern("(\\[.*?\\])");
        Matcher matcher = pattern.matcher(string);
        String string2 = matcher.replaceAll("");
        return string2;
    }

    static String matchGroup(String string, String string2, int n) {
        Pattern pattern = TreeIO.createPattern(string2);
        Matcher matcher = pattern.matcher(string);
        matcher.find();
        try {
            return matcher.group(n);
        }
        catch (Exception exception) {
            return "";
        }
    }

    static String getTreesBlock(String string) {
        return TreeIO.matchGroup(string, "begin trees;(.*)end;", 1);
    }

    static String getTranslateBlock(String string) {
        return TreeIO.matchGroup(string, "translate(.*?);", 1);
    }

    static String getTreeFromTreesBlock(String string) {
        return TreeIO.matchGroup(string, "tree(.*?);", 1);
    }

    static void getTranslationMap(String string) {
        String string2 = TreeIO.getTranslateBlock(string);
        translationMap = new HashMap();
        if (string2.length() > 0) {
            String[] stringArray;
            for (String string3 : stringArray = string2.split(",")) {
                if ((string3 = string3.trim()).length() < 1) continue;
                String[] stringArray2 = string3.split("[\\s]+");
                String string4 = stringArray2[0].trim();
                String string5 = stringArray2[1].trim();
                translationMap.put(string4, string5);
            }
        }
    }

    static String getNewickFromNexus(String string) {
        string = TreeIO.removeComments(string);
        string = TreeIO.getTreesBlock(string);
        TreeIO.getTranslationMap(string);
        string = TreeIO.getTreeFromTreesBlock(string);
        string = string.substring(string.indexOf("=") + 1);
        string = string.trim();
        return string;
    }

    public static BufferedImage createBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static void outputTreeImages(RootedTree rootedTree, File file) {
        ImageLoader imageLoader = TreeManager.imageLoader;
        ArrayList arrayList = new ArrayList();
        rootedTree.getAll(rootedTree.getRoot(), null, arrayList);
        int n = 0;
        for (PhyloNode phyloNode : arrayList) {
            try {
                if (phyloNode.getAnnotation("img") == null) continue;
                String string = phyloNode.getAnnotation("img");
                Image image = imageLoader.getImageForNode(phyloNode);
                if (image == null) continue;
                image = TreeIO.createBufferedImage(image);
                File file2 = new File(file.getAbsolutePath() + File.separator + n + ".jpg");
                phyloNode.setAnnotation("img", file2.toURL().toString());
                System.out.println(phyloNode.getAnnotation("img"));
                try {
                    ImageIO.write((RenderedImage)((Object)image), "jpg", file2);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                ++n;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    static {
        escaper = Pattern.compile("([^a-zA-Z0-9])");
        naughtyChars = "()[]{}/\\,;:=*'\"`<>^-+~";
        naughtyRegex = "[" + TreeIO.escapeRE(naughtyChars) + "]";
        naughtyPattern = Pattern.compile(naughtyRegex);
        quotePattern = Pattern.compile("'");
        singleQuotePattern = Pattern.compile("('')");
        translationMap = new HashMap();
    }

    public static final class NHXHandler {
        HashMap<String, String> annotationMap = new HashMap();
        Pattern annotationRegex = Pattern.compile("\\[.*?\\]");
        private static final String ANNOT_PREFIX = "#ANNOT_";

        public void clear() {
            this.annotationMap.clear();
        }

        public String stripAnnotations(String string) {
            StringBuffer stringBuffer = new StringBuffer(string);
            int n = 1;
            Matcher matcher = this.annotationRegex.matcher(stringBuffer);
            int n2 = 0;
            while (matcher.find(n2)) {
                String string2 = matcher.group();
                string2 = string2.replaceAll("http:", "http&colon;");
                string2 = string2.replaceAll("ftp:", "ftp&colon;");
                String string3 = ANNOT_PREFIX + String.valueOf(n) + "#";
                this.annotationMap.put(string3, string2);
                stringBuffer.replace(matcher.start(), matcher.end(), string3);
                n2 = matcher.start();
                ++n;
            }
            return stringBuffer.toString();
        }

        public String replaceAnnotation(String string) {
            String string2;
            String string3;
            int n = string.indexOf(ANNOT_PREFIX);
            if (n != -1 && (string3 = this.annotationMap.get(string2 = string.substring(n, string.length()))) != null) {
                string = string.replace(string2, string3);
            }
            return string;
        }
    }
}

