/*
 * Decompiled with CFR 0.152.
 */
package org.phylowidget.tree;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import java.util.WeakHashMap;
import org.jgrapht.Graphs;
import org.jgrapht.alg.DirectedNeighborIndex;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.ListenableDirectedWeightedGraph;
import org.jgrapht.traverse.BreadthFirstIterator;
import org.jgrapht.traverse.CrossComponentIterator;
import org.jgrapht.traverse.DepthFirstIterator;
import org.phylowidget.tree.DefaultVertex;
import org.phylowidget.tree.Labelable;
import org.phylowidget.tree.PhyloNode;
import org.phylowidget.tree.UniqueLabeler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootedTree<V extends DefaultVertex, E extends DefaultWeightedEdge>
extends ListenableDirectedWeightedGraph<V, E> {
    private static final long serialVersionUID = 1L;
    DirectedNeighborIndex<V, E> neighbors;
    V root;
    public WeakHashMap<V, Integer> sorting;
    public static final Integer REVERSE = new Integer(1);
    public static final Integer FORWARD = new Integer(-1);
    public static final int REVERSE_I = 1;
    public static final int FORWARD_I = -1;
    public Comparator<V> enclosedSorter = new EnclosedLeavesComparator(-1);
    public Comparator<V> sorter = new Comparator<V>(){

        @Override
        public int compare(V v, V v2) {
            return ((DefaultVertex)v).getLabel().compareTo(((DefaultVertex)v2).getLabel());
        }
    };
    public Comparator<V> leafSorter = new DepthToRootComparator(1);
    private HashSet<V> collapsedNodes = new HashSet();
    protected boolean useNeighborIndex;
    protected boolean enforceUniqueLabels;
    private UniqueLabeler uniqueLabeler;
    private boolean isValid = true;
    Class<? extends E> edgeClass;
    int fInt = FORWARD;

    public boolean isValid() {
        return this.isValid;
    }

    public RootedTree(Class<? extends E> clazz) {
        super(clazz);
        this.edgeClass = clazz;
        this.setOptions();
        if (this.useNeighborIndex) {
            this.createNeighborIndex();
        }
        this.sorting = new WeakHashMap();
        this.isValid = true;
    }

    void createNeighborIndex() {
        if (this.neighbors != null) {
            this.removeGraphListener(this.neighbors);
        }
        this.neighbors = new DirectedNeighborIndex(this);
        this.addGraphListener(this.neighbors);
    }

    protected void setOptions() {
        this.useNeighborIndex = true;
        this.setEnforceUniqueLabels(true);
    }

    public boolean getEnforceUniqueLabels() {
        return this.enforceUniqueLabels;
    }

    public void setEnforceUniqueLabels(boolean bl) {
        this.enforceUniqueLabels = bl;
        if (bl) {
            this.uniqueLabeler = new UniqueLabeler();
            this.uniqueLabeler.resetVertexLabels(this);
        } else {
            this.uniqueLabeler.removeDuplicateTags(this);
        }
    }

    public boolean isLabelSignificant(String string) {
        if (this.enforceUniqueLabels) {
            return this.uniqueLabeler.isLabelSignificant(string);
        }
        return string.length() > 0;
    }

    public String getLabel(V v) {
        if (this.isCollapsed(v)) {
            List<V> list = this.getChildrenOf(v);
            int n = 0;
            for (DefaultVertex defaultVertex : list) {
                n += this.getNumEnclosedLeaves(defaultVertex);
            }
            return ((DefaultVertex)v).getLabel() + " (" + n + " leaves)";
        }
        return ((DefaultVertex)v).getLabel();
    }

    public void setLabel(Object object, String string) {
        if (this.enforceUniqueLabels) {
            this.uniqueLabeler.changeLabel(object, string);
        } else if (object instanceof Labelable) {
            Labelable labelable = (Labelable)object;
            labelable.setLabel(string);
        }
    }

    public RootedTree<V, E> extractSubtree(V ... VArray) {
        return null;
    }

    public int getNumLineagesAtHeight(double d) {
        List<V> list = this.getAllNodes(this.getRoot());
        int n = 0;
        for (DefaultVertex defaultVertex : list) {
            double d2 = this.getHeightToRoot(defaultVertex);
            double d3 = this.getBranchLength(defaultVertex);
            if (!(d2 > d) || !(d3 < d)) continue;
            ++n;
        }
        return n;
    }

    public List<V> getNodesAtHeight(double d) {
        List<V> list = this.getAllNodes(this.getRoot());
        ArrayList<DefaultVertex> arrayList = new ArrayList<DefaultVertex>(list.size());
        for (DefaultVertex defaultVertex : list) {
            double d2 = this.getHeightToRoot(defaultVertex);
            double d3 = this.getBranchLength(defaultVertex);
            if (!(d2 > d) || !(d3 < d)) continue;
            arrayList.add(defaultVertex);
        }
        return arrayList;
    }

    public List<V> getVerticesForLabels(Collection<String> collection) {
        ArrayList<V> arrayList = new ArrayList<V>(collection.size());
        for (String string : collection) {
            V v = this.getVertexForLabel(string);
            if (v == null) continue;
            arrayList.add(v);
        }
        return arrayList;
    }

    public List<V> getAllLeaves(V v) {
        ArrayList arrayList = new ArrayList();
        this.getAll(v, arrayList, null);
        return arrayList;
    }

    public List<V> getAllNodes(V v) {
        ArrayList arrayList = new ArrayList();
        this.getAll(v, null, arrayList);
        return arrayList;
    }

    public List<String> getLabelsForVertices(Collection<V> collection) {
        ArrayList<String> arrayList = new ArrayList<String>(collection.size());
        for (DefaultVertex defaultVertex : collection) {
            arrayList.add(this.getLabel(defaultVertex));
        }
        return arrayList;
    }

    public V getVertexForLabel(String string) {
        if (this.enforceUniqueLabels) {
            DefaultVertex defaultVertex = (DefaultVertex)this.uniqueLabeler.getNodeForLabel(string);
            return (V)defaultVertex;
        }
        DepthFirstIterator depthFirstIterator = new DepthFirstIterator(this, this.getRoot());
        while (depthFirstIterator.hasNext()) {
            DefaultVertex defaultVertex = (DefaultVertex)depthFirstIterator.next();
            if (!this.getLabel(defaultVertex).equals(string)) continue;
            return (V)defaultVertex;
        }
        return null;
    }

    public double getBranchLength(V v) {
        V v2 = this.getParentOf(v);
        return this.getEdgeWeight(this.getEdge(v2, v));
    }

    public void setBranchLength(V v, double d) {
        V v2 = this.getParentOf(v);
        if (v2 == null) {
            return;
        }
        DefaultWeightedEdge defaultWeightedEdge = (DefaultWeightedEdge)this.getEdge(v2, v);
        this.setEdgeWeight(defaultWeightedEdge, d);
    }

    public void resetVertexLabels() {
        this.uniqueLabeler.resetVertexLabels(this);
    }

    public V createVertex() {
        DefaultVertex defaultVertex = new DefaultVertex();
        return (V)defaultVertex;
    }

    @Override
    public boolean addVertex(V v) {
        if (super.addVertex(v)) {
            if (this.enforceUniqueLabels) {
                this.uniqueLabeler.addLabel(v);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removeVertex(V v) {
        if (super.removeVertex(v)) {
            if (this.enforceUniqueLabels) {
                this.uniqueLabeler.removeLabel(v);
            }
            return true;
        }
        return false;
    }

    public V createAndAddVertex() {
        V v = this.createVertex();
        this.addVertex(v);
        return v;
    }

    public boolean isLeaf(V v) {
        if (this.isCollapsed(v)) {
            return true;
        }
        return this.outDegreeOf(v) == 0;
    }

    public List<V> getChildrenOf(V v) {
        List<Object> list;
        if (this.useNeighborIndex) {
            list = new ArrayList();
            list.addAll(this.neighbors.successorsOf(v));
        } else {
            list = Graphs.successorListOf(this, v);
        }
        return this.sortChildrenList(v, list, this.sorter);
    }

    public void modPlus() {
    }

    List<V> sortChildrenList(V v, List<V> list, Comparator<V> comparator) {
        Collections.sort(list, comparator);
        if (this.getSorting(v) == 1) {
            Collections.reverse(list);
        }
        return list;
    }

    public V getFirstLeaf(V v) {
        V v2 = v;
        while (!this.isLeaf(v2)) {
            v2 = this.getFirstChild(v2);
        }
        return v2;
    }

    public V getFirstChild(V v) {
        return (V)((DefaultVertex)this.getChildrenOf(v).get(0));
    }

    public V getLastChild(V v) {
        List<V> list = this.getChildrenOf(v);
        return (V)((DefaultVertex)list.get(list.size()));
    }

    public V getLastLeaf(V v) {
        V v2 = v;
        while (!this.isLeaf(v2)) {
            v2 = this.getLastChild(v2);
        }
        return v2;
    }

    public V getParentOf(V v) {
        if (this.inDegreeOf(v) == 0) {
            return null;
        }
        if (!this.useNeighborIndex) {
            Set set = this.incomingEdgesOf(v);
            Iterator iterator = set.iterator();
            DefaultWeightedEdge defaultWeightedEdge = (DefaultWeightedEdge)iterator.next();
            return (V)((DefaultVertex)this.getEdgeSource(defaultWeightedEdge));
        }
        Set<V> set = this.neighbors.predecessorsOf(v);
        return (V)((DefaultVertex)set.iterator().next());
    }

    public boolean isRoot(V v) {
        return this.getParentOf(v) == null;
    }

    public boolean isParentChild(V v, V v2) {
        V v3 = v2;
        while (v3 != null) {
            if (v3 == v) {
                return true;
            }
            v3 = this.getParentOf(v3);
        }
        return false;
    }

    public int getMaxDepthToLeaf(V v) {
        int n = 0;
        BreadthFirstIterator breadthFirstIterator = new BreadthFirstIterator(this, v);
        while (breadthFirstIterator.hasNext()) {
            int n2;
            DefaultVertex defaultVertex = (DefaultVertex)breadthFirstIterator.next();
            if (!this.isLeaf(defaultVertex) || (n2 = this.getDepthToVertex(defaultVertex, v)) <= n) continue;
            n = n2;
        }
        return n;
    }

    public int getDepthToRoot(V v) {
        if (v == this.getRoot()) {
            return 0;
        }
        return this.getDepthToVertex(v, this.getRoot());
    }

    int getDepthToVertex(V v, V v2) {
        return Math.abs(this.getDepthToRoot(v) - this.getDepthToRoot(v2));
    }

    public double getHeightToVertex(V v, V v2) {
        double d = this.getHeightToRoot(v);
        double d2 = this.getHeightToRoot(v2);
        return d2 - d;
    }

    public V getFurthestLeafFromVertex(V v) {
        double d = 0.0;
        Object object = v;
        BreadthFirstIterator breadthFirstIterator = new BreadthFirstIterator(this, v);
        while (breadthFirstIterator.hasNext()) {
            double d2;
            DefaultVertex defaultVertex = (DefaultVertex)breadthFirstIterator.next();
            if (!this.isLeaf(defaultVertex) || !((d2 = this.getHeightToRoot(defaultVertex)) >= d)) continue;
            d = d2;
            object = defaultVertex;
        }
        return object;
    }

    public double getMaxHeightToLeaf(V v) {
        double d = this.getHeightToRoot(v);
        double d2 = 0.0;
        BreadthFirstIterator breadthFirstIterator = new BreadthFirstIterator(this, v);
        while (breadthFirstIterator.hasNext()) {
            double d3;
            DefaultVertex defaultVertex = (DefaultVertex)breadthFirstIterator.next();
            if (!this.isLeaf(defaultVertex) || !((d3 = this.getHeightToRoot(defaultVertex)) >= d2)) continue;
            d2 = d3;
        }
        return d2 - d;
    }

    public double getHeightToRoot(V v) {
        double d = 0.0;
        while (v != this.root) {
            V v2 = this.getParentOf(v);
            DefaultWeightedEdge defaultWeightedEdge = (DefaultWeightedEdge)this.getEdge(v2, v);
            d += this.getEdgeWeight(defaultWeightedEdge);
            v = v2;
        }
        return d;
    }

    public synchronized int getNumEnclosedLeaves(V v) {
        return this.getEnclosedLeaves(v).size();
    }

    public int getMaxChildEnclosed(V v) {
        if (this.isLeaf(v)) {
            return 0;
        }
        List<V> list = this.getChildrenOf(v);
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            int n2 = this.getNumEnclosedLeaves((DefaultVertex)list.get(i));
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public synchronized void getAll(V v, List<V> list, List<V> list2) {
        if (v == null) {
            return;
        }
        Stack<Object> stack = new Stack<Object>();
        stack.push(v);
        while (!stack.isEmpty()) {
            DefaultVertex defaultVertex = (DefaultVertex)stack.pop();
            if (this.isLeaf(defaultVertex)) {
                if (list != null) {
                    list.add(defaultVertex);
                }
            } else {
                List<DefaultVertex> list3 = this.getChildrenOf(defaultVertex);
                for (int i = list3.size() - 1; i >= 0; --i) {
                    stack.add(list3.get(i));
                }
            }
            if (list2 == null) continue;
            list2.add(defaultVertex);
        }
    }

    private List<V> getEnclosedVertices(V v) {
        ArrayList arrayList = new ArrayList();
        BreadthFirstIterator breadthFirstIterator = new BreadthFirstIterator(this, v);
        while (breadthFirstIterator.hasNext()) {
            arrayList.add(breadthFirstIterator.next());
        }
        return arrayList;
    }

    private List<V> getEnclosedLeaves(V v) {
        ArrayList<DefaultVertex> arrayList = new ArrayList<DefaultVertex>();
        BreadthFirstIterator breadthFirstIterator = new BreadthFirstIterator(this, v);
        while (breadthFirstIterator.hasNext()) {
            DefaultVertex defaultVertex = (DefaultVertex)breadthFirstIterator.next();
            if (!this.isLeaf(defaultVertex)) continue;
            arrayList.add(defaultVertex);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deleteSubtree(V v) {
        Object object;
        if (v == this.getRoot()) {
            object = this.createAndAddVertex();
            this.setRoot(object);
        }
        if (this.isLeaf(v)) {
            this.removeVertex(v);
        } else {
            object = this.getEnclosedVertices(v);
            RootedTree rootedTree = this;
            synchronized (rootedTree) {
                for (int i = 0; i < object.size(); ++i) {
                    this.removeVertex((V)((DefaultVertex)object.get(i)));
                }
            }
        }
    }

    public void deleteLeafLineage(V v) {
        V v2 = this.getParentOf(v);
        this.removeVertex(v);
        if (v2 != null && this.isLeaf(v2)) {
            this.deleteLeafLineage(v2);
        }
    }

    public synchronized void deleteNode(V v) {
        if (this.getParentOf(v) != null) {
            V v2 = this.getParentOf(v);
            double d = this.getEdgeWeight(this.getEdge(v2, v));
            List<V> list = this.getChildrenOf(v);
            for (int i = 0; i < list.size(); ++i) {
                DefaultVertex defaultVertex = (DefaultVertex)list.get(i);
                double d2 = this.getEdgeWeight(this.getEdge(v, defaultVertex));
                DefaultWeightedEdge defaultWeightedEdge = (DefaultWeightedEdge)this.addEdge(v2, defaultVertex);
                this.setEdgeWeight(defaultWeightedEdge, d + d2);
            }
            this.removeVertex(v);
        } else {
            V v3 = this.createAndAddVertex();
            this.setRoot(v3);
            this.removeVertex(v);
        }
    }

    public RootedTree<V, E> cloneSubtree(V v) {
        RootedTree rootedTree;
        Object object;
        try {
            object = this.getClass().getConstructor(new Class[0]);
            rootedTree = (RootedTree)((Constructor)object).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        object = new Stack();
        Stack<Object> stack = new Stack<Object>();
        ((Stack)object).push(v);
        V v2 = rootedTree.createAndAddVertex();
        ((DefaultVertex)v2).setLabel(((DefaultVertex)v).getLabel());
        rootedTree.setRoot(v2);
        stack.push(v2);
        while (!((Vector)object).isEmpty()) {
            DefaultVertex defaultVertex = (DefaultVertex)((Stack)object).pop();
            DefaultVertex defaultVertex2 = (DefaultVertex)stack.pop();
            List<DefaultVertex> list = this.getChildrenOf(defaultVertex);
            for (int i = 0; i < list.size(); ++i) {
                DefaultVertex defaultVertex3 = list.get(i);
                ((Stack)object).push(defaultVertex3);
                double d = this.getEdgeWeight(this.getEdge(defaultVertex, defaultVertex3));
                DefaultVertex defaultVertex4 = (DefaultVertex)defaultVertex3.clone();
                rootedTree.addVertex((V)defaultVertex4);
                stack.push(defaultVertex4);
                DefaultWeightedEdge defaultWeightedEdge = (DefaultWeightedEdge)rootedTree.addEdge(defaultVertex2, defaultVertex4);
                rootedTree.setEdgeWeight(defaultWeightedEdge, d);
            }
        }
        return rootedTree;
    }

    public void addSisterNode(V v, V v2) {
        V v3 = this.getParentOf(v);
        V v4 = this.createAndAddVertex();
        if (v == this.getRoot()) {
            this.setRoot(v4);
            this.addEdge(v4, v2);
            this.addEdge(v4, v);
        } else {
            this.insertNodeBetween(v3, v, v4);
        }
        this.addEdge(v4, v2);
        double d = this.getEdgeWeight(this.getEdge(v4, v));
        this.setEdgeWeight(this.getEdge(v4, v2), d);
        this.modPlus();
    }

    public void addChildNode(V v) {
        V v2 = this.createAndAddVertex();
        this.addEdge(v, v2);
    }

    public void insertNodeBetween(V v, V v2, V v3) {
        DefaultWeightedEdge defaultWeightedEdge = (DefaultWeightedEdge)this.getEdge(v, v2);
        double d = this.getEdgeWeight(defaultWeightedEdge);
        DefaultWeightedEdge defaultWeightedEdge2 = (DefaultWeightedEdge)this.addEdge(v, v3);
        this.setEdgeWeight(defaultWeightedEdge2, d / 2.0);
        DefaultWeightedEdge defaultWeightedEdge3 = (DefaultWeightedEdge)this.addEdge(v3, v2);
        this.setEdgeWeight(defaultWeightedEdge3, d / 2.0);
        this.removeEdge(v, v2);
        this.modPlus();
    }

    public void reroot(V v) {
        Object object;
        this.isValid = false;
        if (v == this.root || this.getParentOf(v) == this.root) {
            return;
        }
        DefaultWeightedEdge defaultWeightedEdge = null;
        Object v2 = null;
        v2 = v;
        while (this.getParentOf(v2) != null && this.getParentOf(v2) != this.root) {
            v2 = this.getParentOf(v2);
        }
        double d = this.getEdgeWeight(this.getEdge(this.root, v2));
        List<V> list = this.getChildrenOf(this.root);
        for (int i = 0; i < list.size(); ++i) {
            object = (DefaultVertex)list.get(i);
            if (object == v2) continue;
            defaultWeightedEdge = (DefaultWeightedEdge)this.getEdge(this.root, object);
            double d2 = this.getEdgeWeight(defaultWeightedEdge);
            this.removeEdge(v2, object);
            defaultWeightedEdge = (DefaultWeightedEdge)this.addEdge(v2, object);
            this.setEdgeWeight(defaultWeightedEdge, d2 + d);
        }
        this.removeVertex(this.root);
        V v3 = this.createAndAddVertex();
        this.insertNodeBetween(this.getParentOf(v), v, v3);
        this.root = v3;
        object = new BreadthFirstIterator(Graphs.undirectedGraph(this), this.root);
        LinkedList linkedList = new LinkedList();
        while (((CrossComponentIterator)object).hasNext()) {
            linkedList.addLast(((CrossComponentIterator)object).next());
        }
        HashMap<DefaultVertex, Integer> hashMap = new HashMap<DefaultVertex, Integer>();
        Integer n = new Integer(1);
        while (!linkedList.isEmpty()) {
            DefaultVertex defaultVertex = (DefaultVertex)linkedList.removeFirst();
            List<DefaultVertex> list2 = Graphs.neighborListOf(this, defaultVertex);
            for (int i = 0; i < list2.size(); ++i) {
                DefaultVertex defaultVertex2 = list2.get(i);
                if (hashMap.containsKey(defaultVertex2)) continue;
                double d3 = 1.0;
                if (this.containsEdge(defaultVertex, defaultVertex2)) {
                    d3 = this.getEdgeWeight(this.getEdge(defaultVertex, defaultVertex2));
                } else if (this.containsEdge(defaultVertex2, defaultVertex)) {
                    d3 = this.getEdgeWeight(this.getEdge(defaultVertex2, defaultVertex));
                }
                this.removeEdge(defaultVertex, defaultVertex2);
                this.removeEdge(defaultVertex2, defaultVertex);
                defaultWeightedEdge = (DefaultWeightedEdge)this.addEdge(defaultVertex, defaultVertex2);
                this.setEdgeWeight(defaultWeightedEdge, d3);
            }
            hashMap.put(defaultVertex, n);
        }
        this.isValid = true;
    }

    public void flipChildren(V v) {
        Integer n = this.sorting.get(v);
        if (n == null) {
            this.setSorting(v, REVERSE);
        } else if (n == REVERSE) {
            this.setSorting(v, FORWARD);
        } else {
            this.setSorting(v, REVERSE);
        }
    }

    public void reverseSubtree(V v) {
        ArrayList arrayList = new ArrayList();
        this.getAll(v, null, arrayList);
        for (DefaultVertex defaultVertex : arrayList) {
            this.flipChildren(defaultVertex);
        }
        this.modPlus();
    }

    public void ladderizeSubtree(V v) {
        BreadthFirstIterator breadthFirstIterator = new BreadthFirstIterator(this, v);
        while (breadthFirstIterator.hasNext()) {
            DefaultVertex defaultVertex = (DefaultVertex)breadthFirstIterator.next();
            List<DefaultVertex> list = this.getChildrenOf(defaultVertex);
            if (list.size() > 0) {
                DefaultVertex defaultVertex2 = list.get(0);
                this.sortChildrenList(defaultVertex, list, this.enclosedSorter);
                DefaultVertex defaultVertex3 = list.get(0);
                if (defaultVertex2 != defaultVertex3) {
                    this.setSorting(defaultVertex, REVERSE);
                    continue;
                }
                this.setSorting(defaultVertex, FORWARD);
                continue;
            }
            this.setSorting(defaultVertex, FORWARD);
        }
    }

    public void setSorting(V v, int n) {
        if (this.fInt == n) {
            this.sorting.put((Integer)v, FORWARD);
        } else {
            this.sorting.put((Integer)v, REVERSE);
        }
    }

    public int getSorting(V v) {
        Integer n = this.sorting.get(v);
        if (n == null || n == FORWARD) {
            return -1;
        }
        return 1;
    }

    public void removeElbowsBelow(V v) {
        ArrayList arrayList = new ArrayList();
        this.getAll(v, null, arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            DefaultVertex defaultVertex;
            DefaultVertex defaultVertex2 = (DefaultVertex)arrayList.get(i);
            if (this.getParentOf(defaultVertex2) != null && this.getChildrenOf(defaultVertex2).size() == 1) {
                defaultVertex = this.getParentOf(defaultVertex2);
                DefaultVertex defaultVertex3 = this.getChildrenOf(defaultVertex2).get(0);
                double d = this.getEdgeWeight(this.getEdge(defaultVertex, defaultVertex2));
                this.removeVertex((V)defaultVertex2);
                this.addEdge(defaultVertex, defaultVertex3);
                this.setEdgeWeight(this.getEdge(defaultVertex, defaultVertex3), d += this.getEdgeWeight(this.getEdge(defaultVertex2, defaultVertex3)));
                continue;
            }
            if (this.getParentOf(defaultVertex2) != null || this.getChildrenOf(defaultVertex2).size() != 1) continue;
            defaultVertex = this.getChildrenOf(defaultVertex2).get(0);
            this.setBranchLength(defaultVertex, 0.0);
            this.setRoot(defaultVertex);
            this.removeVertex((V)defaultVertex2);
        }
    }

    public V getRoot() {
        return this.root;
    }

    public void setRoot(V v) {
        this.root = v;
    }

    public void alignLeaves() {
        DepthFirstIterator depthFirstIterator = new DepthFirstIterator(this, this.getRoot());
        LinkedList linkedList = new LinkedList();
        while (depthFirstIterator.hasNext()) {
            linkedList.add(depthFirstIterator.next());
        }
        while (!linkedList.isEmpty()) {
            double d;
            double d2;
            DefaultVertex defaultVertex = (DefaultVertex)linkedList.removeLast();
            if (this.isLeaf(defaultVertex)) continue;
            List<DefaultVertex> list = this.getChildrenOf(defaultVertex);
            double d3 = 0.0;
            for (DefaultVertex defaultVertex2 : list) {
                d2 = this.getMaxHeightToLeaf(defaultVertex2);
                d = this.getBranchLength(defaultVertex2);
                d3 += d2 + d;
            }
            d3 /= (double)list.size();
            for (DefaultVertex defaultVertex2 : list) {
                d2 = this.getMaxHeightToLeaf(defaultVertex2);
                if (d2 + (d = this.getBranchLength(defaultVertex2)) == 0.0) {
                    d2 = 1.0E-5;
                }
                double d4 = d3 / (d2 + d);
                this.scaleSubtree(defaultVertex2, d4);
            }
        }
    }

    public void resolvePolytomy(V v, double d) {
        List<V> list = this.getChildrenOf(v);
        if (list.size() <= 2) {
            return;
        }
        double d2 = this.getBranchLength(v);
        for (DefaultVertex defaultVertex : list) {
            double d3 = this.getBranchLength(defaultVertex);
            if (!(d3 < d2)) continue;
            d2 = d3;
        }
        double d4 = d2 / 3.0;
        d4 = Math.min(d4, d);
        DefaultVertex defaultVertex = (DefaultVertex)list.get(0);
        V v2 = this.createAndAddVertex();
        this.addEdge(v, v2);
        this.setBranchLength(v2, d4);
        this.setBranchLength(v, this.getBranchLength(v) - d4 / 2.0);
        for (DefaultVertex defaultVertex2 : list) {
            if (defaultVertex2 == defaultVertex) continue;
            double d5 = this.getBranchLength(defaultVertex2);
            this.removeEdge(v, defaultVertex2);
            this.addEdge(v2, defaultVertex2);
            this.setBranchLength(defaultVertex2, d5 - d4 / 2.0);
        }
        this.modPlus();
        this.resolvePolytomy(v2);
    }

    public void resolvePolytomy(V v) {
        double d = Double.MAX_VALUE;
        this.resolvePolytomy(v, d);
    }

    public V getCommonAncestorOf(String ... stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Collections.addAll(arrayList, stringArray);
        List<V> list = this.getVerticesForLabels(arrayList);
        if (list.size() == 0) {
            return null;
        }
        return (V)this.getCommonAncestorOf(list.toArray(this.emptyArray(new DefaultVertex[]{(DefaultVertex)list.get(0)})));
    }

    private V[] emptyArray(V ... VArray) {
        DefaultVertex[] defaultVertexArray = (DefaultVertex[])Array.newInstance(VArray.getClass().getComponentType(), 0);
        return defaultVertexArray;
    }

    public V getCommonAncestorOf(V ... VArray) {
        V v = VArray[0];
        V v2 = null;
        for (int i = 1; i < VArray.length; ++i) {
            v2 = VArray[i];
            v = this.getCommonAncestorOf(v, v2);
        }
        return v;
    }

    public V getCommonAncestorOf(String string, String string2) {
        return this.getCommonAncestorOf(this.getVertexForLabel(string), this.getVertexForLabel(string2));
    }

    public V getCommonAncestorOf(V v, V v2) {
        HashSet<V> hashSet = new HashSet<V>();
        V v3 = v;
        V v4 = v2;
        V v5 = this.getRoot();
        do {
            if (v3 != v5 && v3 != null) {
                if (hashSet.contains(v3)) {
                    return v3;
                }
                hashSet.add(v3);
                v3 = this.getParentOf(v3);
            }
            if (v4 != v5 && v4 != null) {
                if (hashSet.contains(v4)) {
                    return v4;
                }
                hashSet.add(v4);
                v4 = this.getParentOf(v4);
            }
            if (v3 != v5 || v4 != v5) continue;
            return v3;
        } while (v3 != null);
        return null;
    }

    public void collapseNode(V v) {
        this.collapsedNodes.add(v);
        this.modPlus();
    }

    public void uncollapseNode(V v) {
        this.collapsedNodes.remove(v);
        this.modPlus();
    }

    public boolean isCollapsed(V v) {
        return this.collapsedNodes.contains(v);
    }

    public List<V> getAllCollapsedNodes() {
        ArrayList<DefaultVertex> arrayList = new ArrayList<DefaultVertex>();
        List<V> list = this.getAllNodes(this.getRoot());
        for (DefaultVertex defaultVertex : list) {
            if (!this.isCollapsed(defaultVertex)) continue;
            arrayList.add(defaultVertex);
        }
        return arrayList;
    }

    public void uncollapseAllNodes() {
        DepthFirstIterator depthFirstIterator = new DepthFirstIterator(this, this.getRoot());
        depthFirstIterator.next();
        while (depthFirstIterator.hasNext()) {
            DefaultVertex defaultVertex = (DefaultVertex)depthFirstIterator.next();
            if (!this.isCollapsed(defaultVertex)) continue;
            this.uncollapseNode(defaultVertex);
        }
    }

    public void scaleSubtree(V v, double d) {
        DepthFirstIterator depthFirstIterator = new DepthFirstIterator(this, v);
        depthFirstIterator.next();
        while (depthFirstIterator.hasNext()) {
            DefaultVertex defaultVertex = (DefaultVertex)depthFirstIterator.next();
            this.setBranchLength(defaultVertex, this.getBranchLength(defaultVertex) * d);
        }
    }

    public void evenlySpaceLineage(V v, V v2) {
        double d = this.getHeightToVertex(v, v2);
        double d2 = this.getDepthToVertex(v, v2);
        double d3 = d / d2;
        V v3 = v2;
        while (v3 != v) {
            this.setBranchLength(v3, d3);
            v3 = this.getParentOf(v3);
        }
    }

    public void makeSubtreeUltrametric(V v) {
        this.makeSubtreeUltrametric(v, 1.0, false);
    }

    public void makeSubtreeUltrametric(V v, double d, boolean bl) {
        double d2 = this.getMaxDepthToLeaf(v);
        if (bl) {
            d2 = this.getMaxDepthToLeaf(this.getParentOf(v));
        }
        double d3 = d / d2;
        HashMap<DefaultVertex, Double> hashMap = new HashMap<DefaultVertex, Double>();
        DepthFirstIterator depthFirstIterator = new DepthFirstIterator(this, v);
        while (depthFirstIterator.hasNext()) {
            DefaultVertex defaultVertex = (DefaultVertex)depthFirstIterator.next();
            if (defaultVertex == v && !bl) continue;
            if (this.isLeaf(defaultVertex)) {
                double d4 = this.getDepthToVertex(defaultVertex, v);
                double d5 = d4 * d3;
                double d6 = d - d5;
                hashMap.put(defaultVertex, d6);
                continue;
            }
            hashMap.put(defaultVertex, d3);
        }
        this.setBranchLengths(hashMap);
    }

    public void setBranchLengths(Map<V, Double> map) {
        Set<V> set = map.keySet();
        for (DefaultVertex defaultVertex : set) {
            this.setBranchLength(defaultVertex, map.get(defaultVertex));
        }
    }

    public void pruneNodes(List<V> list) {
        int n = 0;
        for (DefaultVertex defaultVertex : list) {
            ++n;
            if (this.isLeaf(defaultVertex)) {
                this.deleteLeafLineage(defaultVertex);
                continue;
            }
            this.deleteNode(defaultVertex);
        }
    }

    public void spliceOutInternalNode(V v) {
        List<V> list = this.getChildrenOf(v);
    }

    public void translateLabels(V v, Map<String, String> map) {
        DepthFirstIterator depthFirstIterator = new DepthFirstIterator(this, v);
        while (depthFirstIterator.hasNext()) {
            DefaultVertex defaultVertex = (DefaultVertex)depthFirstIterator.next();
            String string = this.getLabel(defaultVertex);
            String string2 = map.get(string);
            if (string2 == null) continue;
            this.setLabel(defaultVertex, string2);
        }
    }

    public void pruneNodesByLabel(List<String> list) {
        List<V> list2 = this.getVerticesForLabels(list);
        for (DefaultVertex defaultVertex : list2) {
            this.deleteSubtree(defaultVertex);
        }
    }

    public void dispose() {
        this.sorting = null;
        this.neighbors = null;
        this.root = null;
        this.uniqueLabeler = null;
    }

    public class EnclosedLeavesComparator
    implements Comparator {
        int dir;

        public EnclosedLeavesComparator(int n) {
            this.dir = n;
        }

        public int compare(Object object, Object object2) {
            int n = RootedTree.this.getNumEnclosedLeaves((DefaultVertex)object);
            int n2 = RootedTree.this.getNumEnclosedLeaves((DefaultVertex)object2);
            if (this.dir == 1) {
                if (n > n2) {
                    return 1;
                }
                if (n < n2) {
                    return -1;
                }
                return 0;
            }
            if (n > n2) {
                return -1;
            }
            if (n < n2) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object object, Object object2) {
            return this.compare(object, object) == 0;
        }
    }

    public class DepthToRootComparator
    implements Comparator {
        int dir;

        public DepthToRootComparator(int n) {
            this.dir = n;
        }

        public int compare(Object object, Object object2) {
            if (object.getClass() == PhyloNode.class) {
                String string = ((PhyloNode)object).getAnnotation("PW_Z");
                String string2 = ((PhyloNode)object2).getAnnotation("PW_Z");
                if (string != null && string2 == null) {
                    return 1 * -this.dir;
                }
                if (string2 != null && string == null) {
                    return -1 * -this.dir;
                }
                if (string != null && string2 != null) {
                    int n;
                    int n2 = Integer.parseInt(string);
                    if (n2 == (n = Integer.parseInt(string2))) {
                        return 0;
                    }
                    if (n2 > n) {
                        return 1 * -this.dir;
                    }
                    return -1 * -this.dir;
                }
            }
            int n = RootedTree.this.getDepthToRoot((DefaultVertex)object);
            int n3 = RootedTree.this.getDepthToRoot((DefaultVertex)object2);
            if (this.dir == 1) {
                if (n > n3) {
                    return 1;
                }
                if (n < n3) {
                    return -1;
                }
                return 0;
            }
            if (n > n3) {
                return -1;
            }
            if (n < n3) {
                return 1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class VertexAndDouble {
        public V v;
        public double d;
        final /* synthetic */ RootedTree this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        public VertexAndDouble(V v, double d2) {
            void var2_-1;
            this.this$0 = (RootedTree)d;
            this.v = var2_-1;
            this.d = (double)v;
        }
    }
}

