/*
 * Decompiled with CFR 0.152.
 */
package org.phylowidget.tree;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import org.andrewberman.ui.tween.Tween;
import org.andrewberman.ui.tween.TweenQuad;
import org.phylowidget.PhyloTree;
import org.phylowidget.PhyloWidget;
import org.phylowidget.UsefulConstants;
import org.phylowidget.render.NodeRange;
import org.phylowidget.render.images.ImageSearcher;
import org.phylowidget.tree.CachedVertex;
import org.phylowidget.tree.RootedTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PhyloNode
extends CachedVertex
implements Comparable,
UsefulConstants {
    private double layoutX;
    private double layoutY;
    private float realX;
    private float realY;
    private float angle;
    public Point2D[] corners = new Point2D.Float[]{new Point2D.Float(), new Point2D.Float(), new Point2D.Float(), new Point2D.Float()};
    public Rectangle2D.Float rect = new Rectangle2D.Float();
    private byte textAlign = 0;
    public static final byte ALIGN_LEFT = 0;
    public static final byte ALIGN_RIGHT = 1;
    public float textMult;
    public float unitTextWidth;
    public boolean drawMe;
    public boolean isWithinScreen;
    public float bulgeFactor = 1.0f;
    public boolean found = false;
    private int sorting = RootedTree.FORWARD;
    private int state = 0;
    public static final int NONE = 0;
    public static final int CUT = 1;
    public static final int COPY = 2;
    static TweenQuad quad = TweenQuad.tween;
    static final float mult = 10000.0f;
    HashMap<String, String> annotations;
    private Tween xTween = new Tween(null, quad, 1, (float)this.layoutX, (float)this.layoutX, 30.0f);
    private Tween yTween = new Tween(null, quad, 1, (float)this.layoutY, (float)this.layoutY, 30.0f);
    public boolean labelWasDrawn;
    public boolean drawLineAndNode;
    public boolean drawLabel;
    public float lastTextSize;
    private ImageSearcher searchResults;
    public NodeRange range = new NodeRange();

    public PhyloNode() {
        this.range.node = this;
    }

    public void loadThumbImage() {
        if (this.searchResults == null) {
            this.searchResults = new ImageSearcher(this);
        } else {
            this.searchResults.next();
        }
        this.searchResults.loadThumbnailURL();
    }

    public void loadFullImage() {
        if (this.searchResults != null) {
            this.searchResults.loadFullImageURL();
        }
    }

    public String getFullImageURL() {
        return this.searchResults.getFullImageURL();
    }

    @Override
    public double getBranchLength() {
        if (!PhyloWidget.cfg.useBranchLengths) {
            return 1.0;
        }
        return super.getBranchLength();
    }

    public void setPosition(PhyloNode phyloNode) {
        if (phyloNode == null) {
            return;
        }
        this.setPosition(phyloNode.getLayoutX(), phyloNode.getLayoutY());
        this.fforward();
    }

    public void update() {
        if (PhyloWidget.cfg.useAnimations) {
            this.xTween.update();
            this.yTween.update();
        } else {
            this.xTween.fforward();
            this.yTween.fforward();
        }
        this.layoutX = this.xTween.getPosition() / 10000.0f;
        this.layoutY = this.yTween.getPosition() / 10000.0f;
    }

    public void setPosition(float f, float f2) {
        this.setLayoutX(f);
        this.setLayoutY(f2);
    }

    public void fforward() {
        this.xTween.fforward();
        this.yTween.fforward();
        this.update();
    }

    public void setLayoutX(float f) {
        this.xTween.continueTo(f * 10000.0f, PhyloWidget.cfg.animationFrames);
        this.layoutX = f;
    }

    public void setLayoutY(float f) {
        this.yTween.continueTo(f * 10000.0f, PhyloWidget.cfg.animationFrames);
        this.layoutY = f;
    }

    public float getLayoutX() {
        return (float)this.layoutX;
    }

    public float getLayoutY() {
        return (float)this.layoutY;
    }

    public float getTargetX() {
        return this.xTween.getFinish() / 10000.0f;
    }

    public float getTargetY() {
        return this.yTween.getFinish() / 10000.0f;
    }

    @Override
    public String toString() {
        return this.label;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String string) {
        this.label = string;
        if (this.searchResults != null) {
            this.searchResults.clear();
        }
    }

    public int compareTo(Object object) {
        if (object instanceof PhyloNode) {
            float f;
            PhyloNode phyloNode = (PhyloNode)object;
            float f2 = this.getTargetY();
            if (f2 < (f = phyloNode.getTargetY())) {
                return -1;
            }
            if (f2 > f) {
                return 1;
            }
        }
        return 0;
    }

    public void setState(int n) {
        this.state = n;
    }

    public int getState() {
        return this.state;
    }

    public float getX() {
        return this.realX;
    }

    public void setX(float f) {
        this.realX = f;
    }

    public float getY() {
        return this.realY;
    }

    public void setY(float f) {
        this.realY = f;
    }

    public boolean isNHX() {
        return this.annotations != null;
    }

    public void clearAnnotations() {
        if (this.annotations != null) {
            this.annotations.clear();
        }
    }

    public void clearAnnotation(String string) {
        if (this.annotations == null) {
            return;
        }
        this.annotations.remove(string);
    }

    public void setAnnotation(String string, String string2) {
        if (this.annotations == null) {
            this.annotations = new HashMap();
        }
        if (string2 == null) {
            this.annotations.remove(string);
        } else {
            this.annotations.put(string.toLowerCase(), string2);
        }
    }

    public String getAnnotation(String string) {
        if (PhyloWidget.cfg.ignoreAnnotations) {
            return null;
        }
        if (this.annotations == null) {
            return null;
        }
        return this.annotations.get(string.toLowerCase());
    }

    public HashMap<String, String> getAnnotations() {
        if (PhyloWidget.cfg.ignoreAnnotations) {
            return null;
        }
        return this.annotations;
    }

    public void setAngle(float f) {
        this.angle = f;
    }

    public float getAngle() {
        return this.angle;
    }

    public int getTextAlign() {
        return this.textAlign;
    }

    public void setTextAlign(int n) {
        this.textAlign = (byte)n;
    }

    public static boolean parseTruth(String string) {
        return string.startsWith("T") || string.startsWith("t") || string.startsWith("y") || string.startsWith("Y") || string.equals("1");
    }

    public synchronized PhyloTree getTree() {
        if (this.range != null) {
            if (this.range.render != null) {
                return (PhyloTree)this.range.render.getTree();
            }
            System.out.println("Render null!");
        }
        System.out.println("Range null!");
        return null;
    }
}

