/*
 * Decompiled with CFR 0.152.
 */
package org.phylowidget.tree;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.jgrapht.Graphs;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.phylowidget.tree.CachedVertex;
import org.phylowidget.tree.RootedTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedRootedTree<V extends CachedVertex, E extends DefaultWeightedEdge>
extends RootedTree<V, E> {
    private static final long serialVersionUID = 1L;
    protected boolean inSync;
    public Comparator enclSorter = new CachedEnclosedLeavesComparator(-1);
    boolean holdCalculations;

    public CachedRootedTree(Class<? extends E> clazz) {
        super(clazz);
    }

    @Override
    public V createVertex() {
        CachedVertex cachedVertex = new CachedVertex();
        return (V)cachedVertex;
    }

    private boolean inSync() {
        return this.inSync;
    }

    public void sync() {
        if (this.holdCalculations) {
            this.inSync = false;
            return;
        }
        if (this.inSync() || this.root == null) {
            return;
        }
        this.calculateStuff();
        this.inSync = true;
    }

    public void setHoldCalculations(boolean bl) {
        this.holdCalculations = bl;
    }

    private synchronized List<V> getChildrenOfNoSort(V v) {
        List<Object> list;
        if (this.useNeighborIndex) {
            list = new ArrayList();
            list.addAll(this.neighbors.successorsOf(v));
        } else {
            list = Graphs.successorListOf(this, v);
        }
        return list;
    }

    protected void calculateStuff() {
        int n;
        Cloneable cloneable;
        Cloneable cloneable2;
        if (this.holdCalculations) {
            return;
        }
        Stack<Cloneable> stack = new Stack<Cloneable>();
        stack.add(this.root);
        while (!stack.isEmpty()) {
            cloneable2 = (CachedVertex)stack.pop();
            if (this.getParentOf(cloneable2) == null) {
                ((CachedVertex)cloneable2).setDepthToRoot(0);
                ((CachedVertex)cloneable2).setHeightToRoot(0.0);
                ((CachedVertex)cloneable2).setParent(null);
            } else {
                cloneable = (CachedVertex)this.getParentOf(cloneable2);
                ((CachedVertex)cloneable2).setDepthToRoot(((CachedVertex)cloneable).getDepthToRoot() + 1);
                double d = this.getEdgeWeight(this.getEdge(cloneable, cloneable2));
                ((CachedVertex)cloneable2).setBranchLength(d);
                ((CachedVertex)cloneable2).setHeightToRoot(((CachedVertex)cloneable).getHeightToRoot() + d);
                ((CachedVertex)cloneable2).setParent(cloneable);
            }
            stack.addAll(this.getChildrenOfNoSort(cloneable2));
        }
        cloneable2 = new LinkedList();
        cloneable = new LinkedList();
        ((LinkedList)cloneable2).add(this.getRoot());
        while (!((AbstractCollection)((Object)cloneable2)).isEmpty()) {
            CachedVertex cachedVertex = (CachedVertex)((LinkedList)cloneable2).removeFirst();
            ((LinkedList)cloneable).addLast(cachedVertex);
            List<CachedVertex> list = this.getChildrenOfNoSort(cachedVertex);
            for (n = 0; n < list.size(); ++n) {
                ((LinkedList)cloneable2).addLast(list.get(n));
            }
        }
        while (!((AbstractCollection)((Object)cloneable)).isEmpty()) {
            CachedVertex cachedVertex = (CachedVertex)((LinkedList)cloneable).removeLast();
            if (super.isLeaf(cachedVertex)) {
                cachedVertex.setNumEnclosed(0);
                cachedVertex.setNumLeaves(1);
                cachedVertex.setMaxDepthToLeaf(0);
                cachedVertex.setMaxHeightToLeaf(0.0);
                continue;
            }
            int n2 = 0;
            n = 0;
            int n3 = 0;
            int n4 = Integer.MAX_VALUE;
            int n5 = 0;
            double d = 0.0;
            List<CachedVertex> list = this.getChildrenOfNoSort(cachedVertex);
            this.sortChildrenList(cachedVertex, list, this.enclSorter);
            for (int i = 0; i < list.size(); ++i) {
                CachedVertex cachedVertex2 = list.get(i);
                if (cachedVertex2.getNumEnclosed() >= n5) {
                    n5 = cachedVertex2.getNumEnclosed();
                }
                if (cachedVertex2.getNumEnclosed() <= n4) {
                    n4 = cachedVertex2.getNumEnclosed();
                }
                n2 += cachedVertex2.getNumEnclosed() + 1;
                n += cachedVertex2.getNumLeaves();
                double d2 = this.getEdgeWeight(this.getEdge(cachedVertex, cachedVertex2));
                if (cachedVertex2.getMaxHeightToLeaf() + d2 > d) {
                    d = d2 + cachedVertex2.getMaxHeightToLeaf();
                }
                if (cachedVertex2.getMaxDepthToLeaf() + 1 <= n3) continue;
                n3 = cachedVertex2.getMaxDepthToLeaf() + 1;
            }
            cachedVertex.setMaxChildEnclosed(n5);
            cachedVertex.setNumEnclosed(n2);
            cachedVertex.setNumLeaves(n);
            cachedVertex.setMaxDepthToLeaf(n3);
            cachedVertex.setMaxHeightToLeaf(d);
            cachedVertex.setFirstChild(list.get(0));
            cachedVertex.setLastChild(list.get(list.size() - 1));
        }
    }

    @Override
    public int getMaxChildEnclosed(V v) {
        V v2 = v;
        return ((CachedVertex)v2).getMaxChildEnclosed();
    }

    @Override
    public V getFirstChild(V v) {
        this.sync();
        V v2 = v;
        return (V)((CachedVertex)v2).getFirstChild();
    }

    @Override
    public V getLastChild(V v) {
        this.sync();
        V v2 = v;
        return (V)((CachedVertex)((CachedVertex)v2).getLastChild());
    }

    @Override
    public int getDepthToRoot(V v) {
        this.sync();
        if (this.inSync()) {
            V v2 = v;
            return ((CachedVertex)v2).getDepthToRoot();
        }
        return super.getDepthToRoot(v);
    }

    @Override
    public double getHeightToRoot(V v) {
        this.sync();
        if (this.inSync()) {
            V v2 = v;
            return ((CachedVertex)v2).getHeightToRoot();
        }
        return super.getHeightToRoot(v);
    }

    @Override
    public int getMaxDepthToLeaf(V v) {
        this.sync();
        if (this.inSync()) {
            V v2 = v;
            return ((CachedVertex)v2).getMaxDepthToLeaf();
        }
        return super.getMaxDepthToLeaf(v);
    }

    @Override
    public double getMaxHeightToLeaf(V v) {
        this.sync();
        if (this.inSync()) {
            V v2 = v;
            return ((CachedVertex)v2).getMaxHeightToLeaf();
        }
        return super.getMaxHeightToLeaf(v);
    }

    @Override
    public synchronized int getNumEnclosedLeaves(V v) {
        this.sync();
        if (this.inSync()) {
            V v2 = v;
            return ((CachedVertex)v2).getNumLeaves();
        }
        return super.getNumEnclosedLeaves(v);
    }

    @Override
    public synchronized boolean isLeaf(V v) {
        return super.isLeaf(v);
    }

    @Override
    protected void fireEdgeAdded(E e) {
        this.modPlus();
        super.fireEdgeAdded(e);
    }

    @Override
    protected void fireEdgeRemoved(E e) {
        this.modPlus();
        super.fireEdgeRemoved(e);
    }

    @Override
    protected void fireVertexAdded(V v) {
        this.modPlus();
        super.fireVertexAdded(v);
    }

    @Override
    protected void fireVertexRemoved(V v) {
        this.modPlus();
        super.fireVertexRemoved(v);
    }

    @Override
    public void setBranchLength(V v, double d) {
        this.modPlus();
        super.setBranchLength(v, d);
    }

    @Override
    public void modPlus() {
        super.modPlus();
        this.inSync = false;
    }

    @Override
    public void alignLeaves() {
        super.alignLeaves();
    }

    @Override
    public void setBranchLengths(Map<V, Double> map) {
        this.setHoldCalculations(true);
        super.setBranchLengths(map);
        this.setHoldCalculations(false);
    }

    class CachedEnclosedLeavesComparator
    implements Comparator {
        int dir;

        public CachedEnclosedLeavesComparator(int n) {
            this.dir = n;
        }

        public int compare(Object object, Object object2) {
            CachedVertex cachedVertex = (CachedVertex)object;
            CachedVertex cachedVertex2 = (CachedVertex)object2;
            int n = cachedVertex.getNumEnclosed();
            int n2 = cachedVertex2.getNumEnclosed();
            if (this.dir == 1) {
                if (n > n2) {
                    return 1;
                }
                if (n < n2) {
                    return -1;
                }
                return 0;
            }
            if (n > n2) {
                return -1;
            }
            if (n < n2) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object object, Object object2) {
            return this.compare(object, object) == 0;
        }
    }
}

