/*
 * Decompiled with CFR 0.152.
 */
package org.phylowidget.render.images;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.phylowidget.UsefulConstants;
import org.phylowidget.render.images.RegexUtils;
import org.phylowidget.tree.PhyloNode;

public class ImageSearcher
implements UsefulConstants {
    PhyloNode node;
    int pos;
    Vector<SingleResult> results;

    public ImageSearcher(PhyloNode phyloNode) {
        this.node = phyloNode;
        this.results = new Vector();
        this.pos = 0;
        this.fetchResults(0);
    }

    public void loadThumbnailURL() {
        String string = this.node.getAnnotation("IMG");
        if (string != null && string.equals(this.getThumbnailURL())) {
            return;
        }
        this.node.setAnnotation("OLD_IMG", this.node.getAnnotation("IMG"));
        this.node.setAnnotation("IMG", this.getThumbnailURL());
    }

    public String getThumbnailURL() {
        if (this.pos >= this.results.size()) {
            return null;
        }
        SingleResult singleResult = this.results.get(this.pos);
        return singleResult.thumbURL;
    }

    public void loadFullImageURL() {
        String string = this.node.getAnnotation("IMG");
        if (string != null && string.equals(this.getFullImageURL())) {
            return;
        }
        if (string.contains("google.com")) {
            this.node.setAnnotation("OLD_IMG", this.node.getAnnotation("IMG"));
            this.node.setAnnotation("IMG", this.getFullImageURL());
        }
    }

    public String getFullImageURL() {
        if (this.pos >= this.results.size()) {
            return null;
        }
        SingleResult singleResult = this.results.get(this.pos);
        return singleResult.imgURL;
    }

    public void skipTo(int n) {
        this.pos = n;
        if (this.pos > this.results.size()) {
            this.fetchResults(this.pos);
        }
    }

    public synchronized void next() {
        ++this.pos;
        if (this.pos > this.results.size()) {
            this.fetchResults(this.pos);
        }
    }

    synchronized void fetchResults(int n) {
        ArrayList[] arrayListArray = Google.imageSearch(this.node.getLabel(), n);
        ArrayList arrayList = arrayListArray[0];
        ArrayList arrayList2 = arrayListArray[1];
        for (int i = 0; i < arrayList.size(); ++i) {
            SingleResult singleResult = new SingleResult();
            singleResult.thumbURL = (String)arrayList.get(i);
            singleResult.imgURL = (String)arrayList2.get(i);
            this.results.add(singleResult);
        }
    }

    public void clear() {
        this.pos = 0;
        this.results.clear();
    }

    static class Google {
        static Pattern imgres = Pattern.compile("/imgres?");
        static Pattern imgBlock = RegexUtils.grabUntilClosingElement("a", imgres);
        static Pattern imgurl = Pattern.compile("imgurl=(.*?)&");
        static Pattern imgsrc = Pattern.compile("img src=(\\S*?) ");

        Google() {
        }

        public static ArrayList[] imageSearch(String string, int n) {
            Object object;
            CharSequence charSequence;
            Object object2;
            Object object3;
            Serializable serializable;
            try {
                string = URLEncoder.encode(string, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            String string2 = new String();
            string2 = string2 + "http://images.google.com/images?gbv=1&start=" + n + "&q=" + string;
            String string3 = "";
            try {
                int n2;
                serializable = new URL(string2);
                object3 = (HttpURLConnection)((URL)serializable).openConnection();
                ((HttpURLConnection)object3).setInstanceFollowRedirects(true);
                ((URLConnection)object3).setRequestProperty("User-Agent", "");
                ((URLConnection)object3).connect();
                object2 = new BufferedReader(new InputStreamReader(((URLConnection)object3).getInputStream()));
                charSequence = new StringBuffer();
                object = new char[1024];
                while ((n2 = ((Reader)object2).read((char[])object)) != -1) {
                    ((StringBuffer)charSequence).append((char[])object, 0, n2);
                }
                ((BufferedReader)object2).close();
                string3 = ((StringBuffer)charSequence).toString();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            serializable = new ArrayList();
            object3 = new ArrayList();
            object2 = imgBlock.matcher(string3);
            while (((Matcher)object2).find()) {
                charSequence = ((Matcher)object2).group();
                object = imgurl.matcher(charSequence);
                ((Matcher)object).find();
                String string4 = ((Matcher)object).group(1);
                Matcher matcher = imgsrc.matcher(charSequence);
                matcher.find();
                String string5 = matcher.group(1);
                ((ArrayList)serializable).add(string5);
                ((ArrayList)object3).add(string4);
            }
            return new ArrayList[]{serializable, object3};
        }
    }

    public class SingleResult {
        public String thumbURL;
        public String imgURL;
    }
}

