/*
 * Decompiled with CFR 0.152.
 */
package org.phylowidget.render.images;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Hashtable;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.imageio.ImageIO;
import org.andrewberman.ui.UIGlobals;
import org.phylowidget.PhyloWidget;
import org.phylowidget.tree.PhyloNode;
import processing.core.PApplet;

public class ImageLoader
implements Runnable {
    static Hashtable<String, Image> imageMap;
    static Hashtable<String, Integer> loadedImageURLs;
    static Thread thread;
    boolean loadingImg = false;
    PhyloNode loadingNode = null;
    static final Integer integer;
    Queue<String> imagesToLoad = new LinkedBlockingQueue<String>();

    public synchronized Image getImageForNode(PhyloNode phyloNode) {
        String string;
        if (thread == null) {
            loadedImageURLs = new Hashtable();
            imageMap = new Hashtable();
            thread = new Thread(this);
            thread.start();
        }
        if ((string = phyloNode.getAnnotation("IMG")) != null) {
            this.addImage(string);
            Image image = imageMap.get(string);
            if (image != null) {
                String string2 = phyloNode.getAnnotation("OLD_IMG");
                if (string2 != null) {
                    this.removeImage(string2);
                    phyloNode.clearAnnotation("OLD_IMG");
                }
                return image;
            }
            PhyloWidget.setMessage("Loading image...");
            String string3 = phyloNode.getAnnotation("OLD_IMG");
            if (string3 != null) {
                image = imageMap.get(string3);
                return image;
            }
            return null;
        }
        return null;
    }

    synchronized void removeImage(String string) {
        Image image = imageMap.get(string);
        if (image != null) {
            image.flush();
            image = null;
        }
        imageMap.remove(string);
        loadedImageURLs.remove(string);
    }

    synchronized void addImage(String string) {
        if (!loadedImageURLs.containsKey(string)) {
            loadedImageURLs.put(string, integer);
            this.imagesToLoad.add(string);
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            Object object;
            if (!this.imagesToLoad.isEmpty()) {
                object = null;
                try {
                    object = this.imagesToLoad.remove();
                    PApplet pApplet = UIGlobals.g.getP();
                    BufferedImage bufferedImage = ImageIO.read(new URL((String)object));
                    PhyloWidget.setMessage("Finished loading image!");
                    imageMap.put((String)object, bufferedImage);
                }
                catch (Exception exception) {
                    loadedImageURLs.remove(object);
                }
            }
            if (!this.imagesToLoad.isEmpty()) continue;
            object = this;
            synchronized (object) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
    }

    public void dispose() {
        if (imageMap != null) {
            imageMap.clear();
        }
        if (this.imagesToLoad != null) {
            this.imagesToLoad.clear();
        }
        if (loadedImageURLs != null) {
            loadedImageURLs.clear();
        }
        thread = null;
    }

    static {
        integer = new Integer(0);
    }
}

