/*
 * Decompiled with CFR 0.152.
 */
package org.phylowidget.render;

import com.lowagie.text.Document;
import java.awt.FileDialog;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import org.andrewberman.ui.UIRectangle;
import org.andrewberman.ui.UIUtils;
import org.phylowidget.PhyloTree;
import org.phylowidget.PhyloWidget;
import org.phylowidget.TreeManager;
import org.phylowidget.render.TreeRenderer;
import org.phylowidget.tree.PhyloNode;
import org.phylowidget.tree.RootedTree;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PGraphicsJava2D;

public class RenderOutput {
    public static boolean isOutputting = false;
    public static Document doc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void savePDF(PApplet pApplet, TreeRenderer treeRenderer, boolean bl, boolean bl2) {
        isOutputting = true;
        RootedTree rootedTree = treeRenderer.getTree();
        float f = PhyloWidget.cfg.renderThreshold;
        PhyloWidget.cfg.renderThreshold = 2.1474836E9f;
        boolean bl3 = PhyloWidget.cfg.useDoubleBuffering;
        PhyloWidget.cfg.useDoubleBuffering = false;
        float f2 = PhyloWidget.cfg.minTextSize;
        if (bl2) {
            PhyloWidget.cfg.minTextSize = 0.0f;
        }
        try {
            UIRectangle uIRectangle;
            PhyloWidget.setMessage("Outputting PDF...");
            RenderOutput.preprocess(rootedTree);
            String string = "PDF";
            FileDialog fileDialog = new FileDialog(PhyloWidget.ui.getFrame(), "Choose your desination " + string + " file.", 1);
            fileDialog.pack();
            fileDialog.setVisible(true);
            String string2 = fileDialog.getDirectory();
            String string3 = fileDialog.getFile();
            if (string3 == null) {
                PhyloWidget.setMessage("Output cancelled.");
                return;
            }
            if (!string3.toLowerCase().endsWith(".pdf")) {
                string3 = string3 + ".pdf";
            }
            File file = new File(string2, string3);
            pApplet.noLoop();
            PGraphics pGraphics = pApplet.createGraphics(pApplet.width, pApplet.height, "processing.pdf.PGraphicsPDF");
            pGraphics.setPath(file.getAbsolutePath());
            pGraphics.setSize(pApplet.width, pApplet.height);
            pGraphics.beginDraw();
            if (PhyloWidget.cfg.debug) {
                System.out.println("BEGIN DRAW");
            }
            UIRectangle uIRectangle2 = uIRectangle = TreeManager.cameraRect;
            if (bl) {
                TreeManager.camera.fillScreen(0.5f);
                TreeManager.camera.fforward();
                PhyloWidget.trees.update();
                uIRectangle = TreeManager.cameraRect;
            }
            treeRenderer.render(pGraphics, uIRectangle.x, uIRectangle.y, uIRectangle.width, uIRectangle.height, true);
            if (PhyloWidget.cfg.debug) {
                System.out.println("END DRAW");
            }
            pGraphics.endDraw();
            pGraphics.dispose();
            PhyloWidget.setMessage("Output complete.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            PhyloWidget.setMessage("PDF output failed: " + exception.getMessage());
        }
        finally {
            PhyloWidget.cfg.renderThreshold = f;
            PhyloWidget.cfg.minTextSize = f2;
            PhyloWidget.cfg.useDoubleBuffering = bl3;
            isOutputting = false;
            pApplet.loop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void save(PApplet pApplet, TreeRenderer treeRenderer, boolean bl, boolean bl2, String string, int n, int n2) {
        isOutputting = true;
        float f = PhyloWidget.cfg.renderThreshold;
        PhyloWidget.cfg.renderThreshold = 2.1474836E9f;
        boolean bl3 = PhyloWidget.cfg.useDoubleBuffering;
        PhyloWidget.cfg.useDoubleBuffering = false;
        float f2 = PhyloWidget.cfg.minTextSize;
        if (bl2) {
            PhyloWidget.cfg.minTextSize = 0.0f;
        }
        try {
            PhyloWidget.setMessage("Outputting image...");
            RootedTree rootedTree = treeRenderer.getTree();
            RenderOutput.preprocess(rootedTree);
            FileDialog fileDialog = new FileDialog(PhyloWidget.ui.getFrame(), "Choose your desination " + string + " file.", 1);
            fileDialog.pack();
            fileDialog.setVisible(true);
            String string2 = fileDialog.getDirectory();
            String string3 = fileDialog.getFile();
            if (string3 == null) {
                PhyloWidget.setMessage("Output cancelled.");
                return;
            }
            if (!string3.toLowerCase().endsWith(string.toLowerCase())) {
                string3 = string3 + "." + string.toLowerCase();
            }
            File file = new File(string2, string3);
            pApplet.noLoop();
            PGraphicsJava2D pGraphicsJava2D = (PGraphicsJava2D)pApplet.g;
            Image image = pGraphicsJava2D.image;
            Graphics2D graphics2D = pGraphicsJava2D.g2;
            int n3 = pGraphicsJava2D.width;
            int n4 = pGraphicsJava2D.height;
            pGraphicsJava2D.width = n;
            pGraphicsJava2D.height = n2;
            BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
            Graphics2D graphics2D2 = bufferedImage.createGraphics();
            UIUtils.setRenderingHints(graphics2D2);
            pGraphicsJava2D.image = bufferedImage;
            pGraphicsJava2D.g2 = graphics2D2;
            pGraphicsJava2D.beginDraw();
            RenderOutput.prettyHints(pGraphicsJava2D);
            pGraphicsJava2D.background(255);
            UIRectangle uIRectangle = TreeManager.cameraRect;
            float f3 = n / n3;
            float f4 = n2 / n4;
            if (bl) {
                uIRectangle.setRect(0.0f, 0.0f, n3, n4);
            }
            treeRenderer.render((PGraphics)pGraphicsJava2D, uIRectangle.x * f3, uIRectangle.y * f4, uIRectangle.width * f3, uIRectangle.height * f4, true);
            pGraphicsJava2D.endDraw();
            pGraphicsJava2D.loadPixels();
            pGraphicsJava2D.save(file.getAbsolutePath());
            graphics2D2.dispose();
            pGraphicsJava2D.image = image;
            pGraphicsJava2D.g2 = graphics2D;
            pGraphicsJava2D.width = n3;
            pGraphicsJava2D.height = n4;
            PhyloWidget.setMessage("Output complete.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            PhyloWidget.setMessage("Output failed: " + exception.getMessage());
            System.gc();
            return;
        }
        finally {
            PhyloWidget.cfg.renderThreshold = f;
            PhyloWidget.cfg.minTextSize = f2;
            PhyloWidget.cfg.useDoubleBuffering = bl3;
            isOutputting = false;
            pApplet.loop();
        }
    }

    private static void prettyHints(PGraphicsJava2D pGraphicsJava2D) {
        Graphics2D graphics2D = pGraphicsJava2D.g2;
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
    }

    private static void preprocess(RootedTree rootedTree) {
        ArrayList arrayList = new ArrayList();
        rootedTree.getAll(rootedTree.getRoot(), null, arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            PhyloNode phyloNode = (PhyloNode)arrayList.get(i);
            phyloNode.setState(0);
        }
        PhyloTree phyloTree = (PhyloTree)PhyloWidget.trees.getTree();
        phyloTree.hoveredNode = null;
    }
}

