/*
 * Decompiled with CFR 0.152.
 */
package org.phylowidget.render;

import java.util.ArrayList;
import java.util.Collections;

public class OverlapDetector {
    private ArrayList<Range> ranges = new ArrayList();

    public void clear() {
        this.ranges.clear();
    }

    public void insert(double d, double d2) {
        this.insert(new Range(d, d2));
    }

    public boolean overlaps(double d, double d2) {
        return this.overlaps(new Range(d, d2));
    }

    public boolean overlaps(Range range) {
        for (int i = 0; i < this.ranges.size(); ++i) {
            Range range2 = this.ranges.get(i);
            if (!range.intersects(range2)) continue;
            return true;
        }
        return false;
    }

    public void insert(Range range) {
        boolean bl = false;
        for (int i = 0; i < this.ranges.size(); ++i) {
            Range range2 = this.ranges.get(i);
            if (range.intersects(range2)) {
                bl = true;
                range.absorbRange(range2);
                this.ranges.remove(i);
                --i;
                continue;
            }
            if (bl) break;
        }
        this.ranges.add(range);
        Collections.sort(this.ranges);
    }

    public String toString() {
        return this.ranges.toString();
    }

    public static void main(String[] stringArray) {
        OverlapDetector overlapDetector = new OverlapDetector();
        overlapDetector.insert(50.0, 70.0);
        overlapDetector.insert(40.0, 60.0);
        overlapDetector.insert(50.0, 55.0);
        OverlapDetector overlapDetector2 = overlapDetector;
        overlapDetector2.getClass();
        System.out.println(overlapDetector.overlaps(overlapDetector2.new Range(20.0, 40.0)));
        System.out.println(overlapDetector);
    }

    public class Range
    implements Comparable {
        double min;
        double max;

        public Range(double d, double d2) {
            this.min = d;
            this.max = d2;
        }

        void absorbRange(Range range) {
            this.setMin(Math.min(range.getMin(), this.getMin()));
            this.setMax(Math.max(range.getMax(), this.getMax()));
        }

        boolean intersects(Range range) {
            if (this.getMin() > range.getMax()) {
                return false;
            }
            if (this.getMax() < range.getMin()) {
                return false;
            }
            if (this.getMin() <= range.getMax() && this.getMin() >= range.getMin()) {
                return true;
            }
            if (this.getMax() >= range.getMin() && this.getMax() <= range.getMax()) {
                return true;
            }
            return this.getMin() <= range.getMin() && this.getMax() >= range.getMax();
        }

        boolean absorbIfIntersects(Range range) {
            if (this.intersects(range)) {
                this.absorbRange(range);
                return true;
            }
            return false;
        }

        public double getMin() {
            return this.min;
        }

        public void setMin(double d) {
            this.min = d;
        }

        public double getMax() {
            return this.max;
        }

        public void setMax(double d) {
            this.max = d;
        }

        public int compareTo(Object object) {
            Range range = this;
            Range range2 = (Range)object;
            if (range.getMin() < range2.getMin()) {
                return -1;
            }
            if (range.getMin() == range2.getMin()) {
                return 0;
            }
            return 1;
        }

        public String toString() {
            return "min:" + this.getMin() + " max:" + this.getMax() + "\n";
        }
    }
}

