/*
 * Decompiled with CFR 0.152.
 */
package org.phylowidget.render;

import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.andrewberman.ui.Color;
import org.andrewberman.ui.TextField;
import org.phylowidget.PhyloTree;
import org.phylowidget.PhyloWidget;
import org.phylowidget.TreeManager;
import org.phylowidget.UsefulConstants;
import org.phylowidget.render.BasicTreeRenderer;
import org.phylowidget.render.LayoutCladogram;
import org.phylowidget.render.RenderConstants;
import org.phylowidget.render.RenderOutput;
import org.phylowidget.tree.PhyloNode;
import org.phylowidget.tree.RootedTree;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PGraphicsJava2D;

public final class NodeRenderer
implements UsefulConstants {
    static Graphics2D g2;
    static FontMetrics fm;
    static BasicTreeRenderer r;
    static float[] ZEROES;
    static HashMap<String, Integer> taxonColorMap;
    static NodeRender nr;
    static LineRender lineRender;
    static CigarRender cr;
    static ImageRender ir;
    static LabelRender lr;
    static RenderItem[] renderables;
    static RenderItem[] structRenderables;
    private static Point2D.Float tempPoint;

    public static final void render(BasicTreeRenderer basicTreeRenderer, PhyloNode phyloNode) {
        NodeRenderer.renderImpl(basicTreeRenderer, phyloNode, true);
    }

    static final void renderImpl(BasicTreeRenderer basicTreeRenderer, PhyloNode phyloNode, boolean bl) {
        boolean bl2;
        PGraphics pGraphics = basicTreeRenderer.canvas;
        if (pGraphics == null) {
            return;
        }
        r = basicTreeRenderer;
        float f = phyloNode.getX();
        float f2 = phyloNode.getY();
        if (basicTreeRenderer.treeLayout instanceof LayoutCladogram && basicTreeRenderer.tree.isLeaf(phyloNode) && (PhyloWidget.cfg.alignLabels || phyloNode.getAnnotation("cigar") != null)) {
            PhyloNode phyloNode2 = (PhyloNode)basicTreeRenderer.tree.getFurthestLeafFromVertex(basicTreeRenderer.tree.getRoot());
            f = phyloNode2.getX();
        }
        pGraphics.pushMatrix();
        pGraphics.translate(f, f2);
        pGraphics.rotate(phyloNode.getAngle());
        float f3 = 1.0f;
        if (phyloNode.getTextAlign() == 1) {
            f3 = -1.0f;
        }
        phyloNode.rect.setFrame(phyloNode.getX(), phyloNode.getY(), 0.0, 0.0);
        float f4 = basicTreeRenderer.getTextSize();
        float f5 = basicTreeRenderer.getNodeOffset(phyloNode);
        if (PhyloWidget.cfg.treatNodesAsLabels) {
            boolean bl3 = bl && phyloNode.drawLabel || PhyloWidget.cfg.showAllLeafNodes;
            nr.render(pGraphics, phyloNode, bl3, true);
        }
        if (basicTreeRenderer.getTree().isCollapsed(phyloNode)) {
            pGraphics.translate(f4 * 0.3f, 0.0f);
        }
        pGraphics.translate(f5 * f3 + RenderConstants.labelSpacing * f3 * f4, 0.0f);
        float f6 = 0.0f;
        for (RenderItem renderItem : renderables) {
            bl2 = phyloNode.drawLabel && bl;
            float[] fArray = renderItem.render(pGraphics, phyloNode, bl2, true);
            f6 = fArray[0];
            pGraphics.translate(f6 + RenderConstants.labelSpacing * f3 * f4, 0.0f);
        }
        pGraphics.popMatrix();
        for (RenderItem renderItem : structRenderables) {
            boolean bl4 = bl2 = bl && phyloNode.drawLineAndNode;
            if (renderItem == nr) {
                if (PhyloWidget.cfg.treatNodesAsLabels) continue;
                bl2 = bl && phyloNode.drawLineAndNode || PhyloWidget.cfg.showAllLeafNodes;
            }
            renderItem.render(pGraphics, phyloNode, bl2, false);
        }
    }

    public static final void setCornerPoints(BasicTreeRenderer basicTreeRenderer, PhyloNode phyloNode) {
        NodeRenderer.renderImpl(basicTreeRenderer, phyloNode, false);
    }

    static void getColorsForSpeciesMap() {
        int n = taxonColorMap.size();
        Set<String> set = taxonColorMap.keySet();
        float f = 1.0f / ((float)n + 1.0f);
        float f2 = 0.0f;
        for (String string : set) {
            int n2 = Color.HSBtoRGB(f2 += f, 0.7f, 0.85f);
            taxonColorMap.put(string, n2);
        }
    }

    static float strokeForNode(PhyloNode phyloNode) {
        float f = NodeRenderer.r.baseStroke;
        if (phyloNode.found) {
            return f *= RenderConstants.foundStroke;
        }
        switch (phyloNode.getState()) {
            case 1: {
                f *= RenderConstants.dimStroke;
                break;
            }
            case 2: {
                f *= RenderConstants.copyStroke;
                break;
            }
            default: {
                f *= RenderConstants.regStroke;
            }
        }
        return f;
    }

    private static final void registerPoint(PGraphics pGraphics, PhyloNode phyloNode, float f, float f2) {
        if (phyloNode.getLabel().length() == 0) {
            return;
        }
        float f3 = pGraphics.screenX(f, f2);
        float f4 = pGraphics.screenY(f, f2);
        phyloNode.rect.add(f3, f4);
        phyloNode.range.loX = (float)phyloNode.rect.getMinX();
        phyloNode.range.hiX = (float)phyloNode.rect.getMaxX();
        phyloNode.range.loY = (float)phyloNode.rect.getMinY();
        phyloNode.range.hiY = (float)phyloNode.rect.getMaxY();
    }

    private static final float getFloatAnnotation(PhyloNode phyloNode, String string) {
        String string2 = phyloNode.getAnnotation(string);
        if (string2 == null) {
            return -1.0f;
        }
        return Float.parseFloat(string2);
    }

    static {
        ZEROES = new float[]{0.0f, 0.0f};
        taxonColorMap = new HashMap();
        nr = new NodeRender();
        lineRender = new LineRender();
        cr = new CigarRender();
        ir = new ImageRender();
        lr = new LabelRender();
        renderables = new RenderItem[]{ir, cr, lr};
        structRenderables = new RenderItem[]{lineRender, nr};
        tempPoint = new Point2D.Float();
    }

    static class AlignmentBlocks {
        int totalLength;
        List<Integer> blocks;

        AlignmentBlocks() {
        }
    }

    public static class CigarRender
    extends RenderItem {
        static Pattern p = Pattern.compile("(\\d*?)([MD])", 2);

        public float[] render(PGraphics pGraphics, PhyloNode phyloNode, boolean bl, boolean bl2) {
            super.render(pGraphics, phyloNode, bl, bl2);
            boolean bl3 = false;
            if (phyloNode.getTextAlign() == 1) {
                bl3 = true;
            }
            String string = null;
            string = phyloNode.getAnnotation("CIGAR");
            if (string == null) {
                return ZEROES;
            }
            AlignmentBlocks alignmentBlocks = this.parseCigarBreakpoints(string);
            List<Integer> list = alignmentBlocks.blocks;
            int n = alignmentBlocks.totalLength;
            float f = this.cigarSizeForNode(r, phyloNode);
            float f2 = PhyloWidget.cfg.cigarScaling * f;
            float f3 = f2 / (float)n;
            if (bl) {
                for (int i = 0; i < list.size() - 1; i += 2) {
                    int n2 = list.get(i);
                    int n3 = list.get(i + 1);
                    float f4 = (float)n2 * f3;
                    float f5 = (float)n3 * f3;
                    pGraphics.noStroke();
                    pGraphics.fill(CigarRender.alignmentColor(phyloNode));
                    pGraphics.rect(f4, -f / 2.0f, f5 - f4, f);
                }
            }
            return new float[]{f2, f};
        }

        private AlignmentBlocks parseCigarBreakpoints(String string) {
            Object object;
            Matcher matcher = p.matcher(string);
            int n = 0;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            while (matcher.find()) {
                String string2;
                object = matcher.group(1);
                int n2 = 1;
                if (((String)object).length() > 0) {
                    n2 = Integer.parseInt((String)object);
                }
                if ((string2 = matcher.group(2)).equals("M")) {
                    arrayList.add(n);
                }
                for (int i = 0; i < n2; ++i) {
                    ++n;
                }
                if (!string2.equals("M")) continue;
                arrayList.add(n);
            }
            object = new AlignmentBlocks();
            ((AlignmentBlocks)object).totalLength = n;
            ((AlignmentBlocks)object).blocks = arrayList;
            return object;
        }

        private float cigarSizeForNode(BasicTreeRenderer basicTreeRenderer, PhyloNode phyloNode) {
            float f;
            float f2 = basicTreeRenderer.getTextSize();
            if (!PhyloWidget.cfg.showAllLabels) {
                f2 = Math.max(f2, PhyloWidget.cfg.minTextSize);
            }
            if ((f = NodeRenderer.getFloatAnnotation(phyloNode, "ALNSZ")) > -1.0f) {
                f2 *= f;
            }
            return f2;
        }

        static int alignmentColor(PhyloNode phyloNode) {
            if (phyloNode.isNHX()) {
                String string = phyloNode.getAnnotation("ALNCOL");
                String string2 = phyloNode.getAnnotation("T");
                String string3 = phyloNode.getAnnotation("S");
                if (string != null) {
                    int n = Color.parseColor(string).getRGB();
                    return n;
                }
            }
            return PhyloWidget.cfg.getAlignmentColor().getRGB();
        }
    }

    static class LabelRender
    extends RenderItem {
        LabelRender() {
        }

        public float[] render(PGraphics pGraphics, PhyloNode phyloNode, boolean bl, boolean bl2) {
            RootedTree rootedTree;
            float f;
            super.render(pGraphics, phyloNode, bl, bl2);
            float f2 = this.textSizeForNode(r, phyloNode);
            boolean bl3 = false;
            if (phyloNode.getTextAlign() == 1) {
                bl3 = true;
            }
            if ((f = NodeRenderer.getFloatAnnotation(phyloNode, "LSZ")) > -1.0f) {
                f2 *= f;
            }
            if (r.getTree().isCollapsed(phyloNode)) {
                f2 *= 0.6f;
            }
            boolean bl4 = false;
            float f3 = NodeRenderer.getFloatAnnotation(phyloNode, "PW_ALWAYS");
            if (f3 > -1.0f) {
                bl4 = true;
            }
            if ((f3 = NodeRenderer.getFloatAnnotation(phyloNode, "PW_A")) > -1.0f) {
                bl4 = true;
            }
            if (f2 < 0.5f && !RenderOutput.isOutputting && !bl4) {
                return ZEROES;
            }
            if (PhyloWidget.cfg.textRotation != 0.0f) {
                pGraphics.rotate(PApplet.radians((float)PhyloWidget.cfg.textRotation));
            }
            if ((rootedTree = NodeRenderer.r.tree).isLeaf(phyloNode) && (phyloNode.found || bl4) && bl) {
                pGraphics.noStroke();
                pGraphics.fill(RenderConstants.foundBackground.getRGB());
                if (bl3) {
                    pGraphics.rect(-phyloNode.unitTextWidth * f2, -f2 / 2.0f, phyloNode.unitTextWidth * f2, f2);
                } else {
                    pGraphics.rect(0.0f, -f2 / 2.0f, phyloNode.unitTextWidth * f2, f2);
                }
            }
            float f4 = f2 * phyloNode.unitTextWidth;
            pGraphics.fill(LabelRender.textColor(phyloNode));
            f2 = Math.min(f2, 128.0f);
            pGraphics.textSize(f2);
            if (phyloNode.found) {
                pGraphics.fill(RenderConstants.foundForeground.getRGB());
            }
            if (!rootedTree.isLeaf(phyloNode)) {
                if (PhyloWidget.cfg.showCladeLabels) {
                    float f5 = NodeRenderer.strokeForNode(phyloNode);
                    pGraphics.fill(LabelRender.textColor(phyloNode));
                    f4 = (f2 *= 0.75f) * phyloNode.unitTextWidth;
                    NodeRenderer.registerPoint(pGraphics, phyloNode, this.offX, this.offY - f2 / 2.0f - f2 / 3.0f - f5);
                    NodeRenderer.registerPoint(pGraphics, phyloNode, this.offX - f4, this.offY + f2 / 2.0f - f2 / 3.0f - f5);
                    if (bl) {
                        pGraphics.textSize(f2);
                        pGraphics.textAlign(39, 0);
                        pGraphics.fill(LabelRender.textColor(phyloNode));
                        pGraphics.text(rootedTree.getLabel(phyloNode), this.offX - f2 / 3.0f - f5, this.offY - f5 - f2 / 3.0f);
                    }
                }
            } else {
                if (bl3) {
                    pGraphics.textAlign(39, 0);
                    NodeRenderer.registerPoint(pGraphics, phyloNode, 0.0f, -f2 / 2.0f);
                    NodeRenderer.registerPoint(pGraphics, phyloNode, -f4, f2 / 2.0f);
                } else {
                    pGraphics.textAlign(37, 0);
                    NodeRenderer.registerPoint(pGraphics, phyloNode, 0.0f, -f2 / 2.0f);
                    NodeRenderer.registerPoint(pGraphics, phyloNode, f4, f2 / 2.0f);
                }
                if (bl) {
                    pGraphics.text(rootedTree.getLabel(phyloNode), 0.0f, 0.0f + NodeRenderer.r.dFont * f2 / NodeRenderer.r.textSize);
                }
            }
            if (bl) {
                phyloNode.lastTextSize = f2;
            }
            return new float[]{f4, f2};
        }

        private float textSizeForNode(BasicTreeRenderer basicTreeRenderer, PhyloNode phyloNode) {
            String string = phyloNode.getAnnotation("PW_ALWAYS");
            if (string == null) {
                string = phyloNode.getAnnotation("PW_A");
            }
            boolean bl = false;
            if (string != null && string.equals("1")) {
                bl = true;
            }
            if (PhyloWidget.cfg.hideAllLabels && !bl) {
                return 0.0f;
            }
            float f = basicTreeRenderer.getTextSize() * PhyloWidget.cfg.textScaling * phyloNode.bulgeFactor;
            if (PhyloWidget.cfg.showAllLabels) {
                return basicTreeRenderer.getTextSize() * PhyloWidget.cfg.textScaling;
            }
            if (f < PhyloWidget.cfg.minTextSize) {
                f = PhyloWidget.cfg.minTextSize;
            }
            return f;
        }

        static int textColor(PhyloNode phyloNode) {
            if (r.getTree().isCollapsed(phyloNode)) {
                return PhyloWidget.cfg.getTextColor().brighter(128.0).getRGB();
            }
            if (phyloNode.isNHX()) {
                int n = Color.black.getRGB();
                String string = phyloNode.getAnnotation("LCOL");
                String string2 = phyloNode.getAnnotation("T");
                String string3 = phyloNode.getAnnotation("S");
                if (string != null) {
                    n = Color.parseColor(string).getRGB();
                } else if (string2 != null && PhyloWidget.cfg.colorSpecies) {
                    n = taxonColorMap.get(string2);
                } else if (string3 != null && PhyloWidget.cfg.colorSpecies) {
                    n = taxonColorMap.get(string3);
                }
                return n;
            }
            return PhyloWidget.cfg.getTextColor().getRGB();
        }

        public void positionText(BasicTreeRenderer basicTreeRenderer, PhyloNode phyloNode, TextField textField) {
            float f = 0.0f;
            float f2 = phyloNode.lastTextSize;
            float f3 = basicTreeRenderer.dFont * f2 / basicTreeRenderer.textSize;
            float f4 = phyloNode.unitTextWidth * f2;
            PGraphics pGraphics = null;
            if (pGraphics != null) {
                f += nr.render(pGraphics, phyloNode, false, true)[0];
                f += ir.render(pGraphics, phyloNode, false, true)[0];
            }
            float f5 = phyloNode.getX() + basicTreeRenderer.getNodeRadius() + basicTreeRenderer.getNormalLineWidth() * 2.0f;
            float f6 = phyloNode.getY();
            textField.setTextSize(f2);
            textField.setWidth(f4);
            textField.setPositionByBaseline(f5 + f, f6 + f3);
        }
    }

    static class ImageRender
    extends RenderItem {
        static boolean fitImagesToSquare = true;

        ImageRender() {
        }

        public float[] render(PGraphics pGraphics, PhyloNode phyloNode, boolean bl, boolean bl2) {
            super.render(pGraphics, phyloNode, bl, bl2);
            return this.renderImage(r, phyloNode, bl);
        }

        private float imageSizeForNode(BasicTreeRenderer basicTreeRenderer, PhyloNode phyloNode) {
            float f;
            float f2 = basicTreeRenderer.getTextSize() * PhyloWidget.cfg.imageSize * phyloNode.bulgeFactor;
            if (!PhyloWidget.cfg.showAllLabels) {
                f2 = Math.max(f2, PhyloWidget.cfg.minTextSize);
            }
            if ((f = NodeRenderer.getFloatAnnotation(phyloNode, "ISZ")) > -1.0f) {
                f2 *= f;
            }
            return f2;
        }

        float[] renderImage(BasicTreeRenderer basicTreeRenderer, PhyloNode phyloNode, boolean bl) {
            String string = phyloNode.getAnnotation("img");
            if (string == null) {
                return ZEROES;
            }
            boolean bl2 = false;
            if (phyloNode.getTextAlign() == 1) {
                bl2 = true;
            }
            float f = this.imageSizeForNode(basicTreeRenderer, phyloNode);
            float[] fArray = this.imageSize(phyloNode, f);
            float f2 = fArray[0];
            float f3 = fArray[1];
            if (bl) {
                Graphics2D graphics2D = ((PGraphicsJava2D)basicTreeRenderer.canvas).g2;
                PGraphics pGraphics = basicTreeRenderer.canvas;
                float f4 = (f - f2) / 2.0f;
                if (bl2) {
                    f4 -= f2;
                }
                Image image = null;
                if (RenderOutput.isOutputting && PhyloWidget.cfg.outputFullSizeImages) {
                    try {
                        image = ImageIO.read(new URL(phyloNode.getFullImageURL()));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        image = TreeManager.imageLoader.getImageForNode(phyloNode);
                    }
                } else {
                    float f5 = Math.min(f3, f2);
                    if (f5 > 300.0f) {
                        System.out.println("Loading full image...");
                        phyloNode.loadFullImage();
                    }
                    image = TreeManager.imageLoader.getImageForNode(phyloNode);
                }
                if (image != null) {
                    if (RenderOutput.isOutputting) {
                        System.out.println("DRAW IMAGE " + phyloNode.getLabel());
                    }
                    graphics2D.drawImage(image, (int)f4, (int)(-f3) / 2, (int)f2, (int)f3, null);
                }
                if (RenderOutput.isOutputting && image != null) {
                    image.flush();
                    image = null;
                }
            }
            if (fitImagesToSquare) {
                return new float[]{f, f};
            }
            return new float[]{f2, f};
        }

        public float[] imageSize(PhyloNode phyloNode, float f) {
            Image image = TreeManager.imageLoader.getImageForNode(phyloNode);
            if (image == null) {
                return new float[]{0.0f, 0.0f};
            }
            float f2 = 1.0f;
            float f3 = image.getWidth(null);
            float f4 = image.getHeight(null);
            f2 = fitImagesToSquare ? (f3 > f4 ? f / f3 : f / f4) : f / f4;
            float f5 = f3 * f2;
            float f6 = f4 * f2;
            return new float[]{f5, f6};
        }
    }

    public static class LineRender
    extends RenderItem {
        public float[] render(PGraphics pGraphics, PhyloNode phyloNode, boolean bl, boolean bl2) {
            super.render(pGraphics, phyloNode, bl, bl2);
            if (!bl) {
                return ZEROES;
            }
            PhyloNode phyloNode2 = (PhyloNode)phyloNode.getParent();
            if (phyloNode2 != null) {
                this.drawLine(r, phyloNode2, phyloNode);
            }
            return ZEROES;
        }

        protected void drawLine(BasicTreeRenderer basicTreeRenderer, PhyloNode phyloNode, PhyloNode phyloNode2) {
            double d;
            if (phyloNode == null) {
                return;
            }
            float f = LineRender.nodeStroke(basicTreeRenderer, phyloNode2);
            if (f == 0.0f) {
                return;
            }
            if (!RenderOutput.isOutputting) {
                f = Math.max(0.5f, f);
            }
            basicTreeRenderer.canvas.strokeWeight(f);
            basicTreeRenderer.canvas.stroke(LineRender.lineColor(phyloNode2));
            PhyloTree phyloTree = (PhyloTree)basicTreeRenderer.getTree();
            if (phyloNode2 == phyloTree.hoveredNode && PhyloWidget.cfg.colorHoveredBranch) {
                basicTreeRenderer.canvas.stroke(RenderConstants.hoverColor.getRGB());
                basicTreeRenderer.canvas.strokeWeight(f * RenderConstants.hoverStroke);
            }
            if (phyloNode2.isNHX() && PhyloWidget.cfg.colorBootstrap && !phyloNode2.found && (d = (double)NodeRenderer.getFloatAnnotation(phyloNode2, "B")) > -1.0) {
                d = (100.0 - d) * 200.0 / 100.0;
                d = basicTreeRenderer.clamp(d, 0.0, 255.0);
                basicTreeRenderer.canvas.stroke(PhyloWidget.cfg.getBranchColor().brighter(d).getRGB());
            }
            basicTreeRenderer.getTreeLayout().drawLine(basicTreeRenderer.canvas, phyloNode, phyloNode2);
        }

        static float nodeStroke(BasicTreeRenderer basicTreeRenderer, PhyloNode phyloNode) {
            float f = NodeRenderer.strokeForNode(phyloNode);
            float f2 = NodeRenderer.getFloatAnnotation(phyloNode, "BSZ");
            if (f2 > -1.0f) {
                f *= f2;
            }
            return f;
        }

        static int lineColor(PhyloNode phyloNode) {
            if (phyloNode.found) {
                return RenderConstants.foundColor.getRGB();
            }
            switch (phyloNode.getState()) {
                case 1: {
                    return RenderConstants.dimColor.getRGB();
                }
                case 2: {
                    return RenderConstants.copyColor.getRGB();
                }
            }
            int n = PhyloWidget.cfg.getBranchColor().getRGB();
            String string = phyloNode.getAnnotation("BCOL");
            if (string != null) {
                n = Color.parseColor(string).getRGB();
            }
            return n;
        }
    }

    public static class NodeRender
    extends RenderItem {
        static final int CIRCLE = 0;
        static final int SQUARE = 1;
        static final int TRIANGLE = 2;
        static final int STAR = 3;
        static final int FILLED_CIRCLE = 4;

        public float[] render(PGraphics pGraphics, PhyloNode phyloNode, boolean bl, boolean bl2) {
            super.render(pGraphics, phyloNode, bl, bl2);
            return this.drawNodeMarkerImpl(pGraphics, phyloNode, bl);
        }

        private float nodeSizeForNode(PhyloNode phyloNode) {
            float f;
            float f2 = NodeRenderer.r.dotWidth;
            if (!NodeRenderer.r.tree.isLeaf(phyloNode)) {
                f2 *= PhyloWidget.cfg.innerNodeRatio;
            }
            if ((f = NodeRenderer.getFloatAnnotation(phyloNode, "NSZ")) > -1.0f) {
                f2 *= f;
            }
            return f2;
        }

        protected float[] drawNodeMarkerImpl(PGraphics pGraphics, PhyloNode phyloNode, boolean bl) {
            String string;
            float f = this.nodeSizeForNode(phyloNode);
            if (pGraphics == null) {
                return new float[]{f / 2.0f, f / 2.0f};
            }
            pGraphics.fill(NodeRender.nodeColor(phyloNode));
            pGraphics.noStroke();
            RootedTree rootedTree = NodeRenderer.r.tree;
            if (f == 0.0f) {
                return ZEROES;
            }
            if (phyloNode.isNHX() && PhyloWidget.cfg.colorDuplications && !rootedTree.isLeaf(phyloNode) && (string = phyloNode.getAnnotation("D")) != null) {
                if (PhyloNode.parseTruth(string)) {
                    pGraphics.fill(RenderConstants.copyColor.getRGB());
                } else {
                    pGraphics.fill(new Color(0, 0, 255).getRGB());
                }
            }
            if (PhyloWidget.cfg.treatNodesAsLabels) {
                NodeRenderer.registerPoint(pGraphics, phyloNode, this.offX - f / 2.0f, this.offY - f / 2.0f);
                NodeRenderer.registerPoint(pGraphics, phyloNode, this.offX + f / 2.0f, this.offY + f / 2.0f);
            }
            if (!bl) {
                return new float[]{f / 2.0f, f / 2.0f};
            }
            int n = NodeRender.getNodeShape(phyloNode);
            if (n == 2) {
                pGraphics.beginShape();
                float f2 = f * 0.75f;
                pGraphics.vertex(this.offX + 0.866f * f2, this.offY + 0.5f * f2);
                pGraphics.vertex(this.offX - 0.866f * f2, this.offY + 0.5f * f2);
                pGraphics.vertex(this.offX, this.offY - 1.0f * f2);
                pGraphics.endShape();
            } else if (n == 1) {
                pGraphics.rect(this.offX - f / 2.0f, this.offY - f / 2.0f, f, f);
            } else if (n == 3) {
                pGraphics.pushMatrix();
                pGraphics.translate(this.offX, this.offY);
                pGraphics.beginShape();
                float f3 = f;
                float f4 = f * 0.4f;
                for (int i = 0; i < 10; ++i) {
                    double d = Math.PI * 2 * (double)((float)i / 10.0f) - 1.5707963267948966;
                    if (i % 2 == 0) {
                        pGraphics.vertex((float)((double)f3 * Math.cos(d)), (float)((double)f3 * Math.sin(d)));
                        continue;
                    }
                    pGraphics.vertex((float)((double)f4 * Math.cos(d)), (float)((double)f4 * Math.sin(d)));
                }
                pGraphics.endShape();
                pGraphics.popMatrix();
            } else if (n == 4) {
                pGraphics.ellipseMode(3);
                pGraphics.ellipse(this.offX, this.offY, f, f);
                pGraphics.ellipseMode(3);
                pGraphics.strokeWeight(f / 10.0f);
                pGraphics.stroke(Color.black.getRGB());
                pGraphics.noFill();
                pGraphics.ellipse(this.offX, this.offY, f, f);
            } else {
                pGraphics.ellipseMode(3);
                pGraphics.ellipse(this.offX, this.offY, f, f);
            }
            return new float[]{f / 2.0f, f / 2.0f};
        }

        static int getNodeShape(PhyloNode phyloNode) {
            String string = phyloNode.getAnnotation("NSH");
            String string2 = PhyloWidget.cfg.nodeShape.toLowerCase();
            if (string != null) {
                string2 = string.toLowerCase();
            }
            if (string2.startsWith("t")) {
                return 2;
            }
            if (string2.startsWith("s")) {
                return 1;
            }
            if (string2.startsWith("x")) {
                return 3;
            }
            if (string2.startsWith("o")) {
                return 4;
            }
            return 0;
        }

        static int nodeColor(PhyloNode phyloNode) {
            if (phyloNode.found) {
                return RenderConstants.foundColor.getRGB();
            }
            if (phyloNode == ((PhyloTree)NodeRenderer.r.tree).hoveredNode && PhyloWidget.cfg.colorHoveredBranch) {
                return RenderConstants.hoverColor.getRGB();
            }
            switch (phyloNode.getState()) {
                case 1: {
                    return RenderConstants.dimColor.getRGB();
                }
                case 2: {
                    return RenderConstants.copyColor.getRGB();
                }
            }
            int n = PhyloWidget.cfg.getNodeColor().getRGB();
            String string = phyloNode.getAnnotation("NCOL");
            if (string != null) {
                n = Color.parseColor(string).getRGB();
            }
            return n;
        }
    }

    public static abstract class RenderItem {
        protected float offX;
        protected float offY;

        public float[] render(PGraphics pGraphics, PhyloNode phyloNode, boolean bl, boolean bl2) {
            if (bl2) {
                this.offX = 0.0f;
                this.offY = 0.0f;
            } else {
                this.offX = phyloNode.getX();
                this.offY = phyloNode.getY();
            }
            return null;
        }
    }
}

