/*
 * Decompiled with CFR 0.152.
 */
package org.phylowidget.render;

import java.util.Collections;
import java.util.List;
import org.phylowidget.render.LayoutBase;
import org.phylowidget.tree.PhyloNode;
import processing.core.PGraphics;

public class LayoutDiagonal
extends LayoutBase {
    int numLeaves;

    public void layoutImpl() {
        this.numLeaves = this.leaves.length;
        int n = 0;
        for (PhyloNode phyloNode : this.leaves) {
            this.leafPosition(phyloNode, n);
            ++n;
        }
        this.branchPosition((PhyloNode)this.tree.getRoot());
    }

    public void drawLine(PGraphics pGraphics, PhyloNode phyloNode, PhyloNode phyloNode2) {
        pGraphics.line(phyloNode2.getX(), phyloNode2.getY(), phyloNode.getX(), phyloNode.getY());
    }

    protected float branchPosition(PhyloNode phyloNode) {
        PhyloNode phyloNode2;
        int n;
        this.setAngle(phyloNode, 0.0f);
        if (this.tree.isLeaf(phyloNode)) {
            return 0.0f;
        }
        List<PhyloNode> list = this.tree.getChildrenOf(phyloNode);
        for (n = 0; n < list.size(); ++n) {
            phyloNode2 = list.get(n);
        }
        for (n = 0; n < list.size(); ++n) {
            phyloNode2 = list.get(n);
            this.branchPosition(phyloNode2);
        }
        Collections.sort(list);
        PhyloNode phyloNode3 = Collections.min(list);
        phyloNode2 = Collections.max(list);
        float f = 1.0f / (float)this.numLeaves;
        float f2 = this.tree.getNumEnclosedLeaves(phyloNode3);
        float f3 = this.tree.getNumEnclosedLeaves(phyloNode2);
        float f4 = Math.max(f2, f3);
        float f5 = phyloNode3.getTargetY() + (f4 - f2) * f / 2.0f;
        float f6 = phyloNode2.getTargetY() - (f4 - f3) * f / 2.0f;
        float f7 = (f5 + f6) / 2.0f;
        float f8 = this.calcXPosition(phyloNode);
        this.setPosition(phyloNode, f8, f7);
        return 0.0f;
    }

    protected int getRealEnclosedLeaves(PhyloNode phyloNode) {
        int n;
        int n2 = n = this.tree.getNumEnclosedLeaves(phyloNode);
        List<PhyloNode> list = this.tree.getChildrenOf(phyloNode);
        return n;
    }

    private void leafPosition(PhyloNode phyloNode, int n) {
        float f = ((float)n + 0.5f) / (float)this.numLeaves;
        float f2 = 1.0f;
        f2 = this.calcXPosition(phyloNode);
        this.setPosition(phyloNode, f2, f);
    }

    protected float calcXPosition(PhyloNode phyloNode) {
        float f = this.xPosForNumEnclosedLeaves(this.getRealEnclosedLeaves(phyloNode));
        return f / 2.0f;
    }

    float xPosForNumEnclosedLeaves(int n) {
        float f = 1.0f - (float)(n - 1) / (float)this.leaves.length;
        return f;
    }
}

