/*
 * Decompiled with CFR 0.152.
 */
package org.phylowidget.render;

import java.util.List;
import org.andrewberman.ui.UIUtils;
import org.phylowidget.PhyloWidget;
import org.phylowidget.render.LayoutBase;
import org.phylowidget.tree.PhyloNode;
import processing.core.PGraphics;

public class LayoutCladogram
extends LayoutBase {
    int numLeaves;
    float depthLeafRatio;

    public void layoutImpl() {
        this.numLeaves = this.leaves.length;
        float f = this.tree.getMaxDepthToLeaf(this.tree.getRoot());
        this.depthLeafRatio = f / (float)this.numLeaves;
        this.depthLeafRatio *= PhyloWidget.cfg.branchScaling;
        int n = 0;
        for (PhyloNode phyloNode : this.leaves) {
            phyloNode.setTextAlign(0);
            this.leafPosition(phyloNode, n);
            ++n;
        }
        this.branchPosition((PhyloNode)this.tree.getRoot());
    }

    public void drawLine(PGraphics pGraphics, PhyloNode phyloNode, PhyloNode phyloNode2) {
        if (UIUtils.isJava2D(pGraphics)) {
            pGraphics.strokeCap(2);
            pGraphics.strokeJoin(2);
        }
        pGraphics.noFill();
        pGraphics.beginShape();
        pGraphics.vertex(phyloNode.getX(), phyloNode.getY());
        pGraphics.vertex(phyloNode.getX(), phyloNode2.getY());
        pGraphics.vertex(phyloNode2.getX(), phyloNode2.getY());
        pGraphics.endShape();
        if (UIUtils.isJava2D(pGraphics)) {
            pGraphics.strokeCap(2);
        }
    }

    private float branchPosition(PhyloNode phyloNode) {
        this.setAngle(phyloNode, 0.0f);
        if (this.tree.isLeaf(phyloNode)) {
            return phyloNode.getTargetY();
        }
        List<PhyloNode> list = this.tree.getChildrenOf(phyloNode);
        float f = 0.0f;
        float f2 = 0.0f;
        for (int i = 0; i < list.size(); ++i) {
            PhyloNode phyloNode2 = list.get(i);
            f += this.branchPosition(phyloNode2);
            f2 += 1.0f;
        }
        float f3 = f / f2;
        float f4 = 1.0f;
        f4 = this.calcXPosition(phyloNode);
        this.setPosition(phyloNode, f4, f3);
        return f3;
    }

    private void leafPosition(PhyloNode phyloNode, int n) {
        float f = ((float)n + 0.5f) / (float)this.numLeaves;
        float f2 = this.calcXPosition(phyloNode);
        this.setPosition(phyloNode, f2, f);
    }

    private float calcXPosition(PhyloNode phyloNode) {
        if (PhyloWidget.cfg.useBranchLengths) {
            if (this.tree.isRoot(phyloNode)) {
                return 0.0f;
            }
            float f = 0.0f;
            if (this.tree.getMaxHeightToLeaf(this.tree.getRoot()) == 0.0) {
                System.out.println("Tree height is zero!");
            }
            f = (float)this.tree.getHeightToRoot(phyloNode) / (float)this.tree.getMaxHeightToLeaf(this.tree.getRoot());
            return f * this.depthLeafRatio;
        }
        if (this.tree.isRoot(phyloNode)) {
            return 0.0f;
        }
        float f = 1.0f - (float)this.tree.getMaxDepthToLeaf(phyloNode) / (float)this.tree.getMaxDepthToLeaf(this.tree.getRoot());
        return f * this.depthLeafRatio;
    }
}

