/*
 * Decompiled with CFR 0.152.
 */
package org.phylowidget.render;

import java.util.HashMap;
import java.util.List;
import org.andrewberman.ui.Color;
import org.andrewberman.ui.UIUtils;
import org.phylowidget.PhyloWidget;
import org.phylowidget.render.LayoutBase;
import org.phylowidget.tree.PhyloNode;
import processing.core.PGraphics;

public class LayoutCircular
extends LayoutBase {
    static final float STARTING_ANGLE = 4.712389f;
    int numLeaves;
    float depthToLeaves;
    PhyloNode root;
    float rootX;
    float rootY;
    HashMap<PhyloNode, AngleRadius> nodeToAngleRadius = new HashMap();
    static float PI = (float)Math.PI;
    static float TWOPI = (float)Math.PI * 2;
    float curAngle;

    public synchronized void layoutImpl() {
        this.numLeaves = this.leaves.length;
        this.curAngle = 4.712389f + PhyloWidget.cfg.layoutAngle / 360.0f * (float)Math.PI * 2.0f;
        int n = 0;
        for (PhyloNode phyloNode : this.leaves) {
            phyloNode.setTextAlign(0);
            this.leafPosition(phyloNode, n);
            ++n;
        }
        this.branchPosition((PhyloNode)this.tree.getRoot());
        this.root = (PhyloNode)this.tree.getRoot();
        this.rootX = ((PhyloNode)this.tree.getRoot()).getX();
        this.rootY = ((PhyloNode)this.tree.getRoot()).getY();
    }

    public synchronized void drawLine(PGraphics pGraphics, PhyloNode phyloNode, PhyloNode phyloNode2) {
        AngleRadius angleRadius = this.nodeToAngleRadius.get(phyloNode2);
        AngleRadius angleRadius2 = this.nodeToAngleRadius.get(phyloNode);
        if (this.root == null) {
            return;
        }
        float f = this.root.getX();
        float f2 = this.root.getY();
        float f3 = this.getDistance(this.root, phyloNode2);
        float f4 = this.getDistance(this.root, phyloNode);
        pGraphics.ellipseMode(2);
        pGraphics.noFill();
        float f5 = this.loAngle(angleRadius.angle, angleRadius2.angle);
        float f6 = this.hiAngle(angleRadius.angle, angleRadius2.angle);
        pGraphics.arc(f, f2, f4, f4, f5, f6);
        if (!PhyloWidget.cfg.useBranchLengths || !this.tree.isLeaf(phyloNode2)) {
            if (UIUtils.isJava2D(pGraphics)) {
                pGraphics.strokeCap(2);
            }
            pGraphics.line(phyloNode2.getX(), phyloNode2.getY(), f + (float)Math.cos(angleRadius.angle) * f4, f2 + (float)Math.sin(angleRadius.angle) * f4);
        } else {
            float f7 = angleRadius.leafRadius / angleRadius.radius;
            if (UIUtils.isJava2D(pGraphics)) {
                pGraphics.strokeCap(2);
            }
            pGraphics.line(f + (float)Math.cos(angleRadius.angle) * angleRadius.leafRadius * this.scaleX * this.drawScaleX, f2 + (float)Math.sin(angleRadius.angle) * angleRadius.leafRadius * this.scaleY * this.drawScaleY, f + (float)Math.cos(angleRadius.angle) * f4, f2 + (float)Math.sin(angleRadius.angle) * f4);
            pGraphics.strokeCap(1);
            Color color = new Color(pGraphics.strokeColor);
            int n = (int)((double)(color.getRed() + color.getGreen() + color.getBlue()) / 3.0);
            n = Math.max(n, 180);
            pGraphics.stroke(new Color(n, n, n).getRGB());
            pGraphics.line(f + (float)Math.cos(angleRadius.angle) * angleRadius.leafRadius * this.scaleX * this.drawScaleX, f2 + (float)Math.sin(angleRadius.angle) * angleRadius.leafRadius * this.scaleY * this.drawScaleY, phyloNode2.getX(), phyloNode2.getY());
        }
    }

    private float getDistance(PhyloNode phyloNode, PhyloNode phyloNode2) {
        float f = phyloNode.getX();
        float f2 = phyloNode.getY();
        float f3 = phyloNode2.getX();
        float f4 = phyloNode2.getY();
        return (float)Math.sqrt((f3 - f) * (f3 - f) + (f4 - f2) * (f4 - f2));
    }

    private float branchPosition(PhyloNode phyloNode) {
        if (this.tree.isLeaf(phyloNode)) {
            float f = this.nodeToAngleRadius.get((Object)phyloNode).angle;
            return f;
        }
        List<PhyloNode> list = this.tree.getChildrenOf(phyloNode);
        float f = 0.0f;
        float f2 = 0.0f;
        for (int i = 0; i < list.size(); ++i) {
            PhyloNode phyloNode2 = list.get(i);
            f += this.branchPosition(phyloNode2);
            f2 += 1.0f;
        }
        float f3 = this.calcRadius(phyloNode);
        float f4 = f / f2;
        float f5 = (float)Math.cos(f4) * f3;
        float f6 = (float)Math.sin(f4) * f3;
        this.setPosition(phyloNode, f5, f6);
        this.setAngle(phyloNode, f4);
        this.nodeToAngleRadius.put(phyloNode, new AngleRadius(f4, f3));
        return f4;
    }

    private float angleBetween(float f, float f2) {
        if ((f2 %= TWOPI) - (f %= TWOPI) > PI) {
            f += TWOPI;
        }
        if (f - f2 > PI) {
            f2 += TWOPI;
        }
        return (f + f2) / 2.0f;
    }

    private float loAngle(float f, float f2) {
        if ((f2 %= TWOPI) - (f %= TWOPI) > PI) {
            f += TWOPI;
        }
        if (f - f2 > PI) {
            f2 += TWOPI;
        }
        return Math.min(f, f2);
    }

    private float hiAngle(float f, float f2) {
        if ((f2 %= TWOPI) - (f %= TWOPI) > PI) {
            f += TWOPI;
        }
        if (f - f2 > PI) {
            f2 += TWOPI;
        }
        return Math.max(f, f2);
    }

    private void leafPosition(PhyloNode phyloNode, int n) {
        float f = this.curAngle;
        this.curAngle += 1.0f / (float)this.numLeaves * (float)Math.PI * 2.0f;
        float f2 = 1.0f;
        float f3 = 1.0f;
        if (PhyloWidget.cfg.useBranchLengths) {
            f3 = this.calcRadius(phyloNode);
        }
        float f4 = (float)Math.sin(f) * f2;
        float f5 = (float)Math.cos(f) * f2;
        this.setPosition(phyloNode, f5, f4);
        this.setAngle(phyloNode, f);
        this.nodeToAngleRadius.put(phyloNode, new AngleRadius(f, f2, f3));
    }

    private float calcRadius(PhyloNode phyloNode) {
        if (PhyloWidget.cfg.useBranchLengths) {
            if (this.tree.isRoot(phyloNode)) {
                return 0.0f;
            }
            float f = (float)this.tree.getHeightToRoot(phyloNode) / (float)this.tree.getMaxHeightToLeaf(this.tree.getRoot());
            return f;
        }
        if (this.tree.isRoot(phyloNode)) {
            return 0.0f;
        }
        float f = 1.0f - (float)this.tree.getMaxDepthToLeaf(phyloNode) / (float)this.tree.getMaxDepthToLeaf(this.tree.getRoot());
        return f;
    }

    class AngleRadius {
        public float angle;
        public float radius;
        public float leafRadius;

        public AngleRadius(float f, float f2) {
            this.angle = f;
            this.radius = f2;
        }

        public AngleRadius(float f, float f2, float f3) {
            this(f, f2);
            this.leafRadius = f3;
        }
    }
}

