/*
 * Decompiled with CFR 0.152.
 */
package org.phylowidget.render;

import java.awt.geom.Rectangle2D;
import org.phylowidget.PhyloWidget;
import org.phylowidget.render.LayoutCladogram;
import org.phylowidget.render.LayoutDiagonal;
import org.phylowidget.tree.PhyloNode;
import org.phylowidget.tree.RootedTree;
import processing.core.PApplet;
import processing.core.PGraphics;

public abstract class LayoutBase {
    protected RootedTree tree;
    protected PhyloNode[] leaves;
    protected PhyloNode[] nodes;
    protected double loX;
    protected double loY;
    protected double hiX;
    protected double hiY;
    public static final float TWOPI = (float)Math.PI * 2;
    public static final float PI = (float)Math.PI;
    protected int angleHandling;
    public static final int ANGLE_NONE = 0;
    public static final int ANGLE_QUANTIZE = 1;
    public static final int ANGLE_LEVEL = 2;
    float scaleX;
    float scaleY;
    float dX;
    float dY;
    float drawScaleX;
    float drawScaleY;
    private Rectangle2D.Float rect = new Rectangle2D.Float();

    public void layout(RootedTree rootedTree, PhyloNode[] phyloNodeArray, PhyloNode[] phyloNodeArray2) {
        this.tree = rootedTree;
        this.leaves = phyloNodeArray;
        this.nodes = phyloNodeArray2;
        this.loY = Double.MAX_VALUE;
        this.loX = Double.MAX_VALUE;
        this.hiY = Double.MIN_VALUE;
        this.hiX = Double.MIN_VALUE;
        this.angleHandling = PhyloWidget.cfg.angleHandling.toLowerCase().equals("quantize") ? 1 : (PhyloWidget.cfg.angleHandling.toLowerCase().equals("level") ? 2 : 0);
        this.layoutImpl();
        this.rect.setFrame(this.loX, this.loY, this.hiX - this.loX, this.hiY - this.loY);
        this.dX = -this.rect.x;
        this.dY = -this.rect.y;
        this.scaleX = 1.0f / this.rect.width;
        this.scaleY = 1.0f / this.rect.height;
        float f = PApplet.min((float)this.scaleX, (float)this.scaleY);
        if (Float.isInfinite(f)) {
            f = 0.0f;
            this.scaleY = 0.0f;
            this.scaleX = 0.0f;
        } else {
            this.scaleX = this.scaleY = f;
        }
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (f * this.rect.width < 1.0f && f != 0.0f) {
            f2 = (1.0f - f * this.rect.width) / 2.0f;
        }
        if ((double)(f * this.rect.height) < 0.9 && f != 0.0f) {
            f3 = (1.0f - f * this.rect.height) / 2.0f;
        }
        for (PhyloNode phyloNodeArray3 : phyloNodeArray2) {
            phyloNodeArray3.setPosition((phyloNodeArray3.getLayoutX() + this.dX) * this.scaleX + f2, (phyloNodeArray3.getLayoutY() + this.dY) * this.scaleY + f3);
        }
        if (phyloNodeArray.length < 10 && (this instanceof LayoutCladogram || this instanceof LayoutDiagonal)) {
            float f4 = (10.0f - (float)phyloNodeArray.length) / 10.0f;
            float f5 = -1.0f;
            float f6 = f4 * f5;
            for (PhyloNode phyloNode : phyloNodeArray2) {
                phyloNode.setPosition(phyloNode.getLayoutX() + f6, phyloNode.getLayoutY());
            }
        }
    }

    protected void setPosition(PhyloNode phyloNode, float f, float f2) {
        phyloNode.setPosition(f, f2);
        if ((double)f < this.loX) {
            this.loX = f;
        }
        if ((double)f > this.hiX) {
            this.hiX = f;
        }
        if ((double)f2 < this.loY) {
            this.loY = f2;
        }
        if ((double)f2 > this.hiY) {
            this.hiY = f2;
        }
    }

    public abstract void drawLine(PGraphics var1, PhyloNode var2, PhyloNode var3);

    protected abstract void layoutImpl();

    static final boolean between(float f, float f2, float f3) {
        return f <= f3 && f >= f2;
    }

    protected final void setAngle(PhyloNode phyloNode, float f) {
        f += (float)Math.PI * 2;
        phyloNode.setAngle(f %= (float)Math.PI * 2);
        String string = phyloNode.getAnnotation("collapse");
        if (string != null && PhyloNode.parseTruth(string)) {
            return;
        }
        switch (this.angleHandling) {
            case 0: {
                LayoutBase.noneAngles(phyloNode);
                break;
            }
            case 1: {
                LayoutBase.quantizeAngles(phyloNode);
                break;
            }
            case 2: {
                LayoutBase.levelAngles(phyloNode);
            }
        }
    }

    private static final void noneAngles(PhyloNode phyloNode) {
        float f = phyloNode.getAngle();
        float f2 = f / ((float)Math.PI * 2) * 360.0f;
        boolean bl = false;
        if (!LayoutBase.between(f2, 0.0f, 90.0f) && !LayoutBase.between(f2, 270.0f, 360.0f)) {
            bl = true;
            f2 += 180.0f;
        }
        LayoutBase.setDegreesAndAlignment(phyloNode, f2, bl);
    }

    private static final void setDegreesAndAlignment(PhyloNode phyloNode, float f, boolean bl) {
        if (bl) {
            phyloNode.setTextAlign(1);
        } else {
            phyloNode.setTextAlign(0);
        }
        phyloNode.setAngle(f / 360.0f * 2.0f * (float)Math.PI);
    }

    private static final void levelAngles(PhyloNode phyloNode) {
        float f = phyloNode.getAngle();
        float f2 = f / ((float)Math.PI * 2) * 360.0f;
        boolean bl = false;
        if (LayoutBase.between(f2 %= 360.0f, 0.0f, 90.0f) || LayoutBase.between(f2, 270.0f, 360.0f)) {
            f2 = 0.0f;
            bl = false;
        } else {
            f2 = 0.0f;
            bl = true;
        }
        LayoutBase.setDegreesAndAlignment(phyloNode, f2, bl);
    }

    private static final void quantizeAngles(PhyloNode phyloNode) {
        float f = phyloNode.getAngle();
        float f2 = f / ((float)Math.PI * 2) * 360.0f;
        f2 += 720.0f;
        float f3 = f2 %= 360.0f;
        boolean bl = false;
        if (LayoutBase.between(f2, 0.0f, 45.0f)) {
            f2 = 0.0f;
            bl = false;
        } else if (LayoutBase.between(f2, 45.0f, 90.0f)) {
            f2 = 45.0f;
            bl = false;
        } else if (LayoutBase.between(f2, 90.0f, 135.0f)) {
            f2 = -45.0f;
            bl = true;
        } else if (LayoutBase.between(f2, 135.0f, 225.0f)) {
            f2 = 0.0f;
            bl = true;
        } else if (LayoutBase.between(f2, 225.0f, 270.0f)) {
            f2 = 45.0f;
            bl = true;
        } else if (LayoutBase.between(f2, 270.0f, 315.0f)) {
            f2 = -45.0f;
            bl = false;
        } else if (LayoutBase.between(f2, 315.0f, 360.0f)) {
            f2 = 0.0f;
            bl = false;
        }
        LayoutBase.setDegreesAndAlignment(phyloNode, f2, bl);
    }
}

