/*
 * Decompiled with CFR 0.152.
 */
package org.phylowidget.render;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.andrewberman.ui.UIGlobals;
import org.andrewberman.ui.UIUtils;
import processing.core.PGraphics;
import processing.core.PGraphicsJava2D;

public class DoubleBuffer
implements Runnable {
    private PGraphicsJava2D dummyGraphics = new PGraphicsJava2D();
    private BufferedImage offscreen;
    private BufferedImage onscreen;
    private Graphics2D offscreenG;
    private Graphics2D onscreenG;
    Rectangle2D.Float onscreenRect;
    boolean shouldRepaint;
    Thread repaintThread;
    static int count = 0;
    private boolean stopRunning = false;

    public DoubleBuffer() {
        this.dummyGraphics.setParent(UIGlobals.g.getP());
        this.repaintThread = new Thread((Runnable)this, "DoubleBuffer");
        this.repaintThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void triggerRepaint() {
        DoubleBuffer doubleBuffer = this;
        synchronized (doubleBuffer) {
            this.shouldRepaint = true;
            this.notifyAll();
        }
    }

    private synchronized void allocateBuffers(PGraphics pGraphics) {
        if (this.offscreen != null) {
            this.offscreen.flush();
        }
        if (this.onscreen != null) {
            this.onscreen.flush();
        }
        ++count;
        this.offscreen = new BufferedImage(pGraphics.width, pGraphics.height, 2);
        this.onscreen = new BufferedImage(pGraphics.width, pGraphics.height, 2);
        this.offscreenG = this.offscreen.createGraphics();
        this.onscreenG = this.onscreen.createGraphics();
        UIUtils.setRenderingHints(this.offscreenG);
        UIUtils.setRenderingHints(this.onscreenG);
        this.dummyGraphics.width = pGraphics.width;
        this.dummyGraphics.height = pGraphics.height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawToCanvas(PGraphics pGraphics) {
        if (this.offscreen == null || this.offscreen.getWidth() != pGraphics.width || this.offscreen.getHeight() != pGraphics.height) {
            this.allocateBuffers(pGraphics);
        }
        this.triggerRepaint();
        BufferedImage bufferedImage = this.onscreen;
        synchronized (bufferedImage) {
            pGraphics.loadPixels();
            BufferedImage bufferedImage2 = (BufferedImage)pGraphics.image;
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.drawImage((Image)this.onscreen, 0, 0, null);
            graphics2D.dispose();
        }
    }

    public void drawToBuffer(PGraphics pGraphics) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.stopRunning) {
            Object object;
            if (this.shouldRepaint) {
                object = this;
                synchronized (object) {
                    this.dummyGraphics.image = this.offscreen;
                    this.dummyGraphics.g2 = this.offscreenG;
                    try {
                        this.drawToBuffer((PGraphics)this.dummyGraphics);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    this.dummyGraphics.image = null;
                    this.dummyGraphics.g2 = null;
                }
                object = this.onscreen;
                synchronized (object) {
                    BufferedImage bufferedImage = this.offscreen;
                    Graphics2D graphics2D = this.offscreenG;
                    this.offscreen = this.onscreen;
                    this.offscreenG = this.onscreenG;
                    this.onscreen = bufferedImage;
                    this.onscreenG = graphics2D;
                }
            }
            if (this.stopRunning) break;
            try {
                object = this;
                synchronized (object) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        this.dummyGraphics = null;
        this.offscreen = null;
        this.onscreen = null;
        this.offscreenG = null;
        this.onscreenG = null;
        this.onscreenRect = null;
        this.repaintThread = null;
    }

    public synchronized void dispose() {
        this.stopRunning = true;
        this.notifyAll();
    }
}

