/*
 * Decompiled with CFR 0.152.
 */
package org.phylowidget.render;

import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.andrewberman.sortedlist.SortedXYRangeList;
import org.andrewberman.ui.Point;
import org.andrewberman.ui.TextField;
import org.andrewberman.ui.UIGlobals;
import org.andrewberman.ui.UIUtils;
import org.andrewberman.ui.unsorted.BulgeUtil;
import org.jgrapht.event.GraphEdgeChangeEvent;
import org.jgrapht.event.GraphListener;
import org.jgrapht.event.GraphVertexChangeEvent;
import org.phylowidget.PhyloTree;
import org.phylowidget.PhyloWidget;
import org.phylowidget.UsefulConstants;
import org.phylowidget.render.DoubleBuffer;
import org.phylowidget.render.LayoutBase;
import org.phylowidget.render.LayoutUnrooted;
import org.phylowidget.render.NodeRange;
import org.phylowidget.render.NodeRenderer;
import org.phylowidget.render.OverlapDetector;
import org.phylowidget.render.TreeRenderer;
import org.phylowidget.tree.PhyloNode;
import org.phylowidget.tree.RootedTree;
import org.phylowidget.ui.NodeUncollapser;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PGraphicsJava2D;

public class BasicTreeRenderer
extends DoubleBuffer
implements TreeRenderer,
GraphListener,
UsefulConstants {
    float baseStroke;
    protected LayoutBase treeLayout = new LayoutUnrooted();
    protected OverlapDetector overlap = new OverlapDetector();
    protected PhyloNode widestNode;
    protected PGraphics canvas;
    protected float colSize;
    protected float dFont;
    protected float dotWidth;
    protected double dx;
    protected double dy;
    protected PFont font;
    protected float biggestAspectRatio = 0.0f;
    public static NodeRenderer decorator;
    protected PhyloNode[] leaves = new PhyloNode[1];
    protected PhyloNode[] sigLeaves = new PhyloNode[1];
    protected SortedXYRangeList list = new SortedXYRangeList();
    boolean mainRender;
    protected boolean needsLayout;
    protected PhyloNode[] nodes = new PhyloNode[1];
    RenderingHints oldRH;
    protected Point ptemp = new Point(0.0f, 0.0f);
    protected Point ptemp2 = new Point(0.0f, 0.0f);
    public Rectangle2D.Float rect;
    public Rectangle2D.Float screenRect;
    protected float rowSize;
    protected double scaleX;
    protected double scaleY;
    protected float textSize;
    protected int threshold;
    Rectangle2D.Float tRect = new Rectangle2D.Float();
    protected RootedTree tree;
    private boolean fforwardMe;
    private float tsf;
    ArrayList<PhyloNode> foundItems = new ArrayList();
    private Area a;
    private Polygon tempP = new Polygon();
    Rectangle2D.Float r2d = new Rectangle2D.Float();
    static final float POLYMULT = 1000.0f;
    Rectangle2D.Float rect1 = new Rectangle2D.Float();
    Rectangle2D.Float rect2 = new Rectangle2D.Float();
    Rectangle2D.Float rect3 = new Rectangle2D.Float();
    Point mousePt = new Point();
    private float overhang;
    private Point2D.Float tempPt = new Point2D.Float();
    private LayoutBase oldLayout = null;
    private int framesToSwitch = 0;

    public BasicTreeRenderer() {
        this.rect = new Rectangle2D.Float(0.0f, 0.0f, 0.0f, 0.0f);
        this.font = UIGlobals.g.getPFont();
        if (decorator == null) {
            decorator = new NodeRenderer();
        }
        this.setOptions();
    }

    float calcRealX(PhyloNode phyloNode) {
        return (float)((double)phyloNode.getLayoutX() * this.scaleX + this.dx);
    }

    float calcRealY(PhyloNode phyloNode) {
        return (float)((double)phyloNode.getLayoutY() * this.scaleY + this.dy);
    }

    protected void constrainAspectRatio() {
    }

    protected void draw() {
        Object object;
        PhyloNode phyloNode2;
        int n;
        float f = Math.min(this.rowSize, this.colSize);
        this.baseStroke = this.getNormalLineWidth() * PhyloWidget.cfg.lineWidth;
        this.canvas.noStroke();
        this.canvas.fill(0);
        this.canvas.textFont(UIGlobals.g.getPFont());
        this.canvas.textAlign(37, 3);
        this.hint();
        this.screenRect = new Rectangle2D.Float(0.0f, 0.0f, this.canvas.width, this.canvas.height);
        UIUtils.screenToModel(this.screenRect);
        this.treeLayout.drawScaleX = (float)this.scaleX;
        this.treeLayout.drawScaleY = (float)this.scaleY;
        this.a = new Area();
        this.foundItems.clear();
        int n2 = 0;
        PhyloNode[] phyloNodeArray = new PhyloNode[this.nodes.length];
        Thread.yield();
        for (n = 0; n < this.nodes.length; ++n) {
            Thread.yield();
            phyloNode2 = this.nodes[n];
            if (this.fforwardMe) {
                phyloNode2.fforward();
            }
            this.updateNode(phyloNode2);
            phyloNode2.drawMe = false;
            phyloNode2.labelWasDrawn = false;
            phyloNode2.drawLineAndNode = false;
            phyloNode2.drawLabel = false;
            phyloNode2.isWithinScreen = this.isNodeWithinScreen(phyloNode2);
            phyloNode2.bulgeFactor = 1.0f;
            if (phyloNode2.found && phyloNode2.isWithinScreen) {
                this.foundItems.add(phyloNode2);
            }
            if (phyloNode2.getAnnotation("PW_ALWAYS") != null) {
                this.foundItems.add(phyloNode2);
            } else if (phyloNode2.getAnnotation("PW_A") != null) {
                this.foundItems.add(phyloNode2);
            }
            if ((float)n2 >= PhyloWidget.cfg.renderThreshold && !PhyloWidget.cfg.showAllLabels || !phyloNode2.isWithinScreen) continue;
            phyloNode2.drawMe = true;
            phyloNodeArray[n2] = phyloNode2;
            ++n2;
        }
        this.fforwardMe = false;
        Thread.yield();
        for (n = n2 - 1; n >= 0; --n) {
            Thread.yield();
            phyloNode2 = phyloNodeArray[n];
            NodeRenderer.r = this;
            phyloNode2.drawLineAndNode = true;
            phyloNode2.drawLabel = false;
            this.handleNode(phyloNode2);
        }
        if (this.tree instanceof PhyloTree) {
            PhyloTree phyloTree = (PhyloTree)this.tree;
            phyloNode2 = phyloTree.hoveredNode;
            if (phyloNode2 != null) {
                object = new Point(this.getX(phyloNode2), this.getY(phyloNode2));
                float f2 = (float)((Point2D)object).distance(this.mousePt);
                float f3 = BulgeUtil.bulge(f2, 0.7f, 30.0f);
                if (this.tree.isLeaf(phyloNode2)) {
                    phyloNode2.bulgeFactor = this.textSize <= 14.0f ? f3 : 1.0f;
                }
                this.insertAndReturnOverlap(phyloNode2);
                phyloNode2.drawLabel = true;
                NodeRenderer.render(this, phyloNode2);
                phyloNode2.labelWasDrawn = true;
            }
        }
        Thread.yield();
        Collections.reverse(this.foundItems);
        for (PhyloNode phyloNode2 : this.foundItems) {
            Thread.yield();
            object = phyloNode2.range;
            this.insertAndReturnOverlap(phyloNode2);
        }
        Thread.yield();
        for (int i = 0; i < this.sigLeaves.length; ++i) {
            Thread.yield();
            phyloNode2 = this.sigLeaves[i];
            if (!phyloNode2.isWithinScreen || phyloNode2.labelWasDrawn) continue;
            object = phyloNode2.range;
            if (this.insertAndReturnOverlap(phyloNode2)) continue;
            phyloNode2.drawLabel = true;
            NodeRenderer.render(this, phyloNode2);
        }
        Thread.yield();
        for (PhyloNode phyloNode2 : this.foundItems) {
            Thread.yield();
            object = phyloNode2.range;
            phyloNode2.drawLabel = true;
            NodeRenderer.render(this, phyloNode2);
            phyloNode2.labelWasDrawn = true;
        }
        this.unhint();
    }

    private final boolean insertAndReturnOverlap(PhyloNode phyloNode) {
        if (PhyloWidget.cfg.showAllLabels) {
            return false;
        }
        float f = phyloNode.getAngle();
        if ((double)f % Math.PI / 2.0 == 0.0) {
            if (this.intersectsRect(phyloNode, this.a)) {
                return true;
            }
            this.a.add(new Area(this.r2d));
        } else {
            this.fillPolygon(phyloNode, this.tempP);
            if (this.intersectsPoly(phyloNode, this.a, this.tempP)) {
                return true;
            }
            this.a.add(new Area(this.tempP));
        }
        return false;
    }

    private final boolean intersectsPoly(PhyloNode phyloNode, Area area, Polygon polygon) {
        int[] nArray = polygon.xpoints;
        int[] nArray2 = polygon.ypoints;
        for (int i = 0; i < nArray.length; ++i) {
            float f = (float)nArray[i] / 1000.0f;
            float f2 = (float)nArray2[i] / 1000.0f;
            if (!area.contains(f, f2)) continue;
            return true;
        }
        return false;
    }

    private final boolean intersectsRect(PhyloNode phyloNode, Area area) {
        this.r2d.setFrame(phyloNode.range.loX, phyloNode.range.loY, phyloNode.range.hiX - phyloNode.range.loX, phyloNode.range.hiY - phyloNode.range.loY);
        return area.intersects(this.r2d);
    }

    private void fillPolygon(PhyloNode phyloNode, Polygon polygon) {
        Point2D[] point2DArray;
        polygon.reset();
        for (Point2D point2D : point2DArray = phyloNode.corners) {
            polygon.addPoint((int)(point2D.getX() * 1000.0), (int)(point2D.getY() * 1000.0));
        }
    }

    protected void drawBootstrap(PhyloNode phyloNode) {
        if (phyloNode.isNHX() && PhyloWidget.cfg.showBootstrapValues) {
            String string = phyloNode.getAnnotation("B");
            if (string != null) {
                this.canvas.pushMatrix();
                this.canvas.translate(this.getX(phyloNode), this.getY(phyloNode));
                Double d = Double.parseDouble(string);
                float f = this.textSize * 0.5f;
                this.canvas.textFont(this.font);
                this.canvas.textSize(f);
                this.canvas.fill(PhyloWidget.cfg.getTextColor().brighter(100.0).getRGB());
                this.canvas.textAlign(39, 102);
                float f2 = 0.0f;
                this.canvas.text(string, -this.getNodeRadius(), -f2);
                this.canvas.popMatrix();
            }
        } else {
            return;
        }
    }

    protected boolean useOverlapDetector() {
        return true;
    }

    double clamp(double d, double d2, double d3) {
        if (d <= d2) {
            return d2;
        }
        if (d >= d3) {
            return d3;
        }
        return d;
    }

    protected float getNormalLineWidth() {
        float f = this.rowSize * 0.1f;
        return f;
    }

    public void edgeAdded(GraphEdgeChangeEvent graphEdgeChangeEvent) {
        this.needsLayout = true;
    }

    public void edgeRemoved(GraphEdgeChangeEvent graphEdgeChangeEvent) {
        this.needsLayout = true;
    }

    public float getNodeRadius() {
        return this.dotWidth / 2.0f;
    }

    public float getNodeOffset(PhyloNode phyloNode) {
        float f = NodeRenderer.nr.render(this.canvas, phyloNode, false, true)[1];
        return f;
    }

    public float getTextSize() {
        return this.textSize;
    }

    public RootedTree getTree() {
        return this.tree;
    }

    public void fforward() {
        ArrayList arrayList = new ArrayList();
        this.tree.getAll(this.tree.getRoot(), null, arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            PhyloNode phyloNode = (PhyloNode)arrayList.get(i);
            phyloNode.fforward();
        }
    }

    float getX(PhyloNode phyloNode) {
        return phyloNode.getX();
    }

    float getY(PhyloNode phyloNode) {
        return phyloNode.getY();
    }

    protected void handleNode(PhyloNode phyloNode) {
        if (this.tree.isLeaf(phyloNode)) {
            NodeRenderer.render(this, phyloNode);
        } else {
            phyloNode.drawLabel = true;
            if (this.insertAndReturnOverlap(phyloNode)) {
                phyloNode.drawLabel = false;
            }
            NodeRenderer.render(this, phyloNode);
            this.drawBootstrap(phyloNode);
            List<PhyloNode> list = this.tree.getChildrenOf(phyloNode);
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                PhyloNode phyloNode2 = list.get(i);
                NodeRange nodeRange = phyloNode2.range;
                if (phyloNode2.drawMe || !phyloNode2.isWithinScreen) continue;
                PhyloNode phyloNode3 = null;
                if (i == 0) {
                    phyloNode3 = this.tree.getFirstLeaf(phyloNode2);
                } else {
                    if (i != list.size() - 1) continue;
                    phyloNode3 = this.tree.getLastLeaf(phyloNode2);
                }
                while (phyloNode3 != phyloNode) {
                    phyloNode3.drawLineAndNode = true;
                    phyloNode3.drawLabel = false;
                    NodeRenderer.render(this, phyloNode3);
                    phyloNode3 = this.tree.getParentOf(phyloNode3);
                }
            }
        }
    }

    void drawCladeLabelIfNeeded(PhyloNode phyloNode) {
        boolean bl;
        if (this.tree.isLeaf(phyloNode)) {
            return;
        }
        if (!(PhyloWidget.cfg.showCladeLabels && this.tree.isLabelSignificant(this.tree.getLabel(phyloNode)) && (bl = this.insertAndReturnOverlap(phyloNode)))) {
            // empty if block
        }
    }

    void hint() {
        if (UIUtils.isJava2D(this.canvas)) {
            Graphics2D graphics2D = ((PGraphicsJava2D)this.canvas).g2;
            this.oldRH = graphics2D.getRenderingHints();
            if (PhyloWidget.cfg.antialias) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            } else {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
        } else if (PhyloWidget.cfg.antialias) {
            this.canvas.smooth();
        } else {
            this.canvas.noSmooth();
        }
    }

    boolean isAnyParentDrawn(PhyloNode phyloNode) {
        for (PhyloNode phyloNode2 = (PhyloNode)phyloNode.getParent(); phyloNode2 != null; phyloNode2 = (PhyloNode)phyloNode2.getParent()) {
            if (!phyloNode2.drawMe) continue;
            return true;
        }
        return false;
    }

    protected boolean isNodeWithinScreen(PhyloNode phyloNode) {
        NodeRange nodeRange = phyloNode.range;
        float f = 50.0f;
        float f2 = 100.0f;
        PhyloNode phyloNode2 = this.tree.getParentOf(phyloNode);
        this.rect1.x = nodeRange.loX - f;
        this.rect1.y = nodeRange.loY - f;
        this.rect1.width = nodeRange.hiX - nodeRange.loX + f2;
        this.rect1.height = nodeRange.hiY - nodeRange.loY + f2;
        if (phyloNode2 == null) {
            return this.rect1.intersects(this.screenRect);
        }
        NodeRange nodeRange2 = phyloNode2.range;
        this.rect2.x = nodeRange2.loX - f;
        this.rect2.y = nodeRange2.loY - f;
        this.rect2.width = nodeRange2.hiX - nodeRange2.loX + f2;
        this.rect2.height = nodeRange2.hiY - nodeRange2.loY + f2;
        Rectangle.union(this.rect1, this.rect2, this.rect3);
        return this.screenRect.intersects(this.rect3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void layout() {
        Object object;
        int n;
        if (!this.needsLayout) {
            return;
        }
        this.needsLayout = false;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        Object object2 = this;
        synchronized (object2) {
            this.tree.getAll(this.tree.getRoot(), arrayList, arrayList2);
            Thread.yield();
            this.leaves = new PhyloNode[arrayList.size()];
            this.nodes = new PhyloNode[arrayList2.size()];
            this.leaves = arrayList.toArray(this.leaves);
            this.nodes = arrayList2.toArray(this.nodes);
            Arrays.sort(this.nodes, 0, this.nodes.length, this.tree.sorter);
            Thread.yield();
            this.sigLeaves = new PhyloNode[this.leaves.length];
            for (n = 0; n < this.leaves.length; ++n) {
                this.sigLeaves[n] = this.leaves[n];
            }
            n = 1;
            if (PhyloWidget.cfg.prioritizeDistantLabels) {
                n = -1;
            }
            int n2 = this.sigLeaves.length;
            RootedTree rootedTree = this.tree;
            rootedTree.getClass();
            Arrays.sort(this.sigLeaves, 0, n2, new RootedTree.DepthToRootComparator(rootedTree, n));
            Thread.yield();
        }
        object2 = this.list;
        synchronized (object2) {
            this.list.clear();
            for (n = 0; n < this.nodes.length; ++n) {
                PhyloNode phyloNode = this.nodes[n];
                object = phyloNode;
                synchronized (object) {
                    phyloNode.range.render = this;
                }
                this.list.insert(phyloNode.range, false);
            }
            this.list.sortFull();
        }
        Thread.yield();
        for (int i = 0; i < this.nodes.length; ++i) {
            float f;
            PhyloNode phyloNode = this.nodes[i];
            if (this.tree.isCollapsed(phyloNode) && !NodeUncollapser.containsNode(phyloNode)) {
                this.tree.collapseNode(phyloNode);
            }
            if (phyloNode.isNHX() && PhyloWidget.cfg.colorSpecies) {
                String string = phyloNode.getAnnotation("T");
                if (string != null) {
                    NodeRenderer.taxonColorMap.put(string, null);
                } else {
                    object = phyloNode.getAnnotation("S");
                    if (object != null) {
                        NodeRenderer.taxonColorMap.put((String)object, null);
                    }
                }
            }
            phyloNode.unitTextWidth = f = UIUtils.getTextWidth(this.canvas, this.font, 100.0f, phyloNode.getLabel(), true) / 100.0f;
        }
        Thread.yield();
        if (PhyloWidget.cfg.colorSpecies) {
            decorator.getColorsForSpeciesMap();
        }
        this.treeLayout.layout(this.tree, this.leaves, this.nodes);
    }

    public void layoutTrigger() {
        this.needsLayout = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodesInRange(ArrayList arrayList, Rectangle2D.Float float_) {
        SortedXYRangeList sortedXYRangeList = this.list;
        synchronized (sortedXYRangeList) {
            this.list.getInRange(arrayList, float_);
        }
    }

    public void positionText(PhyloNode phyloNode, TextField textField) {
        NodeRenderer.lr.positionText(this, phyloNode, textField);
    }

    protected void recalc() {
        this.rowSize = this.rect.height / (float)this.leaves.length;
        this.textSize = this.rowSize * 0.9f;
        this.dotWidth = this.getNormalLineWidth() * PhyloWidget.cfg.nodeSize;
        this.scaleX = this.rect.width;
        this.scaleY = this.rect.height;
        float f = (float)Math.min(this.scaleX, this.scaleY);
        this.scaleX = this.scaleY = (double)f;
        if (this.leaves.length <= 10) {
            float f2 = 0.025f;
            float f3 = f2 + (float)this.leaves.length * ((1.0f - f2) / 10.0f);
            this.scaleX *= (double)f3;
            this.scaleY *= (double)f3;
            this.rowSize *= f3;
            this.textSize *= f3;
            this.dotWidth *= f3;
        }
        this.dx = ((double)this.rect.width - this.scaleX) / 2.0;
        this.dy = ((double)this.rect.height - this.scaleY) / 2.0;
        this.dx += this.rect.getX();
        this.dy += this.rect.getY();
        this.dFont = (this.font.ascent() - this.font.descent()) * this.textSize / 2.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(PGraphics pGraphics, float f, float f2, float f3, float f4, boolean bl) {
        this.mainRender = bl;
        this.rect.setRect(f, f2, f3, f4);
        if (this.tree == null) {
            return;
        }
        if (PhyloWidget.cfg.useDoubleBuffering) {
            this.drawToCanvas(pGraphics);
        } else {
            RootedTree rootedTree = this.tree;
            synchronized (rootedTree) {
                this.canvas = pGraphics;
                this.layout();
                this.recalc();
                this.draw();
            }
        }
        --this.framesToSwitch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawToBuffer(PGraphics pGraphics) {
        this.canvas = pGraphics;
        pGraphics.background(0, 0.0f);
        RootedTree rootedTree = this.tree;
        synchronized (rootedTree) {
            this.layout();
            this.recalc();
            this.draw();
        }
        this.canvas = null;
    }

    public void setMouseLocation(Point point) {
        this.mousePt.setLocation(point);
    }

    protected void setOptions() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTree(RootedTree rootedTree) {
        RootedTree rootedTree2;
        if (rootedTree == null) {
            return;
        }
        if (this.tree != null) {
            rootedTree2 = this.tree;
            synchronized (rootedTree2) {
                this.tree.removeGraphListener(this);
                this.tree.dispose();
                this.tree = null;
            }
        }
        rootedTree2 = rootedTree;
        synchronized (rootedTree2) {
            this.tree = rootedTree;
            this.tree.addGraphListener(this);
            this.needsLayout = true;
            if (!PhyloWidget.cfg.animateNewTree) {
                this.fforwardMe = true;
            }
        }
    }

    void unhint() {
        if (UIUtils.isJava2D(this.canvas)) {
            Graphics2D graphics2D = ((PGraphicsJava2D)this.canvas).g2;
            graphics2D.setRenderingHints(this.oldRH);
        }
    }

    protected void updateNode(PhyloNode phyloNode) {
        if (this.mainRender) {
            phyloNode.update();
        }
        phyloNode.setX(this.calcRealX(phyloNode));
        phyloNode.setY(this.calcRealY(phyloNode));
        NodeRange nodeRange = phyloNode.range;
        NodeRenderer.setCornerPoints(this, phyloNode);
        if (phyloNode.rect.getWidth() == 0.0) {
            phyloNode.rect.setFrame(phyloNode.getX(), phyloNode.getY(), 0.0, 0.0);
        }
        nodeRange.loX = (float)phyloNode.rect.getMinX();
        nodeRange.hiX = (float)phyloNode.rect.getMaxX();
        nodeRange.loY = (float)phyloNode.rect.getMinY();
        nodeRange.hiY = (float)phyloNode.rect.getMaxY();
    }

    public void vertexAdded(GraphVertexChangeEvent graphVertexChangeEvent) {
        this.needsLayout = true;
    }

    public void vertexRemoved(GraphVertexChangeEvent graphVertexChangeEvent) {
        this.needsLayout = true;
    }

    public void setLayout(LayoutBase layoutBase) {
        this.oldLayout = this.treeLayout;
        this.treeLayout = layoutBase;
        this.layoutTrigger();
        this.framesToSwitch = (int)PhyloWidget.cfg.animationFrames / 2;
    }

    public LayoutBase getTreeLayout() {
        return this.treeLayout;
    }

    public void forceLayout() {
        this.needsLayout = true;
        this.layoutTrigger();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ZOrderComparator
    implements Comparator<PhyloNode> {
        ZOrderComparator() {
        }

        @Override
        public int compare(PhyloNode phyloNode, PhyloNode phyloNode2) {
            int n;
            String string = phyloNode.getAnnotation("PW_Z");
            String string2 = phyloNode2.getAnnotation("PW_Z");
            if (string == null) {
                return -1;
            }
            if (string2 == null) {
                return 1;
            }
            int n2 = Integer.parseInt(string);
            if (n2 > (n = Integer.parseInt(string2))) {
                return 1;
            }
            if (n2 == n) {
                return 0;
            }
            return -1;
        }
    }
}

