/*
 * Decompiled with CFR 0.152.
 */
package org.phylowidget;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.andrewberman.ui.AbstractUIObject;
import org.andrewberman.ui.UIGlobals;
import org.andrewberman.ui.UIRectangle;
import org.andrewberman.ui.camera.RectMover;
import org.phylowidget.PhyloTree;
import org.phylowidget.PhyloWidget;
import org.phylowidget.RandomTreeMutator;
import org.phylowidget.render.BasicTreeRenderer;
import org.phylowidget.render.LayoutCircular;
import org.phylowidget.render.LayoutCladogram;
import org.phylowidget.render.LayoutDiagonal;
import org.phylowidget.render.LayoutUnrooted;
import org.phylowidget.render.TreeRenderer;
import org.phylowidget.render.images.ImageLoader;
import org.phylowidget.tree.RootedTree;
import org.phylowidget.tree.TreeIO;
import org.phylowidget.ui.PhyloScaleBar;
import processing.core.PApplet;

public class TreeManager
extends AbstractUIObject {
    protected PApplet p;
    public static RectMover camera;
    public static UIRectangle cameraRect;
    public static ImageLoader imageLoader;
    TreeRenderer r;
    RootedTree t;
    private RandomTreeMutator mutator;
    private boolean mutateMe;
    private Runnable runMe;
    private boolean fforwardMe;
    private PhyloScaleBar scaleBar;

    public TreeManager(PApplet pApplet) {
        this.p = pApplet;
        UIGlobals.g.event().add(this);
    }

    public void setup() {
        imageLoader = new ImageLoader();
        cameraRect = new UIRectangle(0.0f, 0.0f, 0.0f, 0.0f);
        camera = new RectMover(this.p);
        this.fillScreen();
        camera.nudgeTo(-PhyloWidget.cfg.viewportX, -PhyloWidget.cfg.viewportY);
        camera.zoomTo(PhyloWidget.cfg.viewportZoom);
        camera.fforward();
        UIGlobals.g.event().setCamera(camera);
        this.setTree(TreeIO.parseNewickString(new PhyloTree(), PhyloWidget.cfg.tree));
        this.setRenderer(new BasicTreeRenderer());
        PhyloWidget.cfg.setLayout(PhyloWidget.cfg.layout);
        try {
            PhyloTree phyloTree = (PhyloTree)this.getTree();
            phyloTree.updateNewick();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (PhyloWidget.cfg.showScaleBar) {
            this.scaleBar = new PhyloScaleBar(this.p);
        }
    }

    public void showScaleBar() {
        if (this.scaleBar == null) {
            this.scaleBar = new PhyloScaleBar(this.p);
        }
    }

    public void hideScaleBar() {
        if (this.scaleBar != null) {
            this.scaleBar.dispose();
            this.scaleBar = null;
        }
    }

    public void draw() {
        this.update();
    }

    protected void updateCameraRect() {
        cameraRect.setRect(camera.getRect());
        cameraRect.translate(this.p.width / 2, this.p.height / 2);
    }

    public void update() {
        if (camera != null && this.r != null) {
            camera.update();
            this.updateCameraRect();
            this.r.render(this.p.g, TreeManager.cameraRect.x, TreeManager.cameraRect.y, TreeManager.cameraRect.width, TreeManager.cameraRect.height, true);
            PhyloWidget.cfg.viewportX = -camera.getX();
            PhyloWidget.cfg.viewportY = -camera.getY();
            PhyloWidget.cfg.viewportZoom = camera.getZ();
        }
        if (this.mutateMe) {
            this.mutator.randomlyMutateTree();
            this.mutateMe = false;
        }
    }

    public void nodesInRange(ArrayList arrayList, Rectangle2D.Float float_) {
        this.r.nodesInRange(arrayList, float_);
    }

    public void mutateTree() {
        this.mutateMe = true;
    }

    public void startMutatingTree(int n) {
        this.mutator.stop();
        this.mutator = new RandomTreeMutator(this.t);
        this.mutator.setDelay(n);
        this.mutator.start();
    }

    public void stopMutatingTree() {
        this.mutator.stop();
    }

    public synchronized RootedTree getTree() {
        return this.t;
    }

    public TreeRenderer getRenderer() {
        return this.r;
    }

    public synchronized void setTree(String string) {
        if (this.getTree() != null) {
            TreeIO.setOldTree(this.getTree());
        }
        this.setTree(TreeIO.parseNewickString(new PhyloTree(), string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTree(RootedTree rootedTree) {
        RootedTree rootedTree2;
        if (this.t != null) {
            rootedTree2 = this.t;
            synchronized (rootedTree2) {
                this.t.dispose();
                this.t = null;
            }
        }
        this.t = rootedTree;
        if (this.getRenderer() != null) {
            this.getRenderer().setTree(rootedTree);
        }
        if (rootedTree instanceof PhyloTree) {
            rootedTree2 = (PhyloTree)rootedTree;
            ((PhyloTree)rootedTree2).setSynchronizedWithJS(true);
        }
        this.fforwardMe = true;
        this.mutator = new RandomTreeMutator(rootedTree);
    }

    public synchronized void diagonalRender() {
        this.getRenderer().setLayout(new LayoutDiagonal());
    }

    public synchronized void rectangleRender() {
        this.getRenderer().setLayout(new LayoutCladogram());
    }

    public synchronized void circleRender() {
        this.getRenderer().setLayout(new LayoutCircular());
    }

    public synchronized void unrootedRender() {
        this.getRenderer().setLayout(new LayoutUnrooted());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void setRenderer(BasicTreeRenderer basicTreeRenderer) {
        if (this.getRenderer() != null) {
            TreeRenderer treeRenderer = this.r;
            synchronized (treeRenderer) {
                this.getRenderer().dispose();
            }
        }
        this.r = basicTreeRenderer;
        if (this.getTree() != null) {
            basicTreeRenderer.setTree(this.getTree());
        }
        PhyloWidget.ui.search();
    }

    public void triggerMutation() {
        this.mutateMe = true;
    }

    public void destroy() {
        if (this.r != null) {
            this.r.dispose();
        }
        this.r = null;
        if (this.t != null) {
            this.t.dispose();
        }
        this.t = null;
        this.p = null;
        camera = null;
        cameraRect = null;
        if (imageLoader != null) {
            imageLoader.dispose();
        }
        imageLoader = null;
    }

    public void fillScreen() {
        camera.fillScreen(0.7f);
    }
}

