/*
 * Decompiled with CFR 0.152.
 */
package org.phylowidget;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Random;
import org.andrewberman.ui.UIGlobals;
import org.phylowidget.PhyloWidget;
import org.phylowidget.tree.DefaultVertex;
import org.phylowidget.tree.PhyloNode;
import org.phylowidget.tree.RootedTree;

public class RandomTreeMutator
implements Runnable {
    private RootedTree tree;
    private Thread wrapper;
    private Random random;
    private static String DEFAULT_NAME = "PhyloWidget";
    public int delay = 1000;
    public int mutations = 0;
    private ArrayList allNodes = new ArrayList(100);
    BufferedReader in;

    public RandomTreeMutator(RootedTree rootedTree) {
        this.tree = rootedTree;
        this.random = new Random(System.currentTimeMillis());
        InputStream inputStream = UIGlobals.g.getP().openStream("taxonomy.txt");
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        this.in = new BufferedReader(inputStreamReader);
        try {
            this.in.mark(10);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void start() {
        this.wrapper = new Thread(this);
        this.wrapper.setName("PhyloWidget-tree-mutator");
        this.wrapper.start();
    }

    public void run() {
        Thread thread = null;
        try {
            thread = Thread.currentThread();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        while (this.wrapper == thread) {
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            PhyloWidget.trees.triggerMutation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void randomlyMutateTree() {
        String string = DEFAULT_NAME;
        string = this.getLocalNCBITaxon();
        RootedTree rootedTree = this.tree;
        synchronized (rootedTree) {
            this.allNodes.clear();
            this.tree.getAll(this.tree.getRoot(), null, this.allNodes);
            int n = this.random.nextInt(this.allNodes.size());
            DefaultVertex defaultVertex = (DefaultVertex)this.allNodes.get(n);
            PhyloNode phyloNode = (PhyloNode)this.tree.createAndAddVertex();
            this.tree.setLabel(phyloNode, string);
            this.tree.addSisterNode(defaultVertex, phyloNode);
            this.tree.setBranchLength(defaultVertex, this.randomBranch());
            this.tree.setBranchLength(phyloNode, this.randomBranch());
            this.tree.setBranchLength(this.tree.getParentOf(phyloNode), this.randomBranch());
            ++this.mutations;
        }
    }

    private double randomBranch() {
        double d = Math.random();
        d *= 100.0;
        d = Math.round(d);
        return d /= 100.0;
    }

    private String getRemoteNCBITaxon() {
        int n = this.random.nextInt(100000);
        String string = DEFAULT_NAME;
        return string;
    }

    public String getLocalNCBITaxon() {
        String string = DEFAULT_NAME;
        try {
            this.in.reset();
            int n = this.random.nextInt(200);
            for (int i = 0; i < n; ++i) {
                string = this.in.readLine();
            }
            if (string == null) {
                string = DEFAULT_NAME;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return DEFAULT_NAME;
        }
        return string;
    }

    public void setTree(RootedTree rootedTree) {
        this.tree = rootedTree;
    }

    public void stop() {
        this.wrapper = null;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int n) {
        this.delay = n;
    }
}

