/*
 * Decompiled with CFR 0.152.
 */
package org.phylowidget;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import org.andrewberman.ui.UIGlobals;
import org.andrewberman.ui.UIUtils;
import org.andrewberman.ui.unsorted.MethodAndFieldSetter;
import org.andrewberman.ui.unsorted.StringPair;
import org.phylowidget.TreeManager;
import org.phylowidget.net.PWClipUpdater;
import org.phylowidget.net.PWTreeUpdater;
import org.phylowidget.render.DoubleBuffer;
import org.phylowidget.tree.RootedTree;
import org.phylowidget.ui.PhyloConfig;
import org.phylowidget.ui.PhyloUI;
import processing.core.PApplet;

public class PhyloWidget
extends PApplet {
    private static final long serialVersionUID = -7096870051293017660L;
    public static TreeManager trees;
    public static PhyloConfig cfg;
    public static PhyloUI ui;
    public static PhyloWidget p;
    public static float FRAMERATE;
    public static PWTreeUpdater treeUpdater;
    public static PWClipUpdater clipUpdater;
    private static String messageString;
    long time = 0L;
    DoubleBuffer dbr;
    boolean drawnOnce = false;
    Pattern parens = Pattern.compile("(.*?)\\((.*)\\)");
    ArrayList<StringPair> settingsAndMethods = new ArrayList();
    static final String METHOD_FLAG = "!!method!!";
    static int messageFrame;
    static float messageDecay;

    public PhyloWidget() {
        this.time = System.currentTimeMillis();
        p = this;
    }

    public void setup() {
        if (this.frame != null) {
            this.frame.setResizable(true);
            this.frame.setTitle("PhyloWidget Standalone");
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PhyloWidget.this.size(500, 500);
                }
            });
        } else {
            this.size(this.getWidth(), this.getHeight(), "processing.core.PGraphicsJava2D");
        }
        this.frameRate(FRAMERATE);
        new UIGlobals(this);
        cfg = new PhyloConfig();
        ui = new PhyloUI(this);
        trees = new TreeManager(this);
        treeUpdater = new PWTreeUpdater();
        clipUpdater = new PWClipUpdater();
        new Thread(){

            public void run() {
                ui.setup();
                trees.setup();
            }
        }.start();
        this.unregisterDraw(UIGlobals.g.event());
        this.clearQueues();
    }

    public void resize(int n, int n2) {
        super.resize(n, n2);
        UIUtils.setRenderingHints(this.g);
    }

    public synchronized void draw() {
        this.background(cfg.getBackgroundColor().getRGB(), 1.0f);
        if (this.drawnOnce) {
            this.clearQueues();
        }
        this.drawnOnce = true;
        UIGlobals.g.event().draw();
        if (!PhyloWidget.cfg.suppressMessages) {
            if ((float)(this.frameCount - messageFrame) > this.frameRateTarget * messageDecay) {
                messageString = "";
            }
            if (messageString.length() != 0) {
                this.drawMessage();
            }
            if (PhyloWidget.cfg.debug) {
                this.drawNumLeaves();
                this.drawFrameRate();
            }
        }
    }

    protected void clearQueues() {
        while (!this.settingsAndMethods.isEmpty()) {
            Object object;
            StringPair stringPair = this.settingsAndMethods.remove(0);
            System.out.println(stringPair);
            if (stringPair.a == METHOD_FLAG) {
                try {
                    object = stringPair.b;
                    Method method = null;
                    Object[] objectArray = new Object[]{};
                    Matcher matcher = this.parens.matcher((CharSequence)object);
                    boolean bl = false;
                    while (matcher.find()) {
                        bl = true;
                        object = matcher.group(1);
                        objectArray = new Object[]{matcher.group(2)};
                        System.out.println((String)object + "  " + objectArray);
                        method = PhyloUI.class.getMethod((String)object, String.class);
                        method.invoke((Object)ui, objectArray);
                    }
                    if (bl) continue;
                    method = PhyloUI.class.getMethod((String)object, new Class[0]);
                    method.invoke((Object)ui, new Object[0]);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                continue;
            }
            object = new HashMap();
            ((HashMap)object).put(stringPair.a, stringPair.b);
            MethodAndFieldSetter.setMethodsAndFields(cfg, (Map<String, String>)object);
        }
    }

    public void stop() {
        super.stop();
    }

    public synchronized void destroy() {
        this.noLoop();
        super.destroy();
        if (trees != null) {
            trees.destroy();
        }
        trees = null;
        cfg.destroy();
        cfg = null;
        ui.destroy();
        ui = null;
        treeUpdater = null;
        clipUpdater = null;
        UIGlobals.g.destroyGlobals();
    }

    protected void drawFrameRate() {
        this.textAlign(37);
        this.textFont(UIGlobals.g.getPFont());
        this.textSize(10.0f);
        this.fill(255.0f, 0.0f, 0.0f);
        this.text(String.valueOf((double)PhyloWidget.round((float)(this.frameRate * 10.0f)) / 10.0), this.width - 40, this.height - 10);
    }

    protected void drawNumLeaves() {
        RootedTree rootedTree = trees.getTree();
        if (rootedTree == null) {
            return;
        }
        int n = rootedTree.getNumEnclosedLeaves(rootedTree.getRoot());
        String string = String.valueOf(n);
        this.textAlign(37);
        this.textFont(UIGlobals.g.getPFont());
        this.textSize(10.0f);
        this.fill(255.0f, 0.0f, 0.0f);
        this.text(string, this.width - 100, this.height - 10);
    }

    protected void drawMessage() {
        this.textAlign(37);
        this.textFont(UIGlobals.g.getPFont());
        this.textSize(10.0f);
        float f = this.textWidth(messageString);
        this.fill(255.0f, 255.0f, 255.0f);
        this.stroke(255.0f, 255.0f, 255.0f);
        this.strokeWeight(3.0f);
        this.rect(5.0f, this.height - 20, f, 12.0f);
        this.fill(255.0f, 0.0f, 0.0f);
        this.text(messageString, 5.0f, this.height - 10);
    }

    public static void setMessage(String string) {
        messageString = string;
        if (p != null) {
            messageFrame = PhyloWidget.p.frameCount;
        }
    }

    public boolean jsTest() {
        return true;
    }

    public void close() {
        if (this.frame != null) {
            this.frame.setVisible(false);
            this.destroy();
        }
    }

    public boolean updateTree(String string) {
        treeUpdater.triggerUpdate(string);
        return true;
    }

    public boolean updateClip(String string) {
        clipUpdater.triggerUpdate(string);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void changeSetting(String string, String string2) {
        if (PhyloWidget.cfg.debug) {
            System.out.println(string + "\t" + string2);
        }
        ArrayList<StringPair> arrayList = this.settingsAndMethods;
        synchronized (arrayList) {
            this.settingsAndMethods.add(new StringPair(string, string2));
        }
    }

    public synchronized void callMethod(String string) {
        this.settingsAndMethods.add(new StringPair(METHOD_FLAG, string));
    }

    public void keyPressed() {
        super.keyPressed();
        if (this.key == '\u001b') {
            this.key = '\u0000';
        }
    }

    public String getAppletInfo() {
        return "PhyloWidget";
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"org.phylowidget.PhyloWidget"});
    }

    static {
        cfg = new PhyloConfig();
        FRAMERATE = 60.0f;
        messageString = new String();
        messageDecay = 15.0f;
    }
}

