/*
 * Decompiled with CFR 0.152.
 */
package org.phylowidget;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.andrewberman.ui.unsorted.SearchIndex;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.phylowidget.PhyloWidget;
import org.phylowidget.net.JSTreeUpdater;
import org.phylowidget.tree.CachedRootedTree;
import org.phylowidget.tree.PhyloNode;
import org.phylowidget.ui.NodeUncollapser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhyloTree
extends CachedRootedTree<PhyloNode, DefaultWeightedEdge> {
    private static final long serialVersionUID = 1L;
    private JSTreeUpdater updater;
    private SearchIndex<PhyloNode> index = new SearchIndex();
    private boolean synchronizedWithJS;
    public PhyloNode hoveredNode;

    public PhyloTree() {
        super(DefaultWeightedEdge.class);
        if (PhyloWidget.cfg != null) {
            this.setEnforceUniqueLabels(PhyloWidget.cfg.enforceUniqueLabels);
        }
    }

    @Override
    public void uncollapseNode(PhyloNode phyloNode) {
        phyloNode.clearAnnotation("collapse");
        List<PhyloNode> list = this.getAllNodes(phyloNode);
        for (PhyloNode phyloNode2 : list) {
            phyloNode2.setLayoutX(phyloNode.getLayoutX());
            phyloNode2.setLayoutY(phyloNode.getLayoutY());
            phyloNode2.setX(phyloNode.getX());
            phyloNode2.setY(phyloNode.getY());
            phyloNode2.fforward();
        }
        this.modPlus();
    }

    @Override
    public void collapseNode(PhyloNode phyloNode) {
        phyloNode.setAnnotation("collapse", "yes");
        new NodeUncollapser(PhyloWidget.p, phyloNode);
        this.modPlus();
    }

    @Override
    public boolean isCollapsed(PhyloNode phyloNode) {
        String string = phyloNode.getAnnotation("collapse");
        return string != null && PhyloNode.parseTruth(string);
    }

    public void setHoveredNode(PhyloNode phyloNode) {
        this.hoveredNode = phyloNode;
    }

    @Override
    public PhyloNode createVertex() {
        return new PhyloNode();
    }

    @Override
    public void flipChildren(PhyloNode phyloNode) {
        super.flipChildren(phyloNode);
    }

    @Override
    public void reverseSubtree(PhyloNode phyloNode) {
        super.reverseSubtree(phyloNode);
    }

    @Override
    public void setLabel(Object object, String string) {
        this.index.remove((PhyloNode)object);
        super.setLabel(object, string);
        this.index.add((PhyloNode)object);
    }

    public void updateNewick() {
        if (this.isValid() && this.synchronizedWithJS) {
            this.updater.triggerUpdate(this);
        }
    }

    void removeFound() {
        ArrayList arrayList = new ArrayList();
        this.getAll(this.getRoot(), null, arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            PhyloNode phyloNode = (PhyloNode)arrayList.get(i);
            phyloNode.found = false;
        }
    }

    public void markNodesAsFound(List<PhyloNode> list) {
        this.removeFound();
        Iterator<PhyloNode> iterator = list.iterator();
        while (iterator.hasNext()) {
            PhyloNode phyloNode;
            PhyloNode phyloNode2 = phyloNode = iterator.next();
            while (phyloNode2 != null) {
                phyloNode2.found = true;
                phyloNode2 = this.getParentOf(phyloNode2);
            }
        }
    }

    public void searchAndMarkFound(String string) {
        List<PhyloNode> list = this.search(string);
        this.markNodesAsFound(list);
    }

    public List<PhyloNode> search(String string) {
        String[] stringArray = string.split(";");
        ArrayList<PhyloNode> arrayList = new ArrayList<PhyloNode>();
        for (String string2 : stringArray) {
            arrayList.addAll(this.index.search(string2));
        }
        return arrayList;
    }

    @Override
    public boolean removeVertex(PhyloNode phyloNode) {
        boolean bl = super.removeVertex(phyloNode);
        if (bl) {
            this.index.remove(phyloNode);
        }
        return bl;
    }

    @Override
    public boolean addVertex(PhyloNode phyloNode) {
        boolean bl = super.addVertex(phyloNode);
        if (bl) {
            this.index.add(phyloNode);
        }
        return bl;
    }

    @Override
    public void modPlus() {
        super.modPlus();
        this.updateNewick();
    }

    public boolean isSynchronizedWithJS() {
        return this.synchronizedWithJS;
    }

    public void setSynchronizedWithJS(boolean bl) {
        this.synchronizedWithJS = bl;
        if (bl && this.updater == null) {
            this.updater = new JSTreeUpdater();
        }
    }
}

