/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.traverse;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.event.ConnectedComponentTraversalEvent;
import org.jgrapht.event.EdgeTraversalEvent;
import org.jgrapht.event.VertexTraversalEvent;
import org.jgrapht.traverse.AbstractGraphIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CrossComponentIterator<V, E, D>
extends AbstractGraphIterator<V, E> {
    private static final int CCS_BEFORE_COMPONENT = 1;
    private static final int CCS_WITHIN_COMPONENT = 2;
    private static final int CCS_AFTER_COMPONENT = 3;
    private final ConnectedComponentTraversalEvent ccFinishedEvent = new ConnectedComponentTraversalEvent(this, 32);
    private final ConnectedComponentTraversalEvent ccStartedEvent = new ConnectedComponentTraversalEvent(this, 31);
    private FlyweightEdgeEvent<V, E> reusableEdgeEvent;
    private FlyweightVertexEvent<V> reusableVertexEvent;
    private Iterator<V> vertexIterator = null;
    private Map<V, D> seen = new HashMap<V, D>();
    private V startVertex;
    private Specifics<V, E> specifics;
    private final Graph<V, E> graph;
    private int state = 1;

    public CrossComponentIterator(Graph<V, E> graph, V v) {
        if (graph == null) {
            throw new IllegalArgumentException("graph must not be null");
        }
        this.graph = graph;
        this.specifics = CrossComponentIterator.createGraphSpecifics(graph);
        this.vertexIterator = graph.vertexSet().iterator();
        this.setCrossComponentTraversal(v == null);
        this.reusableEdgeEvent = new FlyweightEdgeEvent((Object)this, null);
        this.reusableVertexEvent = new FlyweightVertexEvent<Object>((Object)this, null);
        if (v == null) {
            this.startVertex = this.vertexIterator.hasNext() ? this.vertexIterator.next() : null;
        } else if (graph.containsVertex(v)) {
            this.startVertex = v;
        } else {
            throw new IllegalArgumentException("graph must contain the start vertex");
        }
    }

    public Graph<V, E> getGraph() {
        return this.graph;
    }

    @Override
    public boolean hasNext() {
        if (this.startVertex != null) {
            this.encounterStartVertex();
        }
        if (this.isConnectedComponentExhausted()) {
            if (this.state == 2) {
                this.state = 3;
                this.fireConnectedComponentFinished(this.ccFinishedEvent);
            }
            if (this.isCrossComponentTraversal()) {
                while (this.vertexIterator.hasNext()) {
                    V v = this.vertexIterator.next();
                    if (this.isSeenVertex(v)) continue;
                    this.encounterVertex(v, null);
                    this.state = 1;
                    return true;
                }
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public V next() {
        if (this.startVertex != null) {
            this.encounterStartVertex();
        }
        if (this.hasNext()) {
            if (this.state == 1) {
                this.state = 2;
                this.fireConnectedComponentStarted(this.ccStartedEvent);
            }
            V v = null;
            while (v == null) {
                v = this.provideNextVertex();
            }
            this.fireVertexTraversed(this.createVertexTraversalEvent(v));
            this.addUnseenChildrenOf(v);
            return v;
        }
        throw new NoSuchElementException();
    }

    protected abstract boolean isConnectedComponentExhausted();

    protected abstract void encounterVertex(V var1, E var2);

    protected abstract V provideNextVertex();

    protected D getSeenData(V v) {
        return this.seen.get(v);
    }

    protected boolean isSeenVertex(Object object) {
        return this.seen.containsKey(object);
    }

    protected abstract void encounterVertexAgain(V var1, E var2);

    protected D putSeenData(V v, D d) {
        return this.seen.put(v, d);
    }

    protected void finishVertex(V v) {
        this.fireVertexFinished(this.createVertexTraversalEvent(v));
    }

    static <V, E> Specifics<V, E> createGraphSpecifics(Graph<V, E> graph) {
        if (graph instanceof DirectedGraph) {
            return new DirectedSpecifics((DirectedGraph)graph);
        }
        return new UndirectedSpecifics<V, E>(graph);
    }

    private void addUnseenChildrenOf(V v) {
        for (E e : this.specifics.edgesOf(v)) {
            this.fireEdgeTraversed(this.createEdgeTraversalEvent(e));
            V v2 = Graphs.getOppositeVertex(this.graph, e, v);
            if (this.isSeenVertex(v2)) {
                this.encounterVertexAgain(v2, e);
                continue;
            }
            this.encounterVertex(v2, e);
        }
    }

    private EdgeTraversalEvent<V, E> createEdgeTraversalEvent(E e) {
        if (this.isReuseEvents()) {
            this.reusableEdgeEvent.setEdge(e);
            return this.reusableEdgeEvent;
        }
        return new EdgeTraversalEvent(this, e);
    }

    private VertexTraversalEvent<V> createVertexTraversalEvent(V v) {
        if (this.isReuseEvents()) {
            this.reusableVertexEvent.setVertex(v);
            return this.reusableVertexEvent;
        }
        return new VertexTraversalEvent<V>(this, v);
    }

    private void encounterStartVertex() {
        this.encounterVertex(this.startVertex, null);
        this.startVertex = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UndirectedSpecifics<VV, EE>
    extends Specifics<VV, EE> {
        private Graph<VV, EE> graph;

        public UndirectedSpecifics(Graph<VV, EE> graph) {
            this.graph = graph;
        }

        @Override
        public Set<EE> edgesOf(VV VV) {
            return this.graph.edgesOf(VV);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DirectedSpecifics<VV, EE>
    extends Specifics<VV, EE> {
        private DirectedGraph<VV, EE> graph;

        public DirectedSpecifics(DirectedGraph<VV, EE> directedGraph) {
            this.graph = directedGraph;
        }

        @Override
        public Set<? extends EE> edgesOf(VV VV) {
            return this.graph.outgoingEdgesOf(VV);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FlyweightVertexEvent<VV>
    extends VertexTraversalEvent<VV> {
        private static final long serialVersionUID = 3834024753848399924L;

        public FlyweightVertexEvent(Object object, VV VV) {
            super(object, VV);
        }

        protected void setVertex(VV VV) {
            this.vertex = VV;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FlyweightEdgeEvent<VV, localE>
    extends EdgeTraversalEvent<VV, localE> {
        private static final long serialVersionUID = 4051327833765000755L;

        public FlyweightEdgeEvent(Object object, localE localE) {
            super(object, localE);
        }

        protected void setEdge(localE localE) {
            this.edge = localE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class Specifics<VV, EE> {
        Specifics() {
        }

        public abstract Set<? extends EE> edgesOf(VV var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface SimpleContainer<T> {
        public boolean isEmpty();

        public void add(T var1);

        public T remove();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum VisitColor {
        WHITE,
        GRAY,
        BLACK;

    }
}

