/*
 * Decompiled with CFR 0.152.
 */
package org.andrewberman.ui.unsorted;

import com.sun.corba.se.spi.orb.StringPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchIndex<T> {
    HashMap<String, ArrayList<T>> map = new HashMap();
    Collection<T> refList;
    int k = 3;

    public void add(T t) {
        this.insertRemove(t, true);
    }

    private void insertRemove(T t, boolean bl) {
        String string = t.toString().toLowerCase();
        if (string.length() < this.k) {
            // empty if block
        }
        for (int i = 0; i < string.length(); ++i) {
            for (int j = 1; j <= this.k && i + j <= string.length(); ++j) {
                String string2 = string.substring(i, i + j);
                ArrayList<Object> arrayList = this.map.get(string2);
                if (arrayList == null) {
                    if (!bl) continue;
                    arrayList = new ArrayList();
                    this.map.put(string2, arrayList);
                }
                if (bl) {
                    arrayList.add(t);
                    continue;
                }
                if (arrayList.size() == 1) {
                    this.map.remove(string2);
                    continue;
                }
                arrayList.remove(t);
            }
        }
    }

    public void remove(T t) {
        this.insertRemove(t, false);
    }

    public Collection<T> search(String string) {
        string = string.toLowerCase();
        HashSet<T> hashSet = new HashSet<T>();
        int n = Math.min(string.length(), this.k);
        for (int i = 0; i < string.length() - n + 1; ++i) {
            String string2 = string.substring(i, i + n);
            ArrayList<T> arrayList2 = this.map.get(string2);
            if (arrayList2 == null) continue;
            hashSet.addAll(arrayList2);
        }
        ArrayList arrayList = new ArrayList();
        for (Object e : hashSet) {
            String string2 = e.toString().toLowerCase();
            if (!string2.contains(string)) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    public String toString() {
        return this.map.toString();
    }

    public static void main(String[] stringArray) {
        SearchIndex<StrangePair> searchIndex = new SearchIndex<StrangePair>();
        searchIndex.add(new StrangePair("Hello", "World!"));
        searchIndex.add(new StrangePair("Hell no!", "Whirled!"));
        searchIndex.add(new StrangePair("Lonely Hello, there!", "Get a life!"));
        StrangePair strangePair = new StrangePair("Greg Rocks!", "You got it.");
        searchIndex.add(strangePair);
        System.out.println(searchIndex.search("o"));
    }

    static class StrangePair
    extends StringPair {
        public StrangePair(String string, String string2) {
            super(string, string2);
        }

        public String toString() {
            return this.getFirst();
        }
    }
}

