/*
 * Decompiled with CFR 0.152.
 */
package org.andrewberman.ui.unsorted;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public class DelayedAction {
    private boolean updating;
    boolean threaded;
    Timer timer;

    public void trigger(int n) {
        if (this.timer != null) {
            this.timer.stop();
            this.timer.setInitialDelay(n);
            this.timer.restart();
            return;
        }
        this.timer = new Timer(n, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!DelayedAction.this.updating) {
                    DelayedAction.this.timer = null;
                    DelayedAction.this.doUpdate();
                } else {
                    DelayedAction.this.timer.start();
                }
            }
        });
        this.timer.setRepeats(false);
        this.timer.start();
    }

    private void doUpdate() {
        if (this.threaded) {
            new Thread(){

                public void run() {
                    DelayedAction.this.updating = true;
                    this.run();
                    DelayedAction.this.updating = false;
                }
            }.start();
        } else {
            this.updating = true;
            this.run();
            this.updating = false;
        }
    }

    protected void run() {
    }

    public boolean isThreaded() {
        return this.threaded;
    }

    public void setThreaded(boolean bl) {
        this.threaded = bl;
    }
}

