/*
 * Decompiled with CFR 0.152.
 */
package org.andrewberman.ui.tween;

import org.andrewberman.ui.tween.TweenFunction;
import org.andrewberman.ui.tween.TweenListener;

public class Tween {
    TweenListener listener;
    TweenFunction function;
    public static final int STARTED = 0;
    public static final int UPDATED = 1;
    public static final int STOPPED = 2;
    public static final int FINISHED = 3;
    public static final int REWOUND = 4;
    public static final int FFORWARDED = 5;
    public static final int IN = 0;
    public static final int OUT = 1;
    public static final int INOUT = 2;
    boolean isTweening;
    int tweenType;
    float position;
    float time;
    float begin;
    float change;
    float duration;

    public Tween(TweenListener tweenListener, TweenFunction tweenFunction, int n) {
        this.listener = tweenListener;
        this.function = tweenFunction;
        this.tweenType = n;
    }

    public Tween(TweenListener tweenListener, TweenFunction tweenFunction, int n, float f, float f2, float f3) {
        this.listener = tweenListener;
        this.function = tweenFunction;
        this.tweenType = n;
        this.begin = f;
        this.position = f;
        this.change = f2 - f;
        this.duration = f3;
        this.start();
    }

    public float getTime() {
        return this.time;
    }

    public float getPosition() {
        return this.position;
    }

    public float getDuration() {
        return this.duration;
    }

    public float getFinish() {
        return this.begin + this.change;
    }

    public float getChange() {
        return this.change;
    }

    public float getBegin() {
        return this.begin;
    }

    public void rewind() {
        this.time = 0.0f;
        this.position = this.begin;
        this.dispatchEvent(4);
    }

    public void fforward() {
        this.time = this.duration;
        this.position = this.getFinish();
        this.dispatchEvent(5);
    }

    public void start() {
        this.isTweening = true;
        this.dispatchEvent(0);
    }

    public void stop() {
        this.isTweening = false;
        this.dispatchEvent(2);
    }

    public void continueTo(float f) {
        if (f == this.begin + this.change) {
            return;
        }
        if (!this.isTweening) {
            this.start();
        }
        this.continueTo(f, this.duration);
    }

    public void continueTo(float f, float f2) {
        this.begin = this.position;
        this.change = f - this.begin;
        this.time = 0.0f;
        this.duration = f2;
        this.start();
    }

    public void restart(float f, float f2, float f3) {
        this.begin = f;
        this.change = f2 - f;
        this.time = 0.0f;
        this.duration = f3;
        this.start();
    }

    public void yoyo() {
        this.continueTo(this.begin, this.time);
    }

    public final void dispatchEvent(int n) {
        if (this.listener != null) {
            this.listener.tweenEvent(this, n);
        }
    }

    public float update() {
        if (this.isTweening) {
            if (this.function.isFinished(this.time, this.position, this.begin, this.change, this.duration)) {
                this.fforward();
                this.stop();
                this.dispatchEvent(3);
            } else {
                this.time += 1.0f;
                switch (this.tweenType) {
                    case 0: {
                        this.position = this.function.easeIn(this.time, this.position, this.begin, this.change, this.duration);
                        break;
                    }
                    case 1: {
                        this.position = this.function.easeOut(this.time, this.position, this.begin, this.change, this.duration);
                        break;
                    }
                    case 2: {
                        this.position = this.function.easeInOut(this.time, this.position, this.begin, this.change, this.duration);
                    }
                }
                this.dispatchEvent(1);
            }
        }
        return this.position;
    }

    public TweenFunction getFunction() {
        return this.function;
    }

    public void setFunction(TweenFunction tweenFunction) {
        this.function = tweenFunction;
    }

    public boolean isTweening() {
        return this.isTweening;
    }
}

