/*
 * Decompiled with CFR 0.152.
 */
package org.andrewberman.ui.tools;

import java.awt.Cursor;
import java.awt.Robot;
import java.awt.event.MouseEvent;
import org.andrewberman.ui.Point;
import org.andrewberman.ui.Shortcut;
import org.andrewberman.ui.UIUtils;
import org.andrewberman.ui.camera.Camera;
import org.andrewberman.ui.tools.Tool;
import org.andrewberman.ui.tween.Tween;
import org.andrewberman.ui.tween.TweenFriction;
import processing.core.PApplet;

public class Zoom
extends Tool {
    Cursor zoomCursor;
    float targetX;
    float targetY;
    double downZoom;
    double zoomFactor;
    float downCameraX;
    float downCameraY;
    Tween zoomTween;
    Robot r;

    public Zoom(PApplet pApplet) {
        super(pApplet);
        this.shortcut = new Shortcut("z");
        this.zoomTween = new Tween(null, TweenFriction.tween(0.3f), 1, 1.0f, 1.0f, 30.0f);
    }

    public void draw() {
        this.zoomTween.update();
        if (this.mouseDragging) {
            float f = this.downPoint.y - this.curPoint.y;
            if (this.controlPressed) {
                this.zoomFactor *= Math.exp(f / 100.0f / 10.0f);
                this.p.stroke(255.0f, 0.0f, 0.0f, 150.0f);
                this.p.strokeWeight(3.0f);
                this.p.line(this.downPoint.x, this.curPoint.y, this.downPoint.x, this.downPoint.y);
            } else {
                this.zoomFactor = this.downZoom * Math.exp(f / 100.0f);
                float f2 = this.zoomTween.getPosition() / (float)this.downZoom;
                this.p.stroke(255.0f, 0.0f, 0.0f, 150.0f);
                this.p.strokeWeight(1.0f * f2);
                this.p.noFill();
                this.p.ellipse(this.downPoint.x, this.downPoint.y, f2 * 20.0f, f2 * 20.0f);
            }
            this.zoomTween.continueTo((float)this.zoomFactor);
        }
        if (this.zoomTween.isTweening()) {
            double d = (double)this.targetX / this.downZoom;
            double d2 = (double)this.targetY / this.downZoom;
            double d3 = this.downZoom / (double)this.zoomTween.getPosition();
            float f = (float)((double)this.downCameraX + d - d * d3);
            float f3 = (float)((double)this.downCameraY + d2 - d2 * d3);
            Camera camera = this.getCamera();
            camera.zoomTo(this.zoomTween.getPosition());
            camera.nudgeTo(f, f3);
            camera.fforward();
        }
    }

    public void enter() {
        super.enter();
        this.reset();
    }

    void pressReset(MouseEvent mouseEvent, Point point, Point point2) {
        this.reset();
    }

    void reset() {
        this.controlPressed = false;
        this.downPoint = (Point)this.curPoint.clone();
        this.targetX = this.downPoint.x - (float)(this.p.width / 2);
        this.targetY = this.downPoint.y - (float)(this.p.height / 2);
        this.downCameraX = this.getCamera().getX();
        this.downCameraY = this.getCamera().getY();
        this.downZoom = this.getCamera().getZ();
        this.zoomFactor = this.getCamera().getZ();
        this.zoomTween.continueTo((float)this.zoomFactor);
        this.zoomTween.fforward();
    }

    public Cursor getCursor() {
        if (this.zoomCursor == null) {
            this.zoomCursor = UIUtils.createCursor(this.p, "cursors/zoom2.png", 6, 6);
        }
        return this.zoomCursor;
    }

    public boolean respondToOtherEvents() {
        return false;
    }
}

