/*
 * Decompiled with CFR 0.152.
 */
package org.andrewberman.ui.tools;

import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Set;
import org.andrewberman.ui.Point;
import org.andrewberman.ui.Shortcut;
import org.andrewberman.ui.UIGlobals;
import org.andrewberman.ui.UIUtils;
import org.andrewberman.ui.menu.ToolDock;
import org.andrewberman.ui.tools.Scroll;
import org.andrewberman.ui.tools.Tool;
import processing.core.PApplet;

public class ToolManager {
    PApplet p;
    Tool curTool;
    ToolDock toolDock;
    HashMap<String, Tool> tools;
    Tool scrollTool;
    Tool baseTool;

    public ToolManager(PApplet pApplet) {
        this.p = pApplet;
        this.tools = new HashMap();
        UIGlobals.g.event().setToolManager(this);
    }

    public void setToolDock(ToolDock toolDock) {
        this.toolDock = toolDock;
    }

    public Tool createTool(String string, String string2) {
        try {
            String string3 = Tool.class.getPackage().getName();
            Class<?> clazz = Class.forName(string3 + "." + string2);
            Constructor<?> constructor = clazz.getConstructor(PApplet.class);
            Object obj = constructor.newInstance(this.p);
            Tool tool = (Tool)obj;
            if (tool instanceof Scroll) {
                this.scrollTool = tool;
            }
            this.tools.put(string, tool);
            return tool;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public Tool getTool(String string) {
        return this.tools.get(string);
    }

    void switchTool(Tool tool) {
        if (tool == this.curTool) {
            return;
        }
        if (this.curTool != null) {
            this.curTool.exit();
        }
        this.curTool = tool;
        this.curTool.setCamera(UIGlobals.g.event().toolCamera);
        this.curTool.enter();
        UIUtils.setBaseCursor(this.p, this.curTool.getCursor());
    }

    public void switchTool(String string) {
        if (this.toolDock != null) {
            this.toolDock.updateActiveTool(string);
        }
        this.switchTool(this.tools.get(string));
    }

    public Tool getCurrentTool() {
        return this.curTool;
    }

    public void draw() {
        if (this.curTool != null) {
            this.curTool.draw();
        }
    }

    public void focusEvent(FocusEvent focusEvent) {
        if (this.curTool != null) {
            this.curTool.focusEvent(focusEvent);
        }
    }

    public void keyEvent(KeyEvent keyEvent) {
        this.checkToolShortcuts(keyEvent);
        if (this.curTool != null) {
            this.curTool.keyEvent(keyEvent);
        }
        if (keyEvent.getKeyCode() == 32) {
            if (keyEvent.getID() == 401) {
                this.tempScroll(true);
            } else if (keyEvent.getID() == 402) {
                this.tempScroll(false);
            }
        }
    }

    void tempScroll(boolean bl) {
        if (bl) {
            if (this.curTool != this.scrollTool && this.scrollTool != null) {
                this.baseTool = this.curTool;
                this.switchTool(this.scrollTool);
            }
        } else if (this.curTool == this.scrollTool && this.scrollTool != null && this.baseTool != null) {
            this.switchTool(this.baseTool);
        }
    }

    public void checkToolShortcuts(KeyEvent keyEvent) {
        Object object = UIGlobals.g.focus().getFocusedObject();
        if (object != null && object != this) {
            return;
        }
        if (keyEvent.getID() != 401) {
            return;
        }
        Object var3_3 = null;
        Set<String> set = this.tools.keySet();
        for (String string : set) {
            Shortcut shortcut;
            Tool tool = this.tools.get(string);
            if (tool.getShortcut() == null || !(shortcut = tool.getShortcut()).matchesKeyEvent(keyEvent)) continue;
            this.switchTool(string);
            break;
        }
    }

    public void mouseEvent(MouseEvent mouseEvent, Point point, Point point2) {
        if (this.curTool != null) {
            this.curTool.mouseEvent(mouseEvent, point, point2);
        }
        if (mouseEvent.getButton() == 3) {
            if (mouseEvent.getID() == 501) {
                this.tempScroll(true);
            } else if (mouseEvent.getID() == 502) {
                this.tempScroll(false);
            }
        }
    }
}

