/*
 * Decompiled with CFR 0.152.
 */
package org.andrewberman.ui.tools;

import java.awt.Cursor;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import org.andrewberman.ui.AbstractUIObject;
import org.andrewberman.ui.Point;
import org.andrewberman.ui.Shortcut;
import org.andrewberman.ui.UIGlobals;
import org.andrewberman.ui.camera.Camera;
import processing.core.PApplet;

public abstract class Tool
extends AbstractUIObject {
    protected PApplet p;
    Camera camera;
    Shortcut shortcut;
    Point downPoint;
    Point curPoint;
    boolean mousePressed;
    boolean mouseDragging;
    boolean controlPressed;

    public Tool(PApplet pApplet) {
        this.p = pApplet;
        this.downPoint = new Point(0.0f, 0.0f);
        this.curPoint = new Point(0.0f, 0.0f);
    }

    public void setToggleKey(String string) {
        this.setShortcut(string);
    }

    public void setShortcut(String string) {
        this.shortcut = new Shortcut(string);
    }

    public Shortcut getShortcut() {
        return this.shortcut;
    }

    public boolean respondToOtherEvents() {
        return false;
    }

    public boolean modalFocusWhileDragging() {
        return true;
    }

    public Cursor getCursor() {
        return Cursor.getDefaultCursor();
    }

    public Camera getCamera() {
        return this.camera;
    }

    public void setCamera(Camera camera) {
        this.camera = camera;
    }

    public void enter() {
    }

    public void exit() {
    }

    void pressReset(MouseEvent mouseEvent, Point point, Point point2) {
    }

    void reset() {
    }

    public void mouseEvent(MouseEvent mouseEvent, Point point, Point point2) {
        int n = mouseEvent.getID();
        switch (n) {
            case 501: {
                this.mousePressed = true;
                this.downPoint = (Point)point.clone();
                this.pressReset(mouseEvent, point, point2);
                break;
            }
            case 502: {
                if (this.modalFocusWhileDragging()) {
                    UIGlobals.g.focus().removeFromFocus(this);
                }
                this.mousePressed = false;
                break;
            }
            case 506: {
                if (this.modalFocusWhileDragging()) {
                    UIGlobals.g.focus().setModalFocus(this);
                }
            }
            case 503: {
                this.curPoint = (Point)point.clone();
            }
        }
        if (n == 506) {
            if (!this.mousePressed) {
                this.pressReset(mouseEvent, point, point2);
                this.mousePressed = true;
            }
            this.mouseDragging = true;
        } else {
            this.mouseDragging = false;
        }
    }

    public void keyEvent(KeyEvent keyEvent) {
        super.keyEvent(keyEvent);
        if (keyEvent.isControlDown()) {
            if (!this.controlPressed) {
                this.reset();
            }
            this.controlPressed = true;
        } else {
            if (this.controlPressed) {
                this.reset();
            }
            this.controlPressed = false;
        }
    }
}

