/*
 * Decompiled with CFR 0.152.
 */
package org.andrewberman.ui.tools;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import org.andrewberman.ui.Point;
import org.andrewberman.ui.Shortcut;
import org.andrewberman.ui.UIUtils;
import org.andrewberman.ui.tools.Tool;
import org.andrewberman.ui.tween.Tween;
import org.andrewberman.ui.tween.TweenFriction;
import processing.core.PApplet;

public class Scroll
extends Tool {
    Cursor cursor;
    Cursor draggingCursor;
    float camDownX;
    float camDownY;
    Tween xTween;
    Tween yTween;

    public Scroll(PApplet pApplet) {
        super(pApplet);
        this.shortcut = new Shortcut("s");
        this.xTween = new Tween(null, TweenFriction.tween(0.8f), 1, 0.0f, 0.0f, 30.0f);
        this.yTween = new Tween(null, TweenFriction.tween(0.8f), 1, 0.0f, 0.0f, 30.0f);
    }

    public void draw() {
        this.xTween.update();
        this.yTween.update();
        if (this.xTween.isTweening() || this.yTween.isTweening()) {
            this.getCamera().nudgeTo(this.camDownX - this.xTween.getPosition(), this.camDownY - this.yTween.getPosition());
            this.getCamera().fforward();
        }
        if (this.mouseDragging) {
            float f = this.curPoint.x - this.downPoint.x;
            float f2 = this.curPoint.y - this.downPoint.y;
            f /= this.getCamera().getZ();
            f2 /= this.getCamera().getZ();
            if (this.controlPressed) {
                this.xTween.continueTo(this.xTween.getFinish() - f / 10.0f);
                this.yTween.continueTo(this.yTween.getFinish() - f2 / 10.0f);
                this.p.stroke(255.0f, 0.0f, 0.0f);
                this.p.strokeWeight(3.0f);
                this.p.line(this.downPoint.x, this.downPoint.y, this.curPoint.x, this.curPoint.y);
            } else {
                this.xTween.continueTo(f);
                this.yTween.continueTo(f2);
            }
        }
    }

    public void mouseEvent(MouseEvent mouseEvent, Point point, Point point2) {
        super.mouseEvent(mouseEvent, point, point2);
        switch (mouseEvent.getID()) {
            case 501: {
                UIUtils.setBaseCursor(this.p, this.draggingCursor);
                break;
            }
            case 502: {
                UIUtils.setBaseCursor(this.p, this.cursor);
            }
        }
    }

    void pressReset(MouseEvent mouseEvent, Point point, Point point2) {
        this.reset();
    }

    void reset() {
        super.reset();
        this.downPoint = (Point)this.curPoint.clone();
        this.camDownX = this.getCamera().getX();
        this.camDownY = this.getCamera().getY();
        this.xTween.continueTo(0.0f);
        this.yTween.continueTo(0.0f);
        this.xTween.fforward();
        this.yTween.fforward();
    }

    public void enter() {
        super.enter();
        this.controlPressed = false;
        this.xTween.continueTo(0.0f);
        this.yTween.continueTo(0.0f);
        this.xTween.fforward();
        this.yTween.fforward();
    }

    public Cursor getCursor() {
        if (this.cursor == null) {
            this.cursor = UIUtils.createCursor(this.p, "cursors/grab.png", 6, 6);
            this.draggingCursor = UIUtils.createCursor(this.p, "cursors/grabbing.png", 6, 6);
        }
        return this.cursor;
    }

    public boolean respondToOtherEvents() {
        return false;
    }
}

