/*
 * Decompiled with CFR 0.152.
 */
package org.andrewberman.ui.menu;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.andrewberman.ui.Color;
import org.andrewberman.ui.Point;
import org.andrewberman.ui.UIUtils;
import org.andrewberman.ui.menu.MenuItem;
import org.andrewberman.ui.menu.MenuUtils;
import processing.core.PFont;
import processing.core.PGraphics;

public class ToolbarItem
extends MenuItem {
    static AffineTransform at = new AffineTransform();
    static RoundRectangle2D.Float buffRoundRect = new RoundRectangle2D.Float(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    protected static final int LAYOUT_BELOW = 0;
    protected static final int LAYOUT_LEFT = 2;
    protected static final int LAYOUT_RIGHT = 1;
    static RoundRectangle2D.Float roundRect = new RoundRectangle2D.Float(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    static final float shortcutTextSize = 0.75f;
    static Area tri;
    static float triWidth;
    boolean drawChildrenTriangle;
    protected int layoutMode;
    Rectangle2D.Float subItemRect = new Rectangle2D.Float();
    float tWidth;
    float shortcutWidth;

    protected void calcPreferredSize() {
        super.calcPreferredSize();
        PFont pFont = this.getFont();
        float f = this.getFontSize();
        float f2 = this.getPadX();
        float f3 = this.getPadY();
        this.tWidth = UIUtils.getTextWidth(this.menu.canvas.g, pFont, f, this.getName(), true);
        float f4 = UIUtils.getTextHeight(this.menu.canvas.g, pFont, f, "XYZ", true);
        float f5 = 0.0f;
        if (this.drawChildrenTriangle && this.items.size() > 0 && this.layoutMode != 0) {
            Area area;
            at = AffineTransform.getScaleInstance(f4 / 2.0f, f4 / 2.0f);
            Area area2 = (Area)this.getStyle().get("subTriangle");
            tri = area = area2.createTransformedArea(at);
            triWidth = (float)area.getBounds2D().getWidth();
            f5 = triWidth + f2;
        }
        this.shortcutWidth = 0.0f;
        if (this.shortcut != null) {
            this.shortcutWidth = f2 + UIUtils.getTextWidth((PGraphics)this.menu.buff, pFont, f * 0.75f, this.shortcut.label, true);
        }
        this.setWidth(this.tWidth + f5 + this.shortcutWidth + 2.0f * f2);
        this.setHeight(f4 + 2.0f * f3);
    }

    protected boolean containsPoint(Point point) {
        float f = this.getStyle().getF("f.roundOff");
        buffRoundRect.setRoundRect(this.x, this.y, this.width, this.height, f, f);
        return buffRoundRect.contains(point);
    }

    public MenuItem create(String string) {
        ToolbarItem toolbarItem = new ToolbarItem();
        toolbarItem.setLayoutMode(1);
        toolbarItem.drawChildrenTriangle = true;
        toolbarItem.setName(string);
        return toolbarItem;
    }

    protected void drawBefore() {
        if (this.isOpen() && this.items.size() > 0) {
            MenuUtils.drawBackgroundRoundRect(this, this.subItemRect.x, this.subItemRect.y, this.subItemRect.width, this.subItemRect.height);
        }
    }

    protected void drawMyself() {
        Object object;
        float f = this.getStyle().getF("f.roundOff");
        Color color = this.getStrokeColor();
        Stroke stroke = this.getStroke();
        float f2 = this.getStyle().getF("f.padX");
        float f3 = this.getStyle().getF("f.padY");
        roundRect.setRoundRect(this.x, this.y, this.width, this.height, f, f);
        Graphics2D graphics2D = this.menu.buff.g2;
        if (this.isOpen() && this.parent == this.menu) {
            graphics2D.setPaint(this.getStyle().getGradient(2, this.y, this.y + this.height));
        } else if (!this.hasChildren() && this.getState() == 2) {
            graphics2D.setPaint(this.getStyle().getGradient(2, this.y, this.y + this.height));
        } else {
            graphics2D.setPaint(this.getStyle().getGradient(this.getState(), this.y, this.y + this.height));
        }
        if (this.shouldPerformFill()) {
            graphics2D.fill(roundRect);
            graphics2D.setPaint(color);
            graphics2D.setStroke(stroke);
            graphics2D.draw(roundRect);
        }
        float f4 = this.x + f2;
        MenuUtils.drawLeftText(this, this.getName(), f4);
        f4 += this.tWidth;
        if (this.shortcut != null) {
            object = this.getStyle().getFont("font");
            float f5 = this.getStyle().getF("f.fontSize");
            float f6 = this.getX() + this.getWidth();
            f4 = f6 - this.shortcutWidth;
            float f7 = f5 * 0.75f;
            float f8 = UIUtils.getTextDescent((PGraphics)this.menu.buff, object, f7, true);
            graphics2D.setFont(object.getFont().deriveFont(f7));
            graphics2D.setPaint(color.brighter(100.0));
            float f9 = UIUtils.getTextHeight(this.menu.canvas.g, object, f7, this.shortcut.label, true);
            float f10 = (this.height - f9) / 2.0f + f8;
            graphics2D.drawString(this.shortcut.label, f4, this.y + (f10 += f9 / 2.0f));
        }
        f4 += this.shortcutWidth;
        if (this.drawChildrenTriangle && this.items.size() > 0) {
            if (this.layoutMode == 0 && this.getState() != 0 && !this.isOpen()) {
                f4 = this.x + this.width / 2.0f;
                at.setToIdentity();
                at.translate(f4, this.y + this.height + f3 / 2.0f);
                at.rotate(1.5707963705062866);
                object = tri.createTransformedArea(at);
                graphics2D.setPaint(color);
                graphics2D.fill((Shape)object);
            } else if (this.layoutMode != 0) {
                f4 = this.x + this.width - triWidth - f2;
                at.setToIdentity();
                at.translate(f4, this.y + this.height / 2.0f);
                object = tri.createTransformedArea(at);
                graphics2D.setPaint(color);
                graphics2D.fill((Shape)object);
            }
        }
    }

    protected void getRect(Rectangle2D.Float float_, Rectangle2D.Float float_2) {
        float_2.setFrame(this.x, this.y, this.width, this.height);
        Rectangle2D.union(float_, float_2, float_);
        super.getRect(float_, float_2);
    }

    protected void itemMouseEvent(MouseEvent mouseEvent, Point point) {
        super.itemMouseEvent(mouseEvent, point);
    }

    public synchronized void layout() {
        if (this.menu == null) {
            return;
        }
        float f = this.getPadX();
        float f2 = this.getPadY();
        float f3 = 0.0f;
        float f4 = 0.0f;
        switch (this.layoutMode) {
            case 0: {
                f3 = this.x - f2;
                f4 = this.y + this.height;
                break;
            }
            default: {
                f3 = this.x + this.width;
                f4 = this.y - f;
            }
        }
        this.subItemRect.x = f3;
        this.subItemRect.y = f4;
        f3 += f;
        f4 += f2;
        for (int i = 0; i < this.items.size(); ++i) {
            MenuItem menuItem = (MenuItem)this.items.get(i);
            menuItem.calcPreferredSize();
        }
        float f5 = this.getMaxWidth();
        float f6 = this.getMaxHeight();
        for (int i = 0; i < this.items.size(); ++i) {
            MenuItem menuItem = (MenuItem)this.items.get(i);
            if (menuItem.isHidden()) continue;
            menuItem.setPosition(f3, f4);
            menuItem.setSize(f5, f6);
            f4 += menuItem.getHeight();
        }
        this.subItemRect.width = f5 + f * 2.0f;
        this.subItemRect.height = (f4 += f2) - this.subItemRect.y;
        super.layout();
    }

    protected void setLayoutMode(int n) {
        this.layoutMode = n;
    }
}

