/*
 * Decompiled with CFR 0.152.
 */
package org.andrewberman.ui.menu;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.andrewberman.ui.Point;
import org.andrewberman.ui.UIGlobals;
import org.andrewberman.ui.ifaces.Positionable;
import org.andrewberman.ui.menu.Menu;
import org.andrewberman.ui.menu.MenuItem;
import org.andrewberman.ui.menu.MenuUtils;
import org.andrewberman.ui.menu.ToolbarItem;
import processing.core.PApplet;

public class Toolbar
extends Menu {
    RoundRectangle2D.Float roundRect = new RoundRectangle2D.Float(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    Rectangle2D.Float buffRect = new Rectangle2D.Float(0.0f, 0.0f, 0.0f, 0.0f);
    public boolean fullWidth;
    public boolean isModal;
    public int orientation = 0;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;

    public Toolbar(PApplet pApplet) {
        super(pApplet);
        this.layout();
        this.open();
    }

    protected boolean isActive() {
        return this.hasOpenChildren();
    }

    public void setOptions() {
        super.setOptions();
        this.useCameraCoordinates = true;
        this.clickToggles = true;
        this.hoverNavigable = true;
        this.clickAwayBehavior = 1;
        this.useHandCursor = true;
        this.autoDim = false;
        this.fullWidth = false;
        this.isModal = true;
        float f = this.getStyle().getF("f.strokeWeight");
        if (this.fullWidth) {
            this.x = f;
            this.y = f;
        } else if (!this.useCameraCoordinates) {
            this.x = f;
            this.y = f;
        }
    }

    public void draw() {
        if (this.fullWidth) {
            this.setFullWidth();
        }
        super.draw();
    }

    public void open(MenuItem menuItem) {
        super.open(menuItem);
        UIGlobals.g.focus().setFocus(this);
    }

    public void close(MenuItem menuItem) {
        super.close(menuItem);
        if (!this.isActive()) {
            UIGlobals.g.focus().removeFromFocus(this);
        }
    }

    public void close() {
        this.closeMyChildren();
        this.kbFocus = null;
    }

    public void drawBefore() {
        if (this.orientation == 0) {
            MenuUtils.drawDoubleGradientRect(this, this.x, this.y, this.width, this.height);
        } else {
            MenuUtils.drawVerticalGradientRect(this, this.x, this.y, this.width, this.height);
        }
    }

    public MenuItem create(String string) {
        ToolbarItem toolbarItem = new ToolbarItem();
        if (this.orientation == 0) {
            toolbarItem.setLayoutMode(0);
        } else {
            toolbarItem.setLayoutMode(1);
        }
        toolbarItem.drawChildrenTriangle = true;
        toolbarItem.setName(string);
        return toolbarItem;
    }

    protected void clickaway() {
        super.clickaway();
        if (this.isModal) {
            UIGlobals.g.focus().removeFromFocus(this);
        }
    }

    public synchronized void layout() {
        float f = this.getStyle().getF("f.padX");
        float f2 = this.getStyle().getF("f.padY");
        float f3 = f;
        float f4 = f2;
        for (int i = 0; i < this.items.size(); ++i) {
            MenuItem menuItem = (MenuItem)this.items.get(i);
            menuItem.calcPreferredSize();
            float f5 = menuItem.getWidth();
            float f6 = menuItem.getHeight();
            if (menuItem instanceof Positionable) {
                MenuItem menuItem2 = menuItem;
                menuItem2.setPosition(this.x + f3, this.y + f4);
            }
            if (this.orientation == 0) {
                f3 += f5;
                continue;
            }
            f4 += f6;
        }
        float f7 = this.getMaxHeight();
        float f8 = this.getMaxWidth();
        if (this.orientation == 0) {
            if (!this.fullWidth) {
                this.setWidth(f3 + f);
            } else {
                this.setFullWidth();
            }
            this.setHeight(f7 + f2 * 2.0f);
        } else {
            this.setHeight(f4 + f2);
            this.setWidth(f8 + f * 2.0f);
        }
        for (int i = 0; i < this.items.size(); ++i) {
            MenuItem menuItem = (MenuItem)this.items.get(i);
            if (this.orientation == 0) {
                menuItem.setHeight(f7);
                continue;
            }
            menuItem.setWidth(f8);
        }
        super.layout();
    }

    void setFullWidth() {
        float f = this.getStyle().getF("f.strokeWeight");
        if (this.orientation == 0) {
            this.width = (float)this.canvas.width - f * 2.0f;
        } else {
            this.height = (float)this.canvas.height - f * 2.0f;
        }
    }

    public void setState(MenuItem menuItem, int n) {
        if (!this.isActive()) {
            this.hoverNavigable = false;
        }
        super.setState(menuItem, n);
        if (menuItem.parent == this && this.isActive() && n != 0) {
            this.closeMyChildren();
            this.open(menuItem);
        }
        this.hoverNavigable = true;
    }

    protected void getRect(Rectangle2D.Float float_, Rectangle2D.Float float_2) {
        super.getRect(float_, float_2);
        if (this.isOpen()) {
            float_2.setRect(this.x, this.y, this.width, this.height);
            Rectangle2D.union(float_, float_2, float_);
        }
    }

    protected void itemMouseEvent(MouseEvent mouseEvent, Point point) {
        super.itemMouseEvent(mouseEvent, point);
        if (this.isActive() && this.autoDim) {
            this.aTween.continueTo(this.fullAlpha);
        }
    }

    protected void focusToItem(MenuItem menuItem) {
        this.kbFocus = menuItem;
        this.close(this);
        MenuItem menuItem2 = menuItem.parent;
        while (menuItem2 != null) {
            this.open(menuItem2);
            menuItem2 = menuItem2.parent;
        }
        this.hoverNavigable = false;
        this.setState(menuItem, 1);
        this.hoverNavigable = true;
    }

    void focusWrap(MenuItem menuItem, int n) {
        int n2 = menuItem.parent.items.indexOf(menuItem);
        if (n > 0) {
            ++n2;
        } else if (n < 0) {
            --n2;
        }
        if (n2 > menuItem.parent.items.size() - 1) {
            n2 = 0;
        } else if (n2 < 0) {
            n2 = menuItem.parent.items.size() - 1;
        }
        this.focusToItem(menuItem.parent.items.get(n2));
    }

    public void keyEvent(KeyEvent keyEvent) {
        super.keyEvent(keyEvent);
        if (UIGlobals.g.focus().getFocusedObject() != this) {
            return;
        }
        if (this.kbFocus == null) {
            ((MenuItem)this.items.get(0)).setState(1);
        }
        int n = keyEvent.getKeyCode();
        int n2 = keyEvent.getID();
        if (n2 != 401) {
            return;
        }
        MenuItem menuItem = this.kbFocus.parent;
        block0 : switch (n) {
            case 10: {
                if (this.kbFocus.hasChildren()) {
                    this.focusToItem(this.kbFocus.items.get(0));
                    break;
                }
                this.kbFocus.performAction();
                break;
            }
            case 39: {
                if (menuItem == this) {
                    this.focusWrap(this.kbFocus, 1);
                    break;
                }
                if (this.kbFocus.hasChildren() && this.kbFocus.isEnabled()) {
                    this.focusToItem(this.kbFocus.items.get(0));
                    break;
                }
                for (int i = 0; i < this.items.size(); ++i) {
                    MenuItem menuItem2 = (MenuItem)this.items.get(i);
                    if (!menuItem2.isAncestorOf(this.kbFocus)) continue;
                    this.focusWrap(menuItem2, 1);
                    this.focusToItem(this.kbFocus.items.get(0));
                    break block0;
                }
                break;
            }
            case 37: {
                if (menuItem == this) {
                    this.focusWrap(this.kbFocus, -1);
                    break;
                }
                if (menuItem.parent == this) {
                    this.focusWrap(menuItem, -1);
                    this.focusToItem(this.kbFocus.items.get(0));
                    break;
                }
                this.focusToItem(menuItem);
                break;
            }
            case 40: {
                if (menuItem == this) {
                    this.focusToItem(this.kbFocus.items.get(0));
                    break;
                }
                this.focusWrap(this.kbFocus, 1);
                break;
            }
            case 38: {
                if (menuItem == this) {
                    this.focusToItem(this.kbFocus.items.get(0));
                    break;
                }
                this.focusWrap(this.kbFocus, -1);
            }
        }
    }

    protected boolean containsPoint(Point point) {
        return false;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n) {
        this.orientation = n;
    }
}

