/*
 * Decompiled with CFR 0.152.
 */
package org.andrewberman.ui.menu;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.andrewberman.ui.Point;
import org.andrewberman.ui.UIUtils;
import org.andrewberman.ui.menu.MenuItem;
import org.andrewberman.ui.menu.MenuUtils;
import org.andrewberman.ui.menu.RadialMenu;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PImage;

public class RadialMenuItem
extends MenuItem {
    protected static RoundRectangle2D.Float roundedRect = new RoundRectangle2D.Float(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    public static final int HINT_DELAY = 60;
    public static final float SIZE_DECAY = 0.9f;
    protected Arc2D.Float tempArc = new Arc2D.Float(2);
    protected Ellipse2D.Float tempCircle = new Ellipse2D.Float(0.0f, 0.0f, 0.0f, 0.0f);
    protected float fontSize;
    protected float hintSize;
    protected char hint;
    protected float hintX;
    protected float hintY;
    protected PImage icon;
    float iconAlpha;
    String iconFile = null;
    protected float minRadius = 5.0f;
    protected float outerX;
    protected float outerY;
    protected float innerX;
    protected float innerY;
    protected float radius;
    protected float rectX;
    protected float rectY;
    protected float rectW;
    protected float rectH;
    protected float rLo;
    protected float rHi;
    protected float tLo;
    protected float tHi;
    protected float textWidth;
    protected float textHeight;
    protected float pad;
    protected float textX;
    protected float textY;
    protected Area wedge;
    protected int hintTrigger;

    protected boolean alreadyContainsChar(char c) {
        if (this.hint == c) {
            return true;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            RadialMenuItem radialMenuItem = (RadialMenuItem)this.items.get(i);
            if (!radialMenuItem.alreadyContainsChar(c)) continue;
            return true;
        }
        return false;
    }

    public boolean containsPoint(Point point) {
        Rectangle2D.Float float_;
        boolean bl = false;
        if (this.wedge.contains(point.x, point.y)) {
            bl = true;
        }
        if (this.isShowingLabel() && (float_ = new Rectangle2D.Float(this.rectX, this.rectY, this.rectW, this.rectH)).contains(point.x, point.y)) {
            bl = true;
        }
        return bl;
    }

    void createShapes() {
        this.tempCircle.setFrameFromCenter(this.x, this.y, this.x + this.rLo, this.y + this.rLo);
        this.tempArc.setFrameFromCenter(this.x, this.y, this.x + this.rHi, this.y + this.rHi);
        float f = this.radToDeg(-this.tLo);
        float f2 = this.radToDeg(-this.tHi);
        this.tempArc.setAngleStart(f);
        this.tempArc.setAngleExtent(f2 - f);
        try {
            this.wedge = new Area(this.tempArc);
            Area area = new Area(this.tempCircle);
            this.wedge.subtract(area);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void dispose() {
        super.dispose();
        this.icon = null;
    }

    public void draw() {
        boolean bl;
        super.draw();
        if (this.isShowingLabel()) {
            this.drawUnder();
            this.drawText();
        }
        this.drawShape();
        int n = this.menu.canvas.frameCount - this.hintTrigger;
        this.loadImage();
        boolean bl2 = bl = this.icon == null;
        if (bl) {
            this.drawHint();
        }
        if (!bl) {
            this.drawIcon();
        }
    }

    void drawHint() {
        Graphics2D graphics2D = this.menu.buff.g2;
        PFont pFont = this.getStyle().getFont("font");
        Font font = pFont.getFont().deriveFont(this.hintSize);
        graphics2D.setFont(font);
        graphics2D.setPaint(this.getStrokeColor());
        graphics2D.drawString(String.valueOf(this.hint), this.hintX, this.hintY);
    }

    public void drawIcon() {
        if (this.icon == null) {
            return;
        }
        Graphics2D graphics2D = this.menu.buff.g2;
        float f = (this.rLo + this.rHi) / 2.0f;
        float f2 = (float)Math.sqrt(this.icon.width * this.icon.width + this.icon.height * this.icon.height);
        this.hintSize = (this.rHi - this.rLo) / f2;
        this.hintSize = Math.min(this.hintSize, (float)Math.sin(this.tHi - this.tLo) * f);
        this.hintSize *= 0.8f;
        float f3 = (float)this.icon.width * this.hintSize;
        float f4 = (float)this.icon.height * this.hintSize;
        float f5 = (this.innerX + this.outerX) / 2.0f;
        float f6 = (this.innerY + this.outerY) / 2.0f;
        if (!this.isEnabled()) {
            this.menu.canvas.tint(200);
        }
        this.menu.canvas.image(this.icon, f5 - f3 / 2.0f, f6 - f4 / 2.0f, f3, f4);
        if (!this.isEnabled()) {
            this.menu.canvas.noTint();
        }
    }

    protected boolean drawingHint() {
        return true;
    }

    void drawShape() {
        Graphics2D graphics2D = this.menu.buff.g2;
        if (this.isOpen()) {
            graphics2D.setPaint(this.getStyle().getGradient(1, this.x - this.rHi, this.y - this.rHi, this.x + this.rHi, this.y + this.rHi));
        } else {
            graphics2D.setPaint(this.getStyle().getGradient(this.getState(), this.x - this.rHi, this.y - this.rHi, this.x + this.rHi, this.y + this.rHi));
        }
        graphics2D.fill(this.wedge);
        graphics2D.setStroke(this.getStroke());
        graphics2D.setPaint(this.getStrokeColor());
        graphics2D.draw(this.wedge);
        if (this.items.size() > 0 && !this.isOpen()) {
            float f = (this.tLo + this.tHi) / 2.0f;
            float f2 = (this.rHi - this.rLo) / 2.0f;
            float f3 = (float)(Math.cos(f) * (double)f2 / 4.0);
            float f4 = (float)(Math.sin(f) * (double)f2 / 4.0);
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(this.outerX + f3, this.outerY + f4);
            affineTransform.scale(f2, f2);
            affineTransform.rotate(f);
            Area area = (Area)this.getStyle().get("subTriangle");
            Area area2 = area.createTransformedArea(affineTransform);
            graphics2D.setPaint(this.getStrokeColor());
            graphics2D.fill(area2);
        }
    }

    void drawText() {
        Graphics2D graphics2D = this.menu.buff.g2;
        PFont pFont = this.getStyle().getFont("font");
        Font font = pFont.getFont().deriveFont(this.fontSize);
        graphics2D.setFont(font);
        graphics2D.setPaint(this.getStrokeColor());
        graphics2D.drawString(this.getDisplayLabel(), this.textX, this.textY);
    }

    public void drawUnder() {
        Graphics2D graphics2D = this.menu.buff.g2;
        MenuUtils.drawWhiteTextRect(this, this.rectX, this.rectY, this.rectW, this.rectH);
        super.draw();
    }

    public String getDisplayLabel() {
        String string = this.getName();
        if (this.items.size() > 0) {
            string = string.concat("...");
        }
        if (!this.drawingHint() && this.hint != '\u0000') {
            string = string.concat(" (" + String.valueOf(this.hint) + ")");
        }
        return string;
    }

    float getMaxRadius() {
        if (!this.isOpen()) {
            return 0.0f;
        }
        float f = this.rHi;
        for (int i = 0; i < this.items.size(); ++i) {
            RadialMenuItem radialMenuItem = (RadialMenuItem)this.items.get(i);
            float f2 = radialMenuItem.getMaxRadius();
            if (!(f2 > f)) continue;
            f = f2;
        }
        return f;
    }

    public float getMinRadius() {
        return this.minRadius;
    }

    public void getRect(Rectangle2D.Float float_, Rectangle2D.Float float_2) {
        super.getRect(float_, float_2);
        float_2.setRect(this.wedge.getBounds2D());
        Rectangle2D.union(float_, float_2, float_);
        float_2.setRect(this.rectX, this.rectY, this.rectW, this.rectH);
        Rectangle2D.union(float_, float_2, float_);
    }

    boolean isShowingLabel() {
        if (!this.isOpen()) {
            MenuItem menuItem = this.parent;
            int n = 1;
            while (menuItem != this.menu) {
                ++n;
                menuItem = menuItem.parent;
            }
            RadialMenu radialMenu = (RadialMenu)this.menu;
            if (n == radialMenu.maxLevelOpen) {
                return true;
            }
        }
        return false;
    }

    protected void itemMouseEvent(MouseEvent mouseEvent, Point point) {
        boolean bl = this.mouseInside;
        super.itemMouseEvent(mouseEvent, point);
        boolean bl2 = this.mouseInside;
        if (bl2 && !bl && this.menu != null && this.menu.canvas != null) {
            this.hintTrigger = this.menu.canvas.frameCount;
        }
    }

    protected void keyHintEvent(KeyEvent keyEvent) {
        int n;
        if (this.isOpen()) {
            for (n = 0; n < this.items.size(); ++n) {
                RadialMenuItem radialMenuItem = (RadialMenuItem)this.items.get(n);
                radialMenuItem.keyHintEvent(keyEvent);
            }
        }
        if (keyEvent.isConsumed()) {
            return;
        }
        n = keyEvent.getKeyChar();
        if (Character.toLowerCase((char)n) == Character.toLowerCase(this.hint)) {
            this.performAction();
            keyEvent.consume();
            return;
        }
    }

    public synchronized void layout() {
        super.layout();
    }

    protected void layout(float f, float f2, float f3, float f4) {
        if (f2 - f < this.minRadius) {
            f2 = f + this.minRadius;
        }
        this.rLo = f;
        this.rHi = f2;
        this.tLo = f3;
        this.tHi = f4;
        this.radius = f2;
        this.layoutText();
        this.createShapes();
        float f5 = (this.tHi + this.tLo) / 2.0f;
        float f6 = this.tHi - this.tLo;
        float f7 = 0.47123894f * (float)this.items.size();
        float f8 = Math.min(2.3561945f, f6);
        f6 = PApplet.constrain((float)f6, (float)f7, (float)f8);
        this.layoutSubItems(this.rLo, this.rHi, f5 - f6 / 2.0f, f5 + f6 / 2.0f);
    }

    void layoutSubItems(float f, float f2, float f3, float f4) {
        float f5 = f4 - f3;
        float f6 = f5 / (float)this.items.size();
        for (int i = 0; i < this.items.size(); ++i) {
            RadialMenuItem radialMenuItem = (RadialMenuItem)this.items.get(i);
            radialMenuItem.setPosition(this.x, this.y);
            float f7 = f3 + (float)i * f6;
            radialMenuItem.layout(f2, f2 + (f2 - f) * 0.9f, f7, f7 + f6);
        }
    }

    void layoutText() {
        float f = (this.tLo + this.tHi) / 2.0f;
        float f2 = (float)Math.cos(f);
        float f3 = (float)Math.sin(f);
        this.outerX = this.x + f2 * this.rHi;
        this.outerY = this.y + f3 * this.rHi;
        this.innerX = this.x + f2 * this.rLo;
        this.innerY = this.y + f3 * this.rLo;
        PFont pFont = this.getStyle().getFont("font");
        FontMetrics fontMetrics = UIUtils.getMetrics(this.menu.canvas.g, pFont.getFont(), 1.0f);
        if (fontMetrics == null) {
            return;
        }
        float f4 = (float)fontMetrics.getMaxCharBounds(this.menu.buff.g2).getHeight();
        this.fontSize = (this.rHi - this.rLo) / f4 * 0.75f;
        this.fontSize = Math.max(8.0f, this.fontSize);
        fontMetrics = UIUtils.getMetrics((PGraphics)this.menu.buff, pFont.getFont(), this.fontSize);
        float f5 = fontMetrics.getAscent();
        this.textHeight = UIUtils.getTextHeight((PGraphics)this.menu.buff, pFont, this.fontSize, this.getDisplayLabel(), true);
        this.textWidth = UIUtils.getTextWidth((PGraphics)this.menu.buff, pFont, this.fontSize, this.getDisplayLabel(), true);
        float f6 = this.x + f2 * (this.rHi + this.textHeight);
        float f7 = this.y + f3 * (this.rHi + this.textHeight);
        float f8 = this.getStyle().getF("f.padX");
        this.rectW = this.textWidth + 2.0f * f8;
        this.rectH = this.textHeight + 2.0f * f8;
        this.rectX = f6 + f2 * this.rectW / 2.0f - this.rectW / 2.0f;
        this.rectY = f7 + f3 * this.rectH / 2.0f - this.rectH / 2.0f;
        this.textX = this.rectX + f8;
        this.textY = this.rectY + f8 + f5;
        float f9 = (this.rLo + this.rHi) / 2.0f;
        float f10 = this.x + f2 * f9;
        float f11 = this.y + f3 * f9;
        fontMetrics = UIUtils.getMetrics((PGraphics)this.menu.buff, pFont.getFont(), 1.0f);
        String string = String.valueOf(this.hint);
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, this.menu.buff.g2);
        float f12 = (float)rectangle2D.getHeight();
        float f13 = (float)rectangle2D.getWidth();
        float f14 = PApplet.sqrt((float)(f12 * f12 + f13 * f13));
        this.hintSize = (this.rHi - this.rLo) / f14;
        this.hintSize = Math.min(this.hintSize, (float)Math.sin(this.tHi - this.tLo) * f9);
        fontMetrics = UIUtils.getMetrics((PGraphics)this.menu.buff, pFont.getFont(), this.hintSize);
        rectangle2D = fontMetrics.getStringBounds(string, this.menu.buff.g2);
        f12 = (float)rectangle2D.getHeight();
        f13 = (float)rectangle2D.getWidth();
        f14 = PApplet.sqrt((float)(f12 * f12 + f13 * f13));
        float f15 = fontMetrics.getDescent();
        this.hintX = f10 - f13 / 2.0f;
        this.hintY = f11 - f15 + f12 / 2.0f;
    }

    protected synchronized void loadImage() {
        if (this.icon == null && this.iconFile != null && this.menu != null && this.menu.canvas != null) {
            this.icon = this.menu.canvas.loadImage(this.iconFile);
        }
    }

    float radToDeg(float f) {
        return PApplet.degrees((float)f);
    }

    public void setHint(String string) {
        this.hint = string.charAt(0);
    }

    public void setIcon(String string) {
        this.iconFile = string;
        this.loadImage();
    }

    public void setMinRadius(float f) {
        this.minRadius = f;
    }

    protected void visibleMouseEvent(MouseEvent mouseEvent, Point point) {
        super.visibleMouseEvent(mouseEvent, point);
        if (this.getState() == 1) {
            mouseEvent.consume();
        }
    }
}

