/*
 * Decompiled with CFR 0.152.
 */
package org.andrewberman.ui.menu;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collections;
import org.andrewberman.ui.Point;
import org.andrewberman.ui.UIRectangle;
import org.andrewberman.ui.menu.Menu;
import org.andrewberman.ui.menu.MenuItem;
import org.andrewberman.ui.menu.RadialMenuItem;
import processing.core.PApplet;

public class RadialMenu
extends Menu {
    public static final float FADE_DIST_MULTIPLIER = 0.5f;
    public float thetaLo = 0.0f;
    public float thetaHi = (float)Math.PI * 2;
    float innerRadius;
    public float radius;
    private MenuItem.VisibleDepthComparator visComp = new MenuItem.VisibleDepthComparator();
    protected UIRectangle myRect = new UIRectangle(0.0f, 0.0f, 0.0f, 0.0f);
    UIRectangle buffRect = new UIRectangle(0.0f, 0.0f, 0.0f, 0.0f);
    AffineTransform buffTransform;
    AffineTransform mouseTransform;
    protected int maxLevelOpen;

    public RadialMenu(PApplet pApplet) {
        super(pApplet);
    }

    public void setOptions() {
        super.setOptions();
        this.setRadii(10.0f, 30.0f);
        this.clickAwayBehavior = 0;
        this.hoverNavigable = false;
        this.clickToggles = true;
        this.autoDim = true;
        this.useCameraCoordinates = true;
        this.modalFocus = true;
        this.useHandCursor = true;
    }

    protected void hint() {
        super.hint();
    }

    public void setRadius(float f) {
        this.radius = f;
    }

    public void setRadii(float f, float f2) {
        this.innerRadius = f;
        this.radius = f2;
        this.layout();
    }

    public MenuItem create(String string) {
        boolean bl = false;
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (this.alreadyContainsChar(c) || !Character.isLetter(c)) continue;
            bl = true;
            n = i;
            break;
        }
        if (!bl) {
            n = 0;
        }
        return this.create(string, string.charAt(n));
    }

    protected boolean alreadyContainsChar(char c) {
        for (int i = 0; i < this.items.size(); ++i) {
            RadialMenuItem radialMenuItem = (RadialMenuItem)this.items.get(i);
            if (!radialMenuItem.alreadyContainsChar(c)) continue;
            return true;
        }
        return false;
    }

    public RadialMenuItem create(String string, char c) {
        RadialMenuItem radialMenuItem = new RadialMenuItem();
        radialMenuItem.setName(string);
        radialMenuItem.setHint(String.valueOf(c));
        return radialMenuItem;
    }

    public void setArc(float f, float f2) {
        this.thetaLo = f;
        this.thetaHi = f2;
        this.layout();
    }

    public synchronized void layout() {
        if (this.items.size() == 0) {
            return;
        }
        float f = this.thetaHi - this.thetaLo;
        float f2 = f / (float)this.items.size();
        float f3 = -1.5707964f;
        for (int i = 0; i < this.items.size(); ++i) {
            RadialMenuItem radialMenuItem = (RadialMenuItem)this.items.get(i);
            radialMenuItem.setPosition(this.x, this.y);
            float f4 = f3 + (float)i * f2;
            radialMenuItem.layout(this.innerRadius, this.radius, f4, f4 + f2);
        }
        this.findMaxLevelOpen();
    }

    public void findMaxLevelOpen() {
        MenuItem menuItem = this;
        this.maxLevelOpen = 0;
        boolean bl = true;
        block0: while (bl) {
            ++this.maxLevelOpen;
            bl = false;
            for (int i = 0; i < menuItem.items.size(); ++i) {
                MenuItem menuItem2 = menuItem.items.get(i);
                if (!menuItem2.isOpen()) continue;
                menuItem = menuItem2;
                bl = true;
                continue block0;
            }
        }
    }

    public void setPosition(float f, float f2) {
        this.x = f;
        this.y = f2;
        this.layout();
    }

    public void itemMouseEvent(MouseEvent mouseEvent, Point point) {
        super.itemMouseEvent(mouseEvent, point);
        this.myRect.setRect(this.x, this.y, 0.0f, 0.0f);
        this.myRect.setRect(this.x, this.y, 0.0f, 0.0f);
        this.getRect(this.myRect, this.buffRect);
        float f = this.myRect.distToPoint(point);
        float f2 = Math.max(this.myRect.width, this.myRect.height) * 0.5f;
        f2 = Math.max(f2, this.radius);
        if (f < f2) {
            if (this.autoDim) {
                float f3 = 1.0f - f / f2;
                this.aTween.continueTo(f3);
                this.aTween.fforward();
            }
        } else {
            this.close();
        }
    }

    public void keyEvent(KeyEvent keyEvent) {
        if (!this.isOpen()) {
            return;
        }
        if (keyEvent.getID() == 400) {
            ArrayList arrayList = (ArrayList)this.items.clone();
            Collections.sort(arrayList, this.visComp);
            for (int i = 0; i < arrayList.size(); ++i) {
                if (keyEvent.isConsumed()) continue;
                RadialMenuItem radialMenuItem = (RadialMenuItem)arrayList.get(i);
                radialMenuItem.keyHintEvent(keyEvent);
            }
        }
        keyEvent.consume();
    }
}

