/*
 * Decompiled with CFR 0.152.
 */
package org.andrewberman.ui.menu;

import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import org.andrewberman.ui.Point;
import org.andrewberman.ui.UIGlobals;
import org.andrewberman.ui.UIUtils;
import org.andrewberman.ui.menu.MenuIO;
import org.andrewberman.ui.menu.MenuItem;
import org.andrewberman.ui.menu.MenuUtils;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;

public class NumberScroller
extends MenuItem {
    static RoundRectangle2D.Float buffRoundRect = new RoundRectangle2D.Float(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    private DecimalFormat df;
    boolean customFormat = false;
    private Field field;
    private Method method;
    private Object fieldObj;
    public boolean allowPrecision = true;
    static float NaN = Float.NaN;
    private float min = -3.4028235E38f;
    private float max = Float.MAX_VALUE;
    boolean scrolling;
    float startY;
    float startVal;
    private String stringValue;
    private float tWidth;
    private float nWidth;
    private float nOffset;
    private boolean useReflection;
    private boolean useMethod;
    private float value;
    private float defaultValue;
    private float increment;
    private float scrollSpeed;
    private boolean controlDown = false;

    public NumberScroller() {
        this.df = new DecimalFormat("#######0.0#");
        this.df.setDecimalSeparatorAlwaysShown(false);
        this.value = 0.0f;
        this.defaultValue = NaN;
        this.increment = 1.0f;
        this.scrollSpeed = 1.0f;
        this.setIncrement(this.increment);
        this.setValue(this.value);
        this.setScrollSpeed(this.scrollSpeed);
        this.stringValue = new String();
    }

    public void setFormat(String string) {
        this.df = new DecimalFormat(string);
        this.df.setDecimalSeparatorAlwaysShown(false);
        int n = string.indexOf(".");
        if (n > -1) {
            int n2 = string.length() - n - 1;
            this.df.setMinimumFractionDigits(n2);
            this.df.setMaximumFractionDigits(n2);
        }
        this.customFormat = true;
        this.updateString();
    }

    protected void calcPreferredSize() {
        super.calcPreferredSize();
        PFont pFont = this.menu.getStyle().getFont("font");
        float f = this.menu.getStyle().getF("f.fontSize");
        float f2 = this.menu.getStyle().getF("f.padX");
        float f3 = this.menu.getStyle().getF("f.padY");
        float f4 = UIUtils.getTextHeight((PGraphics)this.menu.buff, pFont, f, "XYZ", true);
        if (this.getName().length() > 0) {
            this.tWidth = UIUtils.getTextWidth((PGraphics)this.menu.buff, pFont, f, this.getName() + ":", true);
            this.tWidth += f2;
        }
        String string = this.stringValue;
        this.nWidth = 0.0f;
        this.nWidth += UIUtils.getTextWidth((PGraphics)this.menu.buff, pFont, f, string, true);
        this.nWidth += 2.0f * f2;
        this.nOffset = this.getWidth() - f2 - this.nWidth;
        this.setWidth(f2 + this.tWidth + this.nWidth + f2);
        this.setHeight(f4 + 2.0f * f3);
    }

    protected boolean containsPoint(Point point) {
        if (this.scrolling) {
            return true;
        }
        float f = this.menu.getStyle().getF("f.roundOff");
        buffRoundRect.setRoundRect(this.x, this.y, this.width, this.height, f, f);
        return buffRoundRect.contains(point);
    }

    protected void drawMyself() {
        super.drawMyself();
        this.getValue();
        if (this.scrolling) {
            this.menu.layout();
        }
        float f = this.menu.getStyle().getF("f.padX");
        float f2 = this.menu.getStyle().getF("f.padY");
        float f3 = this.x + f;
        MenuUtils.drawLeftText(this, this.getName() + ":", f3);
        f3 += this.tWidth;
        f3 = this.getX() + this.getWidth() - f - this.nWidth;
        if (this.shouldPerformFill()) {
            MenuUtils.drawSingleGradientRect(this, f3, this.y, this.nWidth, this.height);
        }
        MenuUtils.drawText(this, this.stringValue, true, true, f3, this.y, this.nWidth, this.height);
    }

    protected void getRect(Rectangle2D.Float float_, Rectangle2D.Float float_2) {
        float_2.setFrame(this.x, this.y, this.width, this.height);
        Rectangle2D.union(float_, float_2, float_);
        super.getRect(float_, float_2);
    }

    public float getValue() {
        float f = this.value;
        try {
            if (this.useReflection) {
                this.value = this.field.getFloat(this.fieldObj);
            }
        }
        catch (Exception exception) {
            this.useReflection = false;
            exception.printStackTrace();
        }
        if (this.value != f) {
            this.updateString();
        }
        return this.value;
    }

    public void performAction() {
    }

    public void setDefault(float f) {
        this.defaultValue = f;
        this.setValue(this.defaultValue);
    }

    public void setIncrement(float f) {
        this.increment = f;
        int n = (int)Math.ceil((float)(-Math.log10(this.increment)));
        if (!this.customFormat) {
            this.df.setMinimumFractionDigits(n);
            this.df.setMaximumFractionDigits(n);
        }
        this.setValue(this.getValue());
    }

    public void setMax(float f) {
        this.max = f;
    }

    public void setMin(float f) {
        this.min = f;
    }

    public void setProperty(Object object, String string) {
        try {
            String string2 = "set" + MenuIO.upperFirst(string);
            this.method = object.getClass().getMethod(string2, Float.TYPE);
            this.useMethod = true;
        }
        catch (Exception exception) {
            this.useMethod = false;
        }
        try {
            this.field = object.getClass().getField(string);
            this.fieldObj = object;
            this.useReflection = true;
        }
        catch (Exception exception) {
            this.field = null;
            this.fieldObj = null;
            this.useReflection = false;
            throw new RuntimeException();
        }
        if (Float.isNaN(this.defaultValue)) {
            this.setDefault(this.getValue());
        }
        if (this.useReflection) {
            try {
                this.field.setFloat(this.fieldObj, this.getValue());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            this.setValue(this.defaultValue);
        }
    }

    public void setScrollSpeed(float f) {
        this.scrollSpeed = f;
    }

    public void setValue(float f) {
        float f2 = this.value;
        this.value = PApplet.constrain((float)f, (float)this.min, (float)this.max);
        if (this.useReflection) {
            if (this.useMethod) {
                try {
                    this.method.invoke(this.fieldObj, Float.valueOf(this.value));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                try {
                    this.field.setFloat(this.fieldObj, this.value);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        this.updateString();
    }

    void updateString() {
        this.stringValue = this.df.format(this.value);
    }

    protected void visibleMouseEvent(MouseEvent mouseEvent, Point point) {
        super.visibleMouseEvent(mouseEvent, point);
        if (!this.isEnabled()) {
            return;
        }
        float f = this.increment;
        if (mouseEvent.isControlDown() != this.controlDown) {
            this.controlDown = mouseEvent.isControlDown();
            this.startY = point.y;
            this.startVal = this.getValue();
        }
        if (mouseEvent.isControlDown()) {
            f /= 5.0f;
        }
        if (this.mouseInside) {
            this.menu.setCursor(8);
        }
        switch (mouseEvent.getID()) {
            case 501: {
                if (!this.mouseInside) break;
                if (mouseEvent.getClickCount() > 1) {
                    this.setValue(this.defaultValue);
                }
                this.startY = point.y;
                this.startVal = this.getValue();
                this.scrolling = true;
                UIGlobals.g.focus().setModalFocus(this.menu);
                break;
            }
            case 506: {
                if (!this.scrolling) break;
                float f2 = this.startY - point.y;
                float f3 = f2 * f * this.scrollSpeed;
                this.value = this.startVal + f3;
                this.setValue(this.value);
                mouseEvent.consume();
                break;
            }
            case 502: {
                if (!this.scrolling) break;
                mouseEvent.consume();
                this.scrolling = false;
                UIGlobals.g.focus().removeFromFocus(this.menu);
            }
        }
    }

    public boolean isAllowPrecision() {
        return this.allowPrecision;
    }

    public void setAllowPrecision(String string) {
        this.allowPrecision = string.equalsIgnoreCase("true") || string.toLowerCase().startsWith("y");
    }
}

