/*
 * Decompiled with CFR 0.152.
 */
package org.andrewberman.ui.menu;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import org.andrewberman.ui.Color;
import org.andrewberman.ui.UIUtils;
import org.andrewberman.ui.menu.Menu;
import org.andrewberman.ui.menu.MenuItem;
import org.andrewberman.ui.menu.MenuStyle;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PGraphicsJava2D;

public class MenuUtils {
    static RoundRectangle2D.Float roundRect = new RoundRectangle2D.Float();
    static RenderingHints rh;

    public static synchronized void drawWhiteTextRect(MenuItem menuItem, float f, float f2, float f3, float f4) {
        Graphics2D graphics2D = menuItem.menu.buff.g2;
        roundRect.setRoundRect(f, f2, f3, f4, f4 / 3.0f, f4 / 3.0f);
        if (!menuItem.isEnabled()) {
            graphics2D.setPaint(menuItem.getStyle().getC("c.disabled"));
        } else {
            graphics2D.setPaint(Color.white);
        }
        graphics2D.fill(roundRect);
        graphics2D.setPaint(Color.black);
        graphics2D.setStroke(new BasicStroke(menuItem.getStyle().getF("f.strokeWeight")));
        graphics2D.draw(roundRect);
    }

    public static synchronized void drawBackgroundRoundRect(MenuItem menuItem, float f, float f2, float f3, float f4) {
        PGraphicsJava2D pGraphicsJava2D = menuItem.menu.buff;
        MenuStyle menuStyle = menuItem.getStyle();
        Menu menu = menuItem.menu;
        float f5 = menuStyle.getF("f.roundOff");
        roundRect.setRoundRect(f, f2, f3, f4, f5, f5);
        pGraphicsJava2D.g2.setPaint(menuStyle.getC("c.background"));
        pGraphicsJava2D.g2.fill(roundRect);
        pGraphicsJava2D.g2.setStroke(new BasicStroke(menuStyle.getF("f.strokeWeight")));
        pGraphicsJava2D.g2.setPaint(menuStyle.getC("c.foreground"));
        pGraphicsJava2D.g2.draw(roundRect);
    }

    public static synchronized void drawVerticalGradientRect(MenuItem menuItem, float f, float f2, float f3, float f4) {
        PGraphicsJava2D pGraphicsJava2D = menuItem.menu.buff;
        MenuStyle menuStyle = menuItem.getStyle();
        Menu menu = menuItem.menu;
        float f5 = menuStyle.getF("f.roundOff");
        roundRect.setRoundRect(f, f2, f3, f4, f5, f5);
        pGraphicsJava2D.g2.setPaint(menuStyle.getGradient(0, f, f2, f + f3, f2));
        pGraphicsJava2D.g2.fill(roundRect);
        Composite composite = pGraphicsJava2D.g2.getComposite();
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.5f * menu.alpha);
        pGraphicsJava2D.g2.setComposite(alphaComposite);
        pGraphicsJava2D.g2.setPaint(menuStyle.getGradient(0, f + menuItem.width, f2, f + menuItem.width / 3.0f, f2));
        pGraphicsJava2D.g2.fillRect((int)(f + f3 / 2.0f), (int)f2, (int)(f3 / 2.0f), (int)f4);
        pGraphicsJava2D.g2.setComposite(composite);
        RenderingHints renderingHints = menu.buff.g2.getRenderingHints();
        pGraphicsJava2D.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        pGraphicsJava2D.g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        pGraphicsJava2D.g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        pGraphicsJava2D.g2.setPaint(menuStyle.getC("c.foreground"));
        pGraphicsJava2D.g2.setStroke(new BasicStroke(menuStyle.getF("f.strokeWeight")));
        pGraphicsJava2D.g2.draw(roundRect);
        pGraphicsJava2D.g2.setRenderingHints(renderingHints);
    }

    public static void drawRoundOutline(MenuItem menuItem, RoundRectangle2D roundRectangle2D) {
        MenuStyle menuStyle = menuItem.getStyle();
        float f = menuStyle.getF("f.strokeWeight");
        RoundRectangle2D roundRectangle2D2 = roundRectangle2D;
        MenuUtils.preDraw(menuItem);
        menuItem.menu.buff.g2.draw(roundRectangle2D2);
        MenuUtils.postDraw(menuItem);
    }

    static void preDraw(MenuItem menuItem) {
        Menu menu = menuItem.menu;
        MenuStyle menuStyle = menuItem.getStyle();
        PGraphicsJava2D pGraphicsJava2D = menuItem.menu.buff;
        rh = menu.buff.g2.getRenderingHints();
        pGraphicsJava2D.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        pGraphicsJava2D.g2.setPaint(menuStyle.getC("c.foreground"));
        pGraphicsJava2D.g2.setStroke(new BasicStroke(menuStyle.getF("f.strokeWeight")));
    }

    static void postDraw(MenuItem menuItem) {
        menuItem.menu.buff.g2.setRenderingHints(rh);
    }

    public static synchronized void drawDoubleGradientRect(MenuItem menuItem, float f, float f2, float f3, float f4) {
        PGraphicsJava2D pGraphicsJava2D = menuItem.menu.buff;
        MenuStyle menuStyle = menuItem.getStyle();
        Menu menu = menuItem.menu;
        float f5 = menuStyle.getF("f.roundOff");
        roundRect.setRoundRect(f, f2, f3, f4, f5, f5);
        pGraphicsJava2D.g2.setPaint(menuStyle.getGradient(0, f, f2, f, f2 + f4));
        pGraphicsJava2D.g2.fill(roundRect);
        Composite composite = pGraphicsJava2D.g2.getComposite();
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.5f * menu.alpha);
        pGraphicsJava2D.g2.setComposite(alphaComposite);
        pGraphicsJava2D.g2.setPaint(menuStyle.getGradient(0, f, f2 + f4, f, f2 + f4 / 3.0f));
        pGraphicsJava2D.g2.fillRect((int)f, (int)(f2 + f4 / 2.0f), (int)f3, (int)f4 / 2);
        pGraphicsJava2D.g2.setComposite(composite);
        MenuUtils.drawRoundOutline(menuItem, roundRect);
    }

    public static synchronized void drawBlankRect(MenuItem menuItem, float f, float f2, float f3, float f4) {
        Menu menu = menuItem.menu;
        MenuStyle menuStyle = menuItem.getStyle();
        roundRect.setRoundRect(f, f2, f3, f4, 0.0f, 0.0f);
        MenuUtils.drawRoundOutline(menuItem, roundRect);
    }

    public static synchronized void drawSingleGradientRect(MenuItem menuItem, float f, float f2, float f3, float f4) {
        float f5 = menuItem.getStyle().getF("f.roundOff");
        MenuUtils.drawSingleGradientRect(menuItem, f, f2, f3, f4, f5);
    }

    public static synchronized void drawSingleGradientRect(MenuItem menuItem, float f, float f2, float f3, float f4, float f5) {
        Menu menu = menuItem.menu;
        MenuStyle menuStyle = menuItem.getStyle();
        roundRect.setRoundRect(f, f2, f3, f4, f5, f5);
        Graphics2D graphics2D = menu.buff.g2;
        if (menuItem.isOpen()) {
            graphics2D.setPaint(menuItem.getStyle().getGradient(2, f2, f2 + f4));
        } else {
            graphics2D.setPaint(menuItem.getStyle().getGradient(1, f2, f2 + f4));
        }
        if (menuItem.getState() != 0 || menuItem.isOpen()) {
            graphics2D.fill(roundRect);
        }
        if (menuItem.getState() != 0 || menuItem.isOpen()) {
            MenuUtils.drawRoundOutline(menuItem, roundRect);
        }
    }

    public static void drawCenteredText(MenuItem menuItem) {
        MenuUtils.drawText(menuItem, menuItem.getName(), true, true, menuItem.x, menuItem.y, menuItem.width, menuItem.height);
    }

    public static void drawLeftText(MenuItem menuItem, String string, float f) {
        MenuUtils.drawText(menuItem, string, false, true, f, menuItem.y, menuItem.width, menuItem.height);
    }

    public static void drawText(MenuItem menuItem, String string, boolean bl, boolean bl2, float f, float f2, float f3, float f4) {
        try {
            float f5;
            Graphics2D graphics2D = menuItem.menu.buff.g2;
            float f6 = MenuUtils.getTextDescent(menuItem);
            float f7 = 0.0f;
            float f8 = 0.0f;
            if (bl) {
                f5 = MenuUtils.getTextWidth(menuItem, string);
                f7 = (f3 - f5) / 2.0f;
            }
            if (bl2) {
                f5 = MenuUtils.getTextHeight(menuItem, string);
                f8 = (f4 - f5) / 2.0f + f6;
            } else {
                f8 = f4 - f6;
            }
            MenuStyle menuStyle = menuItem.getStyle();
            PFont pFont = menuStyle.getFont("font");
            float f9 = menuStyle.getF("f.fontSize");
            graphics2D.setFont(pFont.getFont().deriveFont(f9));
            if (!menuItem.isEnabled()) {
                graphics2D.setPaint(menuStyle.getC("c.foreground").brighter(120.0));
            } else {
                graphics2D.setPaint(menuStyle.getC("c.foreground"));
            }
            graphics2D.setStroke(new BasicStroke(menuStyle.getF("f.strokeWeight")));
            graphics2D.drawString(string, f + f7, f2 + f8);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static float getTextWidth(MenuItem menuItem, String string) {
        MenuStyle menuStyle = menuItem.getStyle();
        return UIUtils.getTextWidth((PGraphics)menuItem.menu.buff, menuStyle.getFont("font"), menuStyle.getF("f.fontSize"), string, true);
    }

    public static float getTextHeight(MenuItem menuItem, String string) {
        MenuStyle menuStyle = menuItem.getStyle();
        return UIUtils.getTextHeight((PGraphics)menuItem.menu.buff, menuStyle.getFont("font"), menuStyle.getF("f.fontSize"), string, true);
    }

    public static float getTextAscent(MenuItem menuItem) {
        MenuStyle menuStyle = menuItem.getStyle();
        return UIUtils.getTextAscent((PGraphics)menuItem.menu.buff, menuStyle.getFont("font"), menuStyle.getF("f.fontSize"), true);
    }

    public static float getTextDescent(MenuItem menuItem) {
        MenuStyle menuStyle = menuItem.getStyle();
        return UIUtils.getTextAscent((PGraphics)menuItem.menu.buff, menuStyle.getFont("font"), menuStyle.getF("f.fontSize"), true);
    }
}

