/*
 * Decompiled with CFR 0.152.
 */
package org.andrewberman.ui.menu;

import java.awt.BasicStroke;
import java.awt.Stroke;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.andrewberman.ui.Action;
import org.andrewberman.ui.Color;
import org.andrewberman.ui.Point;
import org.andrewberman.ui.Shortcut;
import org.andrewberman.ui.UIGlobals;
import org.andrewberman.ui.UIUtils;
import org.andrewberman.ui.ifaces.Malleable;
import org.andrewberman.ui.ifaces.Positionable;
import org.andrewberman.ui.ifaces.Sizable;
import org.andrewberman.ui.ifaces.UIObject;
import org.andrewberman.ui.menu.Menu;
import org.andrewberman.ui.menu.MenuStyle;
import org.andrewberman.ui.menu.MenuTimer;
import processing.core.PFont;
import processing.core.PGraphics;

public abstract class MenuItem
implements Positionable,
Sizable,
Malleable,
UIObject {
    public static final int DISABLED = 3;
    public static final int DOWN = 2;
    public static final int OVER = 1;
    protected static MenuTimer timer;
    public static final int UP = 0;
    protected static ZDepthComparator zComp;
    protected Action action;
    private boolean enabled = true;
    protected boolean isOpen;
    protected ArrayList<MenuItem> items;
    private MenuStyle style;
    protected Menu menu;
    protected boolean mouseInside;
    protected String name;
    protected Menu nearestMenu;
    protected boolean needsZSort;
    protected MenuItem parent;
    protected Shortcut shortcut;
    protected int state;
    protected float width;
    protected float height;
    protected float x;
    protected float y;
    protected boolean drawnOnce;
    protected int z;
    protected ArrayList<MenuItem> zSortedItems;
    ArrayList<MenuItem> itemsToAdd = new ArrayList();
    private ConditionChecker condition;
    protected boolean hidden;

    public MenuItem() {
        this.name = new String();
        this.items = new ArrayList(1);
        this.zSortedItems = new ArrayList(1);
        this.style = new MenuStyle();
        timer = UIGlobals.g.getMenuTimer();
    }

    public MenuItem add(MenuItem menuItem) {
        this.items.add(menuItem);
        this.zSortedItems.add(menuItem);
        this.zSort();
        menuItem.setParent(this);
        if (this.menu != null) {
            this.menu.layout();
        }
        return menuItem;
    }

    public MenuItem add(String string) {
        return this.add(this.create(string));
    }

    public void dispose() {
        for (MenuItem menuItem : this.items) {
            menuItem.dispose();
        }
    }

    protected void calcPreferredSize() {
    }

    public void closeMyChildren() {
        for (int i = 0; i < this.items.size(); ++i) {
            MenuItem menuItem = this.items.get(i);
            this.menu.close(menuItem);
        }
    }

    protected abstract boolean containsPoint(Point var1);

    public MenuItem create(String string) {
        if (this.nearestMenu != null) {
            return this.nearestMenu.create(string);
        }
        if (this.menu != null) {
            return this.menu.create(string);
        }
        throw new RuntimeException("Error in MenuItem.create(String label)");
    }

    public synchronized void draw() {
        if (this.hidden) {
            return;
        }
        this.drawMyself();
        if (!this.isOpen()) {
            return;
        }
        if (this.needsZSort) {
            this.zSort();
            this.needsZSort = false;
        }
        this.drawBefore();
        for (int i = 0; i < this.zSortedItems.size(); ++i) {
            MenuItem menuItem = this.zSortedItems.get(i);
            menuItem.draw();
        }
        this.drawAfter();
        this.drawnOnce = true;
    }

    protected void drawAfter() {
    }

    protected void drawBefore() {
    }

    protected void drawMyself() {
    }

    public MenuItem get(String string) {
        if (this.getName().equals(string)) {
            return this;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            MenuItem menuItem = this.items.get(i).get(string);
            if (menuItem == null) continue;
            return menuItem;
        }
        return null;
    }

    public Action getAction() {
        return this.action;
    }

    public boolean getCloseOnAction() {
        return true;
    }

    public PFont getFont() {
        return this.getStyle().getFont("font");
    }

    public float getFontSize() {
        return this.getStyle().getF("f.fontSize");
    }

    public float getHeight() {
        return this.height;
    }

    protected float getMaxHeight() {
        float f = 0.0f;
        for (int i = 0; i < this.items.size(); ++i) {
            MenuItem menuItem = this.items.get(i);
            float f2 = menuItem.getHeight();
            if (!(f2 > f)) continue;
            f = f2;
        }
        return f;
    }

    protected float getMaxWidth() {
        float f = 0.0f;
        for (int i = 0; i < this.items.size(); ++i) {
            MenuItem menuItem = this.items.get(i);
            float f2 = menuItem.width;
            if (!(f2 > f)) continue;
            f = f2;
        }
        return f;
    }

    public MenuItem getMenu() {
        return this.menu;
    }

    public String getName() {
        return this.name;
    }

    protected MenuItem getNearestMenu() {
        MenuItem menuItem = this;
        while (menuItem != null) {
            if (menuItem instanceof Menu) {
                this.nearestMenu = (Menu)menuItem;
                return this.nearestMenu;
            }
            menuItem = menuItem.parent;
        }
        return null;
    }

    public float getPadX() {
        return this.getStyle().getF("f.padX");
    }

    public float getPadY() {
        return this.getStyle().getF("f.padY");
    }

    protected void getRect(Rectangle2D.Float float_, Rectangle2D.Float float_2) {
        if (!this.isOpen()) {
            return;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            MenuItem menuItem = this.items.get(i);
            menuItem.getRect(float_, float_2);
        }
    }

    public MenuStyle getRootStyle() {
        return this.menu.getStyle();
    }

    public Shortcut getShortcut() {
        return this.shortcut;
    }

    protected int getState() {
        if (!this.isEnabled()) {
            return 3;
        }
        return this.state;
    }

    public Stroke getStroke() {
        return new BasicStroke(this.getStyle().getF("f.strokeWeight"));
    }

    public Color getStrokeColor() {
        if (!this.isEnabled()) {
            return this.getStyle().getC("c.foregroundDisabled");
        }
        return this.getStyle().getC("c.foreground");
    }

    public MenuStyle getStyle() {
        return this.style;
    }

    protected float getTextHeight() {
        int n = this.getStyle().getI("f.padY");
        PFont pFont = (PFont)this.getStyle().getO("font");
        float f = this.getStyle().getF("f.fontSize");
        return UIUtils.getTextHeight((PGraphics)this.menu.buff, pFont, f, this.name, true) + (float)(n * 2);
    }

    public float getWidth() {
        return this.width;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public boolean hasChildren() {
        return this.items.size() > 0;
    }

    public boolean hasOpenChildren() {
        for (int i = 0; i < this.items.size(); ++i) {
            MenuItem menuItem = this.items.get(i);
            if (!menuItem.isOpen()) continue;
            return true;
        }
        return false;
    }

    protected boolean isAncestorOf(MenuItem menuItem) {
        if (menuItem == null) {
            return false;
        }
        if (menuItem.parent == this) {
            return true;
        }
        boolean bl = false;
        for (int i = 0; i < this.items.size(); ++i) {
            MenuItem menuItem2 = this.items.get(i);
            if (!menuItem2.isAncestorOf(menuItem)) continue;
            bl = true;
        }
        return bl;
    }

    protected boolean isAncestorOfHovered() {
        if (this.menu == null) {
            return false;
        }
        if (this == this.menu.hovered) {
            return true;
        }
        return this.isAncestorOf(this.menu.hovered);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isOpen() {
        if (this.items.size() == 0) {
            return false;
        }
        return this.isOpen;
    }

    protected void itemMouseEvent(MouseEvent mouseEvent, Point point) {
        this.mouseInside = false;
        this.visibleMouseEvent(mouseEvent, point);
        if (this.isOpen()) {
            for (int i = this.zSortedItems.size() - 1; i >= 0; --i) {
                MenuItem menuItem = this.zSortedItems.get(i);
                if (mouseEvent.isConsumed()) continue;
                menuItem.itemMouseEvent(mouseEvent, point);
                if (!menuItem.mouseInside) continue;
                this.mouseInside = true;
            }
        }
        if (this.mouseInside && this.getZ() == 0) {
            this.setZ(1);
            if (this.parent != null) {
                this.parent.needsZSort = true;
            }
        } else if (!this.mouseInside && this.getZ() == 1) {
            this.setZ(0);
            if (this.parent != null) {
                this.parent.needsZSort = true;
            }
        }
        if (this.mouseInside && !this.isEnabled()) {
            this.menu.setCursor(0);
        }
    }

    public void keyEvent(KeyEvent keyEvent) {
        if (!this.isOpen()) {
            return;
        }
    }

    public boolean checkCondition() {
        if (this.condition != null) {
            return this.condition.isTrue();
        }
        return true;
    }

    public synchronized void layout() {
        this.setEnabled(this.checkCondition());
        for (int i = 0; i < this.items.size(); ++i) {
            MenuItem menuItem = this.items.get(i);
            if (menuItem.isHidden()) continue;
            menuItem.layout();
        }
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void focusEvent(FocusEvent focusEvent) {
    }

    public void mouseEvent(MouseEvent mouseEvent, Point point, Point point2) {
    }

    protected void menuTriggerLogic() {
        if (MenuItem.timer.item == this || !this.nearestMenu.clickToggles) {
            if (this.nearestMenu.singletNavigation && this.parent != null) {
                this.parent.closeMyChildren();
                this.menu.open(this);
            } else {
                this.menu.open(this);
            }
        } else if (this.nearestMenu.clickToggles) {
            if (this.nearestMenu.singletNavigation) {
                if (this.parent != null) {
                    if (this.isOpen()) {
                        this.parent.closeMyChildren();
                    } else {
                        this.parent.closeMyChildren();
                        this.menu.open(this);
                    }
                }
            } else {
                this.toggleChildren();
            }
        }
    }

    public void performAction() {
        if (this.items.size() > 0) {
            this.menuTriggerLogic();
        } else if (this.isEnabled()) {
            this.menu.fireEvent(7);
            if (this.getCloseOnAction()) {
                this.menu.clickaway();
            }
            if (this.action != null) {
                this.action.performAction();
            }
        }
    }

    public void remove(MenuItem menuItem) {
        this.items.remove(menuItem);
        this.zSortedItems.remove(menuItem);
        this.zSort();
        if (this.menu != null) {
            this.menu.layout();
        }
    }

    public MenuItem setAction(Object object, String string) {
        this.action = new Action(object, string);
        if (this.shortcut != null) {
            this.shortcut.action = this.action;
        }
        this.menu.layout();
        return this;
    }

    public MenuItem setCondition(Object object, String string) throws Exception {
        this.condition = new ConditionChecker(object, string);
        this.menu.layout();
        return this;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    protected boolean shouldPerformFill() {
        if (this.getState() != 0 || this.isOpen()) {
            if (!this.isEnabled()) {
                return false;
            }
            return this.menu.hovered == null || this.menu.hovered == this || this.isAncestorOfHovered();
        }
        return false;
    }

    public void setHeight(float f) {
        this.height = f;
    }

    protected void setMenu(Menu menu) {
        this.menu = menu;
        this.getNearestMenu();
        for (int i = 0; i < this.items.size(); ++i) {
            MenuItem menuItem = this.items.get(i);
            menuItem.setMenu(menu);
        }
    }

    public void setName(String string) {
        this.name = string;
    }

    protected void setParent(MenuItem menuItem) {
        this.parent = menuItem;
        this.getStyle().setParent(menuItem.getStyle());
        this.setMenu(menuItem.menu);
    }

    public void setPosition(float f, float f2) {
        this.setX(f);
        this.setY(f2);
        this.layout();
    }

    public MenuItem setShortcut(String string) {
        this.shortcut = UIGlobals.g.shortcuts().createShortcut(string);
        this.shortcut.action = this.action != null ? this.action : new Action(this, "performAction");
        this.menu.layout();
        return this;
    }

    public void setSize(float f, float f2) {
        this.setWidth(f);
        this.setHeight(f2);
    }

    protected void setState(int n) {
        this.state = n;
    }

    public void setWidth(float f) {
        this.width = f;
    }

    public void setX(float f) {
        this.x = f;
    }

    public void setY(float f) {
        this.y = f;
    }

    public void setZ(int n) {
        this.z = n;
    }

    protected void toggleChildren() {
        if (this.isOpen) {
            this.menu.close(this);
        } else {
            this.menu.open(this);
        }
    }

    public String toString() {
        return this.name;
    }

    protected void visibleMouseEvent(MouseEvent mouseEvent, Point point) {
        if (this.isHidden()) {
            return;
        }
        boolean bl = this.containsPoint(point);
        if (bl) {
            this.mouseInside = true;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (this.menu == null) {
            return;
        }
        switch (mouseEvent.getID()) {
            case 503: {
                if (bl) {
                    this.menu.setState(this, 1);
                    break;
                }
                this.menu.setState(this, 0);
                break;
            }
            case 501: {
                if (bl && this.nearestMenu.actionOnMouseDown) {
                    this.performAction();
                }
            }
            case 506: {
                if (bl) {
                    this.menu.setState(this, 2);
                    break;
                }
                this.menu.setState(this, 0);
                break;
            }
            case 502: {
                if (bl) {
                    if (!this.nearestMenu.actionOnMouseDown) {
                        this.performAction();
                    }
                    if (this.getState() != 2) break;
                    this.menu.setState(this, 1);
                    break;
                }
                this.menu.setState(this, 0);
            }
        }
    }

    public void setFontSize(float f) {
        this.getStyle().set("f.fontSize", Float.valueOf(f));
    }

    public void zSort() {
        if (zComp == null) {
            zComp = new ZDepthComparator();
        }
        Collections.sort(this.zSortedItems, zComp);
    }

    public void setHidden(boolean bl) {
        this.hidden = bl;
    }

    class ConditionChecker {
        String ifMethod;
        Object ifObject;
        Method methodCall;

        public ConditionChecker(Object object, String string) throws Exception {
            this.ifObject = object;
            this.ifMethod = string;
            this.methodCall = object.getClass().getMethod(string, new Class[0]);
        }

        public boolean isTrue() {
            if (this.methodCall != null) {
                try {
                    return (Boolean)this.methodCall.invoke(this.ifObject, new Object[0]);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return false;
                }
            }
            return false;
        }
    }

    public static class ZDepthComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            int n;
            MenuItem menuItem = (MenuItem)object;
            MenuItem menuItem2 = (MenuItem)object2;
            int n2 = menuItem.getZ();
            if (n2 > (n = menuItem2.getZ())) {
                return 1;
            }
            if (n2 < n) {
                return -1;
            }
            return 0;
        }
    }

    static class VisibleDepthComparator
    implements Comparator {
        VisibleDepthComparator() {
        }

        public int compare(Object object, Object object2) {
            int n;
            MenuItem menuItem = (MenuItem)object;
            MenuItem menuItem2 = (MenuItem)object2;
            int n2 = this.maxDepth(menuItem);
            if (n2 > (n = this.maxDepth(menuItem2))) {
                return -1;
            }
            if (n2 < n) {
                return 1;
            }
            return 0;
        }

        int maxDepth(MenuItem menuItem) {
            int n = 0;
            if (!menuItem.isOpen()) {
                n = 0;
            } else {
                for (int i = 0; i < menuItem.items.size(); ++i) {
                    MenuItem menuItem2 = menuItem.items.get(i);
                    int n2 = this.maxDepth(menuItem2);
                    if (n2 + 1 <= n) continue;
                    n = n2 + 1;
                }
            }
            return n;
        }
    }
}

